/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.reflection.standard.StandardMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.ServiceClassLoader;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.events.EventTemplateProvider;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.openspaces.remoting.AutowireArguments;
import org.openspaces.remoting.AutowireArgumentsMarker;
import org.openspaces.remoting.ExecutorRemotingTask;
import org.openspaces.remoting.HashedSpaceRemotingEntry;
import org.openspaces.remoting.RemotingServiceDetails;
import org.openspaces.remoting.RemotingServiceMonitors;
import org.openspaces.remoting.RemotingUtils;
import org.openspaces.remoting.ServiceExecutionAspect;
import org.openspaces.remoting.ServiceRef;
import org.openspaces.remoting.SpaceRemotingEntry;
import org.openspaces.remoting.SpaceRemotingEntryFactory;
import org.openspaces.remoting.SpaceRemotingEntryMetadataFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;

public class SpaceRemotingServiceExporter
implements SpaceDataEventListener<SpaceRemotingEntry>,
InitializingBean,
ApplicationContextAware,
BeanNameAware,
EventTemplateProvider,
ClusterInfoAware,
ApplicationListener,
ServiceDetailsProvider,
ServiceMonitorsProvider {
    public static final String DEFAULT_ASYNC_INTERFACE_SUFFIX = "Async";
    private static final Log logger = LogFactory.getLog(SpaceRemotingServiceExporter.class);
    private final SpaceRemotingEntryFactory remotingEntryFactory = new SpaceRemotingEntryMetadataFactory();
    private List<Object> services = new ArrayList<Object>();
    private final List<ServiceInfo> servicesInfo = new ArrayList<ServiceInfo>();
    private boolean useFastReflection = true;
    private final IdentityHashMap<Object, ServiceInfo> serviceToServiceInfoMap = new IdentityHashMap();
    private final AtomicLong processed = new AtomicLong();
    private final AtomicLong failed = new AtomicLong();
    private ApplicationContext applicationContext;
    private String beanName;
    private final Map<String, Object> interfaceToService = new HashMap<String, Object>();
    private String asyncInterfaceSuffix = "Async";
    private boolean fifo = false;
    private boolean disableAutowiredArguments = false;
    private ServiceExecutionAspect serviceExecutionAspect;
    private String templateLookupName;
    private ClusterInfo clusterInfo;
    private Map<String, Map<RemotingUtils.MethodHash, IMethod>> methodInvocationLookup;
    private final MethodInvocationCache methodInvocationCache = new MethodInvocationCache();
    private volatile boolean initialized = false;
    private final CountDownLatch initializationLatch = new CountDownLatch(1);

    public void setServices(List<Object> services) {
        this.services = services;
    }

    public void setAsyncInterfaceSuffix(String asyncInterfaceSuffix) {
        this.asyncInterfaceSuffix = asyncInterfaceSuffix;
    }

    public void setFifo(boolean fifo) {
        this.fifo = fifo;
    }

    public void setUseFastReflection(boolean userFastReflection) {
        this.useFastReflection = userFastReflection;
    }

    public void setDisableAutowiredArguments(boolean disableAutowiredArguments) {
        this.disableAutowiredArguments = disableAutowiredArguments;
    }

    public void setServiceExecutionAspect(ServiceExecutionAspect serviceExecutionAspect) {
        this.serviceExecutionAspect = serviceExecutionAspect;
    }

    public void setTemplateLookupName(String templateLookupName) {
        this.templateLookupName = templateLookupName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public void addService(String beanId, Object service) throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Can't add a service once the exporter has initialized");
        }
        this.servicesInfo.add(new ServiceInfo(beanId, service.getClass().getName(), service));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanName == null) {
            this.beanName = "serviceExporter";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            Assert.notNull(this.services, (String)"services property is required");
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            if (origClassLoader instanceof ServiceClassLoader && origClassLoader.getParent() instanceof ServiceClassLoader) {
                Thread.currentThread().setContextClassLoader(origClassLoader.getParent());
            }
            try {
                int naCounter = 0;
                for (Object service : this.services) {
                    if (service instanceof ServiceRef) {
                        String ref = ((ServiceRef)service).getRef();
                        service = this.applicationContext.getBean(ref);
                        this.servicesInfo.add(new ServiceInfo(ref, service.getClass().getName(), service));
                        continue;
                    }
                    this.servicesInfo.add(new ServiceInfo("NA" + ++naCounter, service.getClass().getName(), service));
                }
                this.methodInvocationLookup = new HashMap<String, Map<RemotingUtils.MethodHash, IMethod>>();
                for (ServiceInfo serviceInfo : this.servicesInfo) {
                    Set interfaces = ReflectionUtil.getAllInterfacesForClassAsSet(serviceInfo.getService().getClass());
                    for (Class anInterface : interfaces) {
                        this.interfaceToService.put(anInterface.getName(), serviceInfo.getService());
                        this.methodInvocationLookup.put(anInterface.getName(), RemotingUtils.buildHashToMethodLookupForInterface(anInterface, this.useFastReflection));
                        this.methodInvocationCache.addService(anInterface, serviceInfo.getService(), this.useFastReflection);
                    }
                    this.serviceToServiceInfoMap.put(serviceInfo.getService(), serviceInfo);
                }
                this.initialized = true;
                this.initializationLatch.countDown();
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
    }

    @Override
    public Object getTemplate() {
        SpaceRemotingEntry remotingEntry = this.remotingEntryFactory.createEntry();
        remotingEntry.setInvocation(Boolean.TRUE);
        remotingEntry.setFifo(this.fifo);
        remotingEntry.setLookupName(this.templateLookupName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering async remoting service template [" + remotingEntry + "]"));
        }
        return remotingEntry;
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        ArrayList<RemotingServiceDetails.RemoteService> remoteServices = new ArrayList<RemotingServiceDetails.RemoteService>();
        for (ServiceInfo serviceInfo : this.servicesInfo) {
            remoteServices.add(new RemotingServiceDetails.RemoteService(serviceInfo.getBeanId(), serviceInfo.getClassName()));
        }
        return new ServiceDetails[]{new RemotingServiceDetails(this.beanName, remoteServices.toArray(new RemotingServiceDetails.RemoteService[remoteServices.size()]))};
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        ArrayList<RemotingServiceMonitors.RemoteServiceStats> remoteServiceStats = new ArrayList<RemotingServiceMonitors.RemoteServiceStats>();
        for (ServiceInfo serviceInfo : this.servicesInfo) {
            remoteServiceStats.add(new RemotingServiceMonitors.RemoteServiceStats(serviceInfo.getBeanId(), serviceInfo.getProcessed().get(), serviceInfo.getFailures().get()));
        }
        return new ServiceMonitors[]{new RemotingServiceMonitors(this.beanName, this.processed.get(), this.failed.get(), remoteServiceStats.toArray(new RemotingServiceMonitors.RemoteServiceStats[remoteServiceStats.size()]))};
    }

    @Override
    public void onEvent(SpaceRemotingEntry remotingEntry, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) throws RemoteAccessException {
        Object service;
        this.waitTillInitialized();
        String lookupName = remotingEntry.getLookupName();
        if (lookupName.endsWith(this.asyncInterfaceSuffix)) {
            lookupName = lookupName.substring(0, lookupName.length() - this.asyncInterfaceSuffix.length());
        }
        if ((service = this.interfaceToService.get(lookupName)) == null) {
            try {
                service = this.applicationContext.getBean(lookupName);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            if (service == null) {
                this.writeResponse(gigaSpace, remotingEntry, (Throwable)new RemoteLookupFailureException("Failed to find service for lookup [" + remotingEntry.getLookupName() + "]"));
                return;
            }
        }
        this.autowireArguments(service, remotingEntry.getArguments());
        IMethod method = null;
        try {
            if (remotingEntry instanceof HashedSpaceRemotingEntry && ((HashedSpaceRemotingEntry)remotingEntry).getMethodHash() != null) {
                method = this.methodInvocationLookup.get(lookupName).get(((HashedSpaceRemotingEntry)remotingEntry).getMethodHash());
            }
            if (method == null) {
                method = this.methodInvocationCache.findMethod(lookupName, service, remotingEntry.getMethodName(), remotingEntry.getArguments());
            }
        }
        catch (Exception e) {
            this.failedExecution(service);
            this.writeResponse(gigaSpace, remotingEntry, (Throwable)new RemoteLookupFailureException("Failed to find method [" + remotingEntry.getMethodName() + "] for lookup [" + remotingEntry.getLookupName() + "]", (Throwable)e));
            return;
        }
        try {
            Object retVal = this.serviceExecutionAspect != null ? this.serviceExecutionAspect.invoke(remotingEntry, new InternalMethodInvocation(method), service) : method.invoke(service, remotingEntry.getArguments());
            this.writeResponse(gigaSpace, remotingEntry, retVal);
            this.processedExecution(service);
        }
        catch (InvocationTargetException e) {
            this.failedExecution(service);
            this.writeResponse(gigaSpace, remotingEntry, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            this.failedExecution(service);
            this.writeResponse(gigaSpace, remotingEntry, (Throwable)new RemoteLookupFailureException("Failed to access method [" + remotingEntry.getMethodName() + "] for lookup [" + remotingEntry.getLookupName() + "]", (Throwable)e));
        }
        catch (Throwable e) {
            this.failedExecution(service);
            this.writeResponse(gigaSpace, remotingEntry, e);
        }
    }

    private void writeResponse(GigaSpace gigaSpace, SpaceRemotingEntry remotingEntry, Throwable e) {
        if (remotingEntry.getOneWay() == null || !remotingEntry.getOneWay().booleanValue()) {
            SpaceRemotingEntry result = remotingEntry.buildResult(e);
            if (this.clusterInfo != null) {
                result.setInstanceId(this.clusterInfo.getInstanceId());
            }
            gigaSpace.write(result);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Remoting execution is configured as one way and an exception was thrown", e);
        }
    }

    private void writeResponse(GigaSpace gigaSpace, SpaceRemotingEntry remotingEntry, Object retVal) {
        if (remotingEntry.getOneWay() == null || !remotingEntry.getOneWay().booleanValue()) {
            SpaceRemotingEntry result = remotingEntry.buildResult(retVal);
            if (this.clusterInfo != null) {
                result.setInstanceId(this.clusterInfo.getInstanceId());
            }
            gigaSpace.write(result);
        }
    }

    private void autowireArguments(Object service, Object[] args) {
        if (this.disableAutowiredArguments) {
            return;
        }
        if (args == null) {
            return;
        }
        if (this.shouldAutowire(service)) {
            for (Object arg : args) {
                if (arg == null) continue;
                AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
                beanFactory.autowireBeanProperties(arg, 0, false);
                beanFactory.initializeBean(arg, arg.getClass().getName());
            }
        }
    }

    private boolean shouldAutowire(Object service) {
        if (service instanceof AutowireArgumentsMarker) {
            return true;
        }
        if (service.getClass().isAnnotationPresent(AutowireArguments.class)) {
            return true;
        }
        for (Class<?> clazz : service.getClass().getInterfaces()) {
            if (!clazz.isAnnotationPresent(AutowireArguments.class)) continue;
            return true;
        }
        return false;
    }

    public Object invokeExecutor(ExecutorRemotingTask task) throws Throwable {
        Object service;
        this.waitTillInitialized();
        String lookupName = task.getLookupName();
        if (lookupName.endsWith(this.asyncInterfaceSuffix)) {
            lookupName = lookupName.substring(0, lookupName.length() - this.asyncInterfaceSuffix.length());
        }
        if ((service = this.interfaceToService.get(lookupName)) == null) {
            try {
                service = this.applicationContext.getBean(lookupName);
            }
            catch (NoSuchBeanDefinitionException e) {
                throw new RemoteLookupFailureException("Failed to find service for lookup [" + lookupName + "]", (Throwable)e);
            }
            if (service == null) {
                throw new RemoteLookupFailureException("Failed to find service for lookup [" + lookupName + "]");
            }
        }
        this.autowireArguments(service, task.getArguments());
        IMethod method = null;
        try {
            if (task.getMethodHash() != null) {
                method = this.methodInvocationLookup.get(lookupName).get(task.getMethodHash());
            }
            if (method == null) {
                method = this.methodInvocationCache.findMethod(lookupName, service, task.getMethodName(), task.getArguments());
            }
        }
        catch (Exception e) {
            this.failedExecution(service);
            throw new RemoteLookupFailureException("Failed to find method [" + task.getMethodName() + "] for lookup [" + task.getLookupName() + "]", (Throwable)e);
        }
        try {
            Object retVal = this.serviceExecutionAspect != null ? this.serviceExecutionAspect.invoke(task, new InternalMethodInvocation(method), service) : method.invoke(service, task.getArguments());
            this.processedExecution(service);
            return retVal;
        }
        catch (InvocationTargetException e) {
            this.failedExecution(service);
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            this.failedExecution(service);
            throw new RemoteLookupFailureException("Failed to access method [" + task.getMethodName() + "] for lookup [" + task.getLookupName() + "]");
        }
    }

    private void processedExecution(Object service) {
        this.processed.incrementAndGet();
        this.serviceToServiceInfoMap.get(service).getProcessed().incrementAndGet();
    }

    private void failedExecution(Object service) {
        this.failed.incrementAndGet();
        this.serviceToServiceInfoMap.get(service).getFailures().incrementAndGet();
    }

    private void waitTillInitialized() throws RemoteLookupFailureException {
        if (this.initialized) {
            return;
        }
        try {
            this.initializationLatch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RemoteLookupFailureException("Space remoting service exporter interrupted while waiting for initialization", (Throwable)e);
        }
        if (!this.initialized) {
            throw new RemoteLookupFailureException("Space remoting service exporter not initialized yet");
        }
    }

    private static class InternalMethodInvocation
    implements ServiceExecutionAspect.MethodInvocation {
        private final IMethod method;

        private InternalMethodInvocation(IMethod method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.method.invoke(obj, args);
        }

        @Override
        public Method getMethod() {
            return this.method.getMethod();
        }
    }

    private static class ServiceInfo {
        private final String beanId;
        private final String className;
        private final Object service;
        private final AtomicLong processed = new AtomicLong();
        private final AtomicLong failures = new AtomicLong();

        private ServiceInfo(String beanId, String className, Object service) {
            this.beanId = beanId;
            this.className = className;
            this.service = service;
        }

        public String getBeanId() {
            return this.beanId;
        }

        public String getClassName() {
            return this.className;
        }

        public Object getService() {
            return this.service;
        }

        public AtomicLong getProcessed() {
            return this.processed;
        }

        public AtomicLong getFailures() {
            return this.failures;
        }
    }

    private static class MethodInvocationCache {
        private final Map<String, MethodsCacheEntry> serviceToMethodCacheMap = new HashMap<String, MethodsCacheEntry>();

        private MethodInvocationCache() {
        }

        public IMethod findMethod(String lookupName, Object service, String methodName, Object[] arguments) throws NoSuchMethodException {
            IMethod invocationMethod;
            IMethod[] methods;
            int numberOfParameters = 0;
            if (arguments != null) {
                numberOfParameters = arguments.length;
            }
            if ((methods = this.serviceToMethodCacheMap.get(lookupName).getMethodCacheEntry(methodName).getMethod(numberOfParameters)) != null && methods.length == 1) {
                invocationMethod = methods[0];
            } else {
                if (arguments == null) {
                    arguments = new Object[]{};
                }
                Class[] argumentTypes = new Class[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    argumentTypes[i] = arguments[i] != null ? arguments[i].getClass() : Object.class;
                }
                invocationMethod = new StandardMethod(service.getClass().getMethod(methodName, argumentTypes));
            }
            return invocationMethod;
        }

        public void addService(Class serviceInterface, Object service, boolean useFastReflection) {
            MethodsCacheEntry methodsCacheEntry = new MethodsCacheEntry();
            this.serviceToMethodCacheMap.put(serviceInterface.getName(), methodsCacheEntry);
            methodsCacheEntry.addService(service.getClass(), useFastReflection);
        }

        private static class MethodCacheEntry {
            private Map<Integer, IMethod[]> parametersPerMethodMap = new HashMap<Integer, IMethod[]>();

            private MethodCacheEntry() {
            }

            public IMethod[] getMethod(int numberOfParams) {
                return this.parametersPerMethodMap.get(numberOfParams);
            }

            public void addMethod(Method method, boolean useFastReflection) {
                Object fastMethod = useFastReflection ? ReflectionUtil.createMethod((Method)method) : new StandardMethod(method);
                IMethod[] list = this.parametersPerMethodMap.get(method.getParameterTypes().length);
                if (list == null) {
                    list = new IMethod[]{fastMethod};
                } else {
                    IMethod[] tempList = new IMethod[list.length + 1];
                    System.arraycopy(list, 0, tempList, 0, list.length);
                    tempList[list.length] = fastMethod;
                    list = tempList;
                }
                this.parametersPerMethodMap.put(method.getParameterTypes().length, list);
            }
        }

        private static class MethodsCacheEntry {
            private Map<String, MethodCacheEntry> methodNameMap = new HashMap<String, MethodCacheEntry>();

            private MethodsCacheEntry() {
            }

            public MethodCacheEntry getMethodCacheEntry(String methodName) {
                return this.methodNameMap.get(methodName);
            }

            public void addService(Class service, boolean useFastReflection) {
                Method[] methods;
                for (Method method : methods = service.getMethods()) {
                    MethodCacheEntry methodCacheEntry = this.methodNameMap.get(method.getName());
                    if (methodCacheEntry == null) {
                        methodCacheEntry = new MethodCacheEntry();
                        this.methodNameMap.put(method.getName(), methodCacheEntry);
                    }
                    methodCacheEntry.addMethod(method, useFastReflection);
                }
            }
        }
    }
}

