/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.config;

import org.openspaces.remoting.EventDrivenSpaceRemotingProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EventDrivenProxyBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String GIGA_SPACE = "giga-space";
    private static final String INTERFACE = "interface";
    private static final String VOID_ONE_WAY = "void-one-way";
    private static final String GLOBAL_ONE_WAY = "global-one-way";
    private static final String FIFO = "fifo";
    private static final String TIMEOUT = "timeout";
    private static final String ROUTING_HANDLER = "routing-handler";
    private static final String META_ARGUMENT_HANDLER = "meta-arguments-handler";
    private static final String ASPECT = "aspect";

    protected Class<EventDrivenSpaceRemotingProxyFactoryBean> getBeanClass(Element element) {
        return EventDrivenSpaceRemotingProxyFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element metaArguemntsHandlerEle;
        Element routingHandlerEle;
        Element aspectEle;
        String timeout;
        String fifo;
        String globalOneWay;
        super.doParse(element, parserContext, builder);
        String gigaSpace = element.getAttribute(GIGA_SPACE);
        builder.addPropertyReference("gigaSpace", gigaSpace);
        String inter = element.getAttribute(INTERFACE);
        builder.addPropertyValue("serviceInterface", (Object)inter);
        String voidOneWay = element.getAttribute(VOID_ONE_WAY);
        if (StringUtils.hasLength((String)voidOneWay)) {
            builder.addPropertyValue("voidOneWay", (Object)voidOneWay);
        }
        if (StringUtils.hasLength((String)(globalOneWay = element.getAttribute(GLOBAL_ONE_WAY)))) {
            builder.addPropertyValue("globalOneWay", (Object)globalOneWay);
        }
        if (StringUtils.hasLength((String)(fifo = element.getAttribute(FIFO)))) {
            builder.addPropertyValue(FIFO, (Object)fifo);
        }
        if (StringUtils.hasLength((String)(timeout = element.getAttribute(TIMEOUT)))) {
            builder.addPropertyValue(TIMEOUT, (Object)timeout);
        }
        if ((aspectEle = DomUtils.getChildElementByTagName((Element)element, (String)ASPECT)) != null) {
            builder.addPropertyValue("remoteInvocationAspect", parserContext.getDelegate().parsePropertyValue(aspectEle, (BeanDefinition)builder.getRawBeanDefinition(), "remoteInvocationAspect"));
        }
        if ((routingHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)ROUTING_HANDLER)) != null) {
            builder.addPropertyValue("remoteRoutingHandler", parserContext.getDelegate().parsePropertyValue(routingHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "remoteRoutingHandler"));
        }
        if ((metaArguemntsHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)META_ARGUMENT_HANDLER)) != null) {
            builder.addPropertyValue("metaArgumentsHandler", parserContext.getDelegate().parsePropertyValue(metaArguemntsHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "metaArgumentsHandler"));
        }
    }
}

