/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.config;

import org.openspaces.remoting.ExecutorSpaceRemotingProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ExecutorProxyBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String GIGA_SPACE = "giga-space";
    private static final String INTERFACE = "interface";
    private static final String BROADCAST = "broadcast";
    private static final String RETURN_FIRST_RESULT = "return-first-result";
    private static final String ROUTING_HANDLER = "routing-handler";
    private static final String META_ARGUMENT_HANDLER = "meta-arguments-handler";
    private static final String RESULT_REDUCER = "result-reducer";
    private static final String ASPECT = "aspect";
    private static final String TIMEOUT = "timeout";

    protected Class<ExecutorSpaceRemotingProxyFactoryBean> getBeanClass(Element element) {
        return ExecutorSpaceRemotingProxyFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element metaArguemntsHandlerEle;
        Element resultReducerEle;
        Element aspectEle;
        Element routingHandlerEle;
        String returnFirstResult;
        String timeout;
        super.doParse(element, parserContext, builder);
        String gigaSpace = element.getAttribute(GIGA_SPACE);
        builder.addPropertyReference("gigaSpace", gigaSpace);
        String inter = element.getAttribute(INTERFACE);
        builder.addPropertyValue("serviceInterface", (Object)inter);
        String broadcast = element.getAttribute(BROADCAST);
        if (StringUtils.hasLength((String)broadcast)) {
            builder.addPropertyValue(BROADCAST, (Object)broadcast);
        }
        if (StringUtils.hasLength((String)(timeout = element.getAttribute(TIMEOUT)))) {
            builder.addPropertyValue(TIMEOUT, (Object)timeout);
        }
        if (StringUtils.hasLength((String)(returnFirstResult = element.getAttribute(RETURN_FIRST_RESULT)))) {
            builder.addPropertyValue("returnFirstResult", (Object)returnFirstResult);
        }
        if ((routingHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)ROUTING_HANDLER)) != null) {
            builder.addPropertyValue("remoteRoutingHandler", parserContext.getDelegate().parsePropertyValue(routingHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "remoteRoutingHandler"));
        }
        if ((aspectEle = DomUtils.getChildElementByTagName((Element)element, (String)ASPECT)) != null) {
            builder.addPropertyValue("remoteInvocationAspect", parserContext.getDelegate().parsePropertyValue(aspectEle, (BeanDefinition)builder.getRawBeanDefinition(), "remoteInvocationAspect"));
        }
        if ((resultReducerEle = DomUtils.getChildElementByTagName((Element)element, (String)RESULT_REDUCER)) != null) {
            builder.addPropertyValue("remoteResultReducer", parserContext.getDelegate().parsePropertyValue(resultReducerEle, (BeanDefinition)builder.getRawBeanDefinition(), "remoteResultReducer"));
        }
        if ((metaArguemntsHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)META_ARGUMENT_HANDLER)) != null) {
            builder.addPropertyValue("metaArgumentsHandler", parserContext.getDelegate().parsePropertyValue(metaArguemntsHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "metaArgumentsHandler"));
        }
    }
}

