/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.config;

import java.util.List;
import org.openspaces.remoting.ServiceRef;
import org.openspaces.remoting.SpaceRemotingServiceExporter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ServiceExporterBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String SERVICE = "service";
    private static final String ASPECT = "aspect";

    protected Class<SpaceRemotingServiceExporter> getBeanClass(Element element) {
        return SpaceRemotingServiceExporter.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element aspectEle;
        super.doParse(element, parserContext, builder);
        String templateLookupName = element.getAttribute("template-lookup-name");
        if (StringUtils.hasLength((String)templateLookupName)) {
            builder.addPropertyValue("templateLookupName", (Object)templateLookupName);
        }
        if ((aspectEle = DomUtils.getChildElementByTagName((Element)element, (String)ASPECT)) != null) {
            builder.addPropertyValue("serviceExecutionAspect", parserContext.getDelegate().parsePropertyValue(aspectEle, (BeanDefinition)builder.getRawBeanDefinition(), "serviceExecutionAspect"));
        }
        List serviceElements = DomUtils.getChildElementsByTagName((Element)element, (String)SERVICE);
        ManagedList list = new ManagedList(serviceElements.size());
        for (Element ele : serviceElements) {
            String ref = ele.getAttribute("ref");
            if (ref != null) {
                list.add((Object)new ServiceRef(ref));
                continue;
            }
            list.add(parserContext.getDelegate().parsePropertyValue(ele, (BeanDefinition)builder.getRawBeanDefinition(), null));
        }
        builder.addPropertyValue("services", (Object)list);
    }
}

