/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.remoting.scripting.LocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptingException;
import org.openspaces.remoting.scripting.ScriptingExecutor;
import org.openspaces.remoting.scripting.TypedScript;
import org.openspaces.remoting.scripting.cache.CompiledScriptCache;
import org.openspaces.remoting.scripting.cache.LRUNonThreadSafeCompiledScriptCache;
import org.openspaces.remoting.scripting.cache.LRUThreadSafeCompiledScriptCache;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ClassUtils;

public class DefaultScriptingExecutor
implements ScriptingExecutor,
ApplicationContextAware,
InitializingBean,
ApplicationListener,
ClusterInfoAware {
    private static final Log logger = LogFactory.getLog(DefaultScriptingExecutor.class);
    public static final String APPLICATION_CONTEXT_KEY = "applicationContext";
    public static final String CLUSTER_INFO_KEY = "clusterInfo";
    public static final String GROOVY_LOCAL_EXECUTOR_TYPE = "groovy";
    public static final String JRUBY_LOCAL_EXECUTOR_TYPE = "ruby";
    private ApplicationContext applicationContext;
    private Map<String, Object> parameters;
    private Map<String, Class<?>> parameterTypes;
    private Map<String, LocalScriptExecutor> executors = new HashMap<String, LocalScriptExecutor>();
    private LocalScriptExecutor jsr223Executor;
    private CompiledScriptCache threadSafeCompiledScriptCache;
    private CompiledScriptCache nonThreadSafeCopmiledScriptCache;
    private final Map<String, GigaSpace> gigaSpacesBeans = new HashMap<String, GigaSpace>();
    private ClusterInfo clusterInfo;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameterTypes(Map<String, Class<?>> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setExecutors(Map<String, LocalScriptExecutor> executors) {
        this.executors = executors;
    }

    public void setThreadSafeCompiledScriptCache(CompiledScriptCache threadSafeCompiledScriptCache) {
        this.threadSafeCompiledScriptCache = threadSafeCompiledScriptCache;
    }

    public void setNonThreadSafeCopmiledScriptCache(CompiledScriptCache nonThreadSafeCopmiledScriptCache) {
        this.nonThreadSafeCopmiledScriptCache = nonThreadSafeCopmiledScriptCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.executors.containsKey(GROOVY_LOCAL_EXECUTOR_TYPE)) {
            try {
                LocalScriptExecutor groovyExecutor = (LocalScriptExecutor)ClassUtils.forName((String)"org.openspaces.remoting.scripting.GroovyLocalScriptExecutor", (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance();
                this.executors.put(GROOVY_LOCAL_EXECUTOR_TYPE, groovyExecutor);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Groovy detected in the classpath, adding it as a local executor under the [groovy] type");
                }
            }
            catch (Error groovyExecutor) {
                // empty catch block
            }
        }
        if (!this.executors.containsKey(JRUBY_LOCAL_EXECUTOR_TYPE)) {
            try {
                LocalScriptExecutor jrubyExecutor = (LocalScriptExecutor)ClassUtils.forName((String)"org.openspaces.remoting.scripting.JRubyLocalScriptExecutor", (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance();
                this.executors.put(JRUBY_LOCAL_EXECUTOR_TYPE, jrubyExecutor);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"JRuby detected in the classpath, adding it as a local executor under the [ruby] type");
                }
            }
            catch (Error error) {
                // empty catch block
            }
        }
        try {
            this.jsr223Executor = (LocalScriptExecutor)ClassUtils.forName((String)"org.openspaces.remoting.scripting.Jsr223LocalScriptExecutor", (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Java 6 (JSR 223) detected in the classpath, adding it as a default executor");
            }
        }
        catch (Error error) {
            // empty catch block
        }
        if (this.executors.size() == 0 && this.jsr223Executor == null) {
            logger.info((Object)"No local script executors are configured or automatically detected");
        }
        if (this.threadSafeCompiledScriptCache == null) {
            this.threadSafeCompiledScriptCache = new LRUThreadSafeCompiledScriptCache();
        }
        if (this.nonThreadSafeCopmiledScriptCache == null) {
            this.nonThreadSafeCopmiledScriptCache = new LRUNonThreadSafeCompiledScriptCache();
        }
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        Map gigaBeans;
        if (applicationEvent instanceof ContextRefreshedEvent && (gigaBeans = this.applicationContext.getBeansOfType(GigaSpace.class)) != null) {
            for (Map.Entry entry : gigaBeans.entrySet()) {
                this.gigaSpacesBeans.put((String)entry.getKey(), (GigaSpace)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Script script) throws ScriptingException {
        if (script.getType() == null) {
            throw new IllegalArgumentException("Script must contain type");
        }
        LocalScriptExecutor localScriptExecutor = this.executors.get(script.getType());
        if (localScriptExecutor == null && (localScriptExecutor = this.jsr223Executor) == null) {
            throw new ScriptingException("Failed to find executor for type [" + script.getType() + "]");
        }
        HashMap<String, Object> scriptParams = new HashMap<String, Object>();
        if (this.parameters != null) {
            scriptParams.putAll(this.parameters);
        }
        scriptParams.putAll(this.gigaSpacesBeans);
        scriptParams.put(APPLICATION_CONTEXT_KEY, this.applicationContext);
        scriptParams.put(CLUSTER_INFO_KEY, this.clusterInfo);
        if (script.getParameters() != null) {
            scriptParams.putAll(script.getParameters());
        }
        if (script instanceof TypedScript) {
            TypedScript typedScript = (TypedScript)script;
            Map<String, Class<?>> scriptParameterTypes = typedScript.getParameterTypes();
            if (scriptParameterTypes == null) {
                throw new ScriptingException("parameterTypes cannot be null for typed script");
            }
            if (this.parameterTypes != null) {
                for (Map.Entry<Object, Object> entry : this.parameterTypes.entrySet()) {
                    if (scriptParameterTypes.containsKey(entry.getKey())) continue;
                    scriptParameterTypes.put((String)entry.getKey(), (Class<?>)entry.getValue());
                }
            }
            for (Map.Entry<Object, Object> entry : scriptParams.entrySet()) {
                if (scriptParameterTypes.containsKey(entry.getKey())) continue;
                Class<Object> paramType = entry.getValue() != null ? entry.getValue().getClass() : Object.class;
                scriptParameterTypes.put((String)entry.getKey(), paramType);
            }
        }
        Object compiledScript = script.shouldCache() ? (localScriptExecutor.isThreadSafe() ? this.threadSafeCompiledScriptCache.get(script.getName(), localScriptExecutor, script) : this.nonThreadSafeCopmiledScriptCache.get(script.getName(), localScriptExecutor, script)) : localScriptExecutor.compile(script);
        try {
            Object object = localScriptExecutor.execute(script, compiledScript, scriptParams);
            return object;
        }
        finally {
            if (script.shouldCache()) {
                if (localScriptExecutor.isThreadSafe()) {
                    this.threadSafeCompiledScriptCache.put(script.getName(), compiledScript, localScriptExecutor);
                } else {
                    this.nonThreadSafeCopmiledScriptCache.put(script.getName(), compiledScript, localScriptExecutor);
                }
            } else {
                localScriptExecutor.close(compiledScript);
            }
        }
    }

    public Future asyncExecute(Script script) throws ScriptingException {
        return null;
    }
}

