/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openspaces.remoting.scripting.AbstractLocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptCompilationException;
import org.openspaces.remoting.scripting.ScriptExecutionException;
import org.openspaces.remoting.scripting.ScriptingException;

public class Jsr223LocalScriptExecutor
extends AbstractLocalScriptExecutor<Object> {
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager(Thread.currentThread().getContextClassLoader());

    @Override
    public Object doCompile(Script script) throws ScriptCompilationException {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(script.getType());
        if (scriptEngine == null) {
            throw new ScriptingException("Failed to find script engine for type [" + script.getType() + "] with Jsr223 support");
        }
        if (scriptEngine instanceof Compilable) {
            try {
                return ((Compilable)((Object)scriptEngine)).compile(script.getScriptAsString());
            }
            catch (ScriptException e) {
                throw new ScriptCompilationException("Failed to compile script [" + script.getName() + "]: " + e.getMessage());
            }
        }
        return scriptEngine;
    }

    @Override
    public Object execute(Script script, Object compiledScript, Map<String, Object> parameters) throws ScriptExecutionException {
        if (compiledScript instanceof ScriptEngine) {
            ScriptEngine scriptEngine = (ScriptEngine)compiledScript;
            Bindings bindings = scriptEngine.createBindings();
            if (parameters != null) {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    bindings.put(entry.getKey(), entry.getValue());
                }
            }
            try {
                return scriptEngine.eval(script.getScriptAsString(), bindings);
            }
            catch (ScriptException e) {
                throw new ScriptExecutionException("Failed to execute script [" + script.getName() + "]", e);
            }
        }
        CompiledScript cmpScript = (CompiledScript)compiledScript;
        Bindings bindings = cmpScript.getEngine().createBindings();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                bindings.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            return cmpScript.eval(bindings);
        }
        catch (ScriptException e) {
            throw new ScriptExecutionException("Failed to execute script [" + script.getName() + "]", e);
        }
    }

    @Override
    public void close(Object compiledScript) {
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }
}

