/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import org.aopalliance.intercept.MethodInvocation;
import org.openspaces.remoting.RemoteInvocationAspect;
import org.openspaces.remoting.RemotingInvoker;
import org.openspaces.remoting.scripting.LazyLoadingScript;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptNotLoadedException;
import org.openspaces.remoting.scripting.ScriptingException;

public class LazyLoadingRemoteInvocationAspect
implements RemoteInvocationAspect {
    public Object invoke(MethodInvocation methodInvocation, RemotingInvoker remotingInvoker) throws Throwable {
        if (methodInvocation.getMethod().getName().equals("toString")) {
            return remotingInvoker.toString();
        }
        if (methodInvocation.getArguments().length == 0) {
            throw new ScriptingException("Lazy loading aspect only supports ScriptingExecution");
        }
        Script script = (Script)methodInvocation.getArguments()[0];
        if (!(script instanceof LazyLoadingScript)) {
            return remotingInvoker.invokeRemote(methodInvocation);
        }
        LazyLoadingScript lazyLoadingScript = (LazyLoadingScript)script;
        try {
            if (!lazyLoadingScript.shouldCache()) {
                lazyLoadingScript.loadScript();
            }
            return remotingInvoker.invokeRemote(methodInvocation);
        }
        catch (ScriptNotLoadedException e) {
            lazyLoadingScript.loadScript();
            return remotingInvoker.invokeRemote(methodInvocation);
        }
    }
}

