/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.remoting.RemoteResultReducer;
import org.openspaces.remoting.scripting.LazyLoadingScript;
import org.openspaces.remoting.scripting.ScriptNotLoadedException;
import org.openspaces.remoting.scripting.ScriptingException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.FileCopyUtils;

public class ResourceLazyLoadingScript
implements LazyLoadingScript,
Externalizable {
    private static final long serialVersionUID = -2086880053176632088L;
    private String name;
    private String type;
    private String script;
    private String resourceLocation;
    private Map<String, Object> parameters;
    private boolean shouldCache = true;
    private Boolean broadcast;
    private RemoteResultReducer remoteResultReducer;
    private Object routing;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Object[] metaArguments;

    public ResourceLazyLoadingScript() {
    }

    public ResourceLazyLoadingScript(String name, String type, String resoruceLocation) {
        this.name = name;
        this.type = type;
        this.resourceLocation = resoruceLocation;
    }

    @Override
    public String getScriptAsString() {
        if (this.script != null) {
            return this.script;
        }
        throw new ScriptNotLoadedException("Script [" + this.getName() + "] not loaded");
    }

    @Override
    public boolean hasScript() {
        return this.script != null;
    }

    @Override
    public void loadScript() {
        if (this.script != null) {
            return;
        }
        try {
            this.script = FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(this.resourceLoader.getResource(this.resourceLocation).getInputStream())));
        }
        catch (IOException e) {
            throw new ScriptingException("Failed to load script resource [" + this.resourceLocation + "]", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean shouldCache() {
        return this.shouldCache;
    }

    @Override
    public Object getRouting() {
        return this.routing;
    }

    @Override
    public RemoteResultReducer getReducer() {
        return this.remoteResultReducer;
    }

    @Override
    public Boolean shouldBroadcast() {
        return this.broadcast;
    }

    @Override
    public Object[] getMetaArguments() {
        return this.metaArguments;
    }

    public ResourceLazyLoadingScript name(String name) {
        this.name = name;
        return this;
    }

    public ResourceLazyLoadingScript script(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public ResourceLazyLoadingScript type(String type) {
        this.type = type;
        return this;
    }

    public ResourceLazyLoadingScript cache(boolean shouldCache) {
        this.shouldCache = shouldCache;
        return this;
    }

    public ResourceLazyLoadingScript parameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
        return this;
    }

    public ResourceLazyLoadingScript routing(Object routing) {
        this.routing = routing;
        return this;
    }

    public <T, Y> ResourceLazyLoadingScript broadcast(RemoteResultReducer<T, Y> reducer) {
        this.broadcast = true;
        this.remoteResultReducer = reducer;
        return this;
    }

    public ResourceLazyLoadingScript metaArguments(Object ... metaArguments) {
        this.metaArguments = metaArguments;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.type);
        if (this.script == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.script);
        }
        out.writeBoolean(this.shouldCache);
        if (this.parameters == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeShort(this.parameters.size());
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.type = in.readUTF();
        if (in.readBoolean()) {
            this.script = (String)in.readObject();
        }
        this.shouldCache = in.readBoolean();
        if (in.readBoolean()) {
            int size = in.readShort();
            this.parameters = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = in.readObject();
                this.parameters.put(key, value);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceLazyLoadingScript name[").append(this.getName()).append("]");
        sb.append(" type [").append(this.getType()).append("]");
        sb.append(" resource location [").append(this.resourceLocation).append("]");
        sb.append(" script [").append(this.script).append("]");
        sb.append(" parameters [").append(this.parameters).append("]");
        return sb.toString();
    }
}

