/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openspaces.remoting.scripting.ScriptExecutionException;
import org.openspaces.remoting.scripting.ScriptingException;
import org.openspaces.remoting.scripting.StaticScript;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.FileCopyUtils;

public class StaticResourceScript
extends StaticScript {
    private static final long serialVersionUID = 3171153261690141988L;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public StaticResourceScript() {
    }

    public StaticResourceScript(String name, String type, String resourceLocation) {
        this.script(resourceLocation);
        this.type(type);
        this.name(name);
    }

    @Override
    public StaticScript script(String resourceLocation) {
        super.script(this.loadResource(this.resourceLoader.getResource(resourceLocation)));
        return this;
    }

    private String loadResource(Resource resource) throws ScriptExecutionException {
        try {
            return FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(resource.getInputStream())));
        }
        catch (IOException e) {
            throw new ScriptingException("Failed to load script resource [" + resource + "]", e);
        }
    }
}

