/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.remoting.RemoteResultReducer;
import org.openspaces.remoting.scripting.Script;

public class StaticScript
implements Script,
Externalizable {
    private static final long serialVersionUID = -5652707951323528455L;
    private String name;
    private String type;
    private String script;
    private Map<String, Object> parameters;
    private boolean shouldCache = true;
    private Object routing;
    private Boolean broadcast;
    private RemoteResultReducer remoteResultReducer;
    private Object[] metaArguments;

    public StaticScript() {
    }

    public StaticScript(String name, String type, String script) {
        this.name = name;
        this.type = type;
        this.script = script;
    }

    @Override
    public String getScriptAsString() {
        return this.script;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean shouldCache() {
        return this.shouldCache;
    }

    @Override
    public Object getRouting() {
        return this.routing;
    }

    @Override
    public RemoteResultReducer getReducer() {
        return this.remoteResultReducer;
    }

    @Override
    public Boolean shouldBroadcast() {
        return this.broadcast;
    }

    @Override
    public Object[] getMetaArguments() {
        return this.metaArguments;
    }

    public StaticScript name(String name) {
        this.name = name;
        return this;
    }

    public StaticScript script(String script) {
        this.script = script;
        return this;
    }

    public StaticScript type(String type) {
        this.type = type;
        return this;
    }

    public StaticScript cache(boolean shouldCache) {
        this.shouldCache = shouldCache;
        return this;
    }

    public StaticScript parameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
        return this;
    }

    public StaticScript routing(Object routing) {
        this.routing = routing;
        return this;
    }

    public StaticScript metaArguments(Object ... metaArguments) {
        this.metaArguments = metaArguments;
        return this;
    }

    public <T, Y> StaticScript broadcast(RemoteResultReducer<T, Y> reducer) {
        this.broadcast = true;
        this.remoteResultReducer = reducer;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.type);
        out.writeObject(this.script);
        out.writeBoolean(this.shouldCache);
        if (this.parameters == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeShort(this.parameters.size());
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.type = in.readUTF();
        this.script = (String)in.readObject();
        this.shouldCache = in.readBoolean();
        if (in.readBoolean()) {
            int size = in.readShort();
            this.parameters = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = in.readObject();
                this.parameters.put(key, value);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StaticScript name[").append(this.getName()).append("]");
        sb.append(" type [").append(this.getType()).append("]");
        sb.append(" script [").append(this.script).append("]");
        sb.append(" parameters [").append(this.parameters).append("]");
        return sb.toString();
    }
}

