/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting.cache;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.remoting.scripting.LocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptingException;
import org.openspaces.remoting.scripting.cache.CompiledScriptPool;

public class BlockingQueueCompiledScriptPool
implements CompiledScriptPool {
    private static final Log logger = LogFactory.getLog(BlockingQueueCompiledScriptPool.class);
    private int size;
    private BlockingQueue<Object> queue;
    private LocalScriptExecutor executor;

    public BlockingQueueCompiledScriptPool(int size) {
        this.size = size;
    }

    @Override
    public void init(LocalScriptExecutor executor, Script script) throws ScriptingException {
        this.executor = executor;
        this.queue = new ArrayBlockingQueue<Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.queue.add(executor.compile(script));
        }
    }

    @Override
    public Object get() throws ScriptingException {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            throw new ScriptingException("Interrupted waiting for compiled script pool");
        }
    }

    @Override
    public void put(Object compiledScript) throws ScriptingException {
        this.queue.offer(compiledScript);
    }

    @Override
    public void close() {
        ArrayList compiledScripts = new ArrayList();
        this.queue.drainTo(compiledScripts);
        for (Object compiledScript : compiledScripts) {
            try {
                this.executor.close(compiledScript);
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to close script [" + compiledScript + "], ignoring"), (Throwable)e);
            }
        }
    }
}

