/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openspaces.remoting.scripting.LocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptCompilationException;
import org.openspaces.remoting.scripting.cache.BlockingQueueCompiledScriptPoolFactory;
import org.openspaces.remoting.scripting.cache.CompiledScriptCache;
import org.openspaces.remoting.scripting.cache.CompiledScriptPool;
import org.openspaces.remoting.scripting.cache.CompiledScriptPoolFactory;

public class LRUNonThreadSafeCompiledScriptCache
implements CompiledScriptCache {
    public static final int DEFAULT_CACHE_SIZE = 50;
    private final int size;
    private CompiledScriptPoolFactory compiledScriptPoolFactory;
    private final LinkedHashMap<String, CompiledScriptPool> cache;
    private final Object mutex = new Object();
    private Map.Entry evicted;

    public LRUNonThreadSafeCompiledScriptCache() {
        this(50);
    }

    public LRUNonThreadSafeCompiledScriptCache(int cacheSize) {
        this(cacheSize, new BlockingQueueCompiledScriptPoolFactory());
    }

    public LRUNonThreadSafeCompiledScriptCache(int cacheSize, CompiledScriptPoolFactory compiledScriptPoolFactory) {
        this.size = cacheSize;
        this.compiledScriptPoolFactory = compiledScriptPoolFactory;
        this.cache = new LinkedHashMap<String, CompiledScriptPool>(){
            private static final long serialVersionUID = 4717730055494117794L;

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                boolean remove;
                boolean bl = remove = this.size() > LRUNonThreadSafeCompiledScriptCache.this.size;
                if (remove) {
                    LRUNonThreadSafeCompiledScriptCache.this.evicted = eldest;
                } else {
                    LRUNonThreadSafeCompiledScriptCache.this.evicted = null;
                }
                return remove;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String name, LocalScriptExecutor executor, Script script) throws ScriptCompilationException {
        CompiledScriptPool compiledScriptPool;
        Object object = this.mutex;
        synchronized (object) {
            compiledScriptPool = this.cache.get(name);
        }
        if (compiledScriptPool != null) {
            return compiledScriptPool.get();
        }
        compiledScriptPool = this.compiledScriptPoolFactory.create();
        compiledScriptPool.init(executor, script);
        object = this.mutex;
        synchronized (object) {
            this.internalPut(name, compiledScriptPool);
        }
        return compiledScriptPool.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String name, Object compiledScript, LocalScriptExecutor executor) {
        Object object = this.mutex;
        synchronized (object) {
            CompiledScriptPool compiledScriptPool = this.cache.get(name);
            compiledScriptPool.put(compiledScript);
            this.internalPut(name, compiledScriptPool);
        }
    }

    private void internalPut(String name, CompiledScriptPool compiledScriptPool) {
        this.evicted = null;
        this.cache.put(name, compiledScriptPool);
        if (this.evicted != null) {
            ((CompiledScriptPool)this.evicted.getValue()).close();
        }
    }
}

