/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openspaces.remoting.scripting.LocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptCompilationException;
import org.openspaces.remoting.scripting.cache.CompiledScriptCache;

public class LRUThreadSafeCompiledScriptCache
implements CompiledScriptCache {
    public static final int DEFAULT_CACHE_SIZE = 50;
    private final int size;
    private final LinkedHashMap<String, Object> cache;
    private final Object mutex = new Object();
    private Map.Entry evicted;

    public LRUThreadSafeCompiledScriptCache() {
        this(50);
    }

    public LRUThreadSafeCompiledScriptCache(int cacheSize) {
        this.size = cacheSize;
        this.cache = new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = 3509768785591597933L;

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                boolean remove;
                boolean bl = remove = this.size() > LRUThreadSafeCompiledScriptCache.this.size;
                if (remove) {
                    LRUThreadSafeCompiledScriptCache.this.evicted = eldest;
                } else {
                    LRUThreadSafeCompiledScriptCache.this.evicted = null;
                }
                return remove;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String name, LocalScriptExecutor executor, Script script) throws ScriptCompilationException {
        Object object = this.mutex;
        synchronized (object) {
            Object compiledScript = this.cache.get(name);
            if (compiledScript != null) {
                return compiledScript;
            }
        }
        return executor.compile(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String name, Object compiledScript, LocalScriptExecutor executor) {
        Object object = this.mutex;
        synchronized (object) {
            this.evicted = null;
            this.cache.put(name, compiledScript);
            if (this.evicted != null) {
                executor.close(this.evicted.getValue());
            }
        }
    }
}

