/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.grid.gsa.InstantiationMode;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AgentProcessDetails
implements Externalizable {
    private static final long serialVersionUID = 3064508757268782878L;
    private int agentId;
    private long processId;
    private String serviceType;
    private InstantiationMode instantiationMode;
    private String[] command;

    public AgentProcessDetails() {
    }

    public AgentProcessDetails(int agentId, long processId, String serviceType, InstantiationMode instantiationMode, String[] command) {
        this.agentId = agentId;
        this.processId = processId;
        this.serviceType = serviceType;
        this.instantiationMode = instantiationMode;
        this.command = command;
    }

    public int getAgentId() {
        return this.agentId;
    }

    public long getProcessId() {
        return this.processId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String[] getCommand() {
        return this.command;
    }

    public InstantiationMode getInstantiationMode() {
        return this.instantiationMode;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.agentId);
        out.writeLong(this.processId);
        out.writeUTF(this.serviceType);
        out.writeObject((Object)this.instantiationMode);
        out.writeInt(this.command.length);
        for (String comm : this.command) {
            out.writeUTF(comm);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.agentId = in.readInt();
        this.processId = in.readLong();
        this.serviceType = in.readUTF();
        this.instantiationMode = (InstantiationMode)((Object)in.readObject());
        this.command = new String[in.readInt()];
        for (int i = 0; i < this.command.length; ++i) {
            this.command[i] = in.readUTF();
        }
    }
}

