/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.grid.gsa.AgentProcessDetails;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.lookup.ServiceID;

public class AgentProcessesDetails
implements Externalizable,
Iterable<AgentProcessDetails> {
    private static final long serialVersionUID = 4691748415198348094L;
    private ServiceID agentServiceID;
    private AgentProcessDetails[] processDetails;
    private Map<String, Integer> requiredGlobalInstances;

    public AgentProcessesDetails() {
    }

    public AgentProcessesDetails(ServiceID agentServiceID, AgentProcessDetails[] processDetails, Map<String, Integer> requiredGlobalInstances) {
        this.agentServiceID = agentServiceID;
        this.processDetails = processDetails;
        this.requiredGlobalInstances = requiredGlobalInstances;
    }

    public ServiceID getAgentServiceID() {
        return this.agentServiceID;
    }

    public AgentProcessDetails[] getProcessDetails() {
        return this.processDetails;
    }

    public Map<String, Integer> getRequiredGlobalInstances() {
        return this.requiredGlobalInstances;
    }

    @Override
    public Iterator<AgentProcessDetails> iterator() {
        return Arrays.asList(this.processDetails).iterator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.agentServiceID.writeBytes((DataOutput)out);
        out.writeInt(this.processDetails.length);
        for (AgentProcessDetails details : this.processDetails) {
            details.writeExternal(out);
        }
        HashMap<String, Integer> clonedMap = new HashMap<String, Integer>(this.requiredGlobalInstances);
        out.writeInt(clonedMap.size());
        for (Map.Entry entry : clonedMap.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.agentServiceID = new ServiceID((DataInput)in);
        this.processDetails = new AgentProcessDetails[in.readInt()];
        for (int i = 0; i < this.processDetails.length; ++i) {
            this.processDetails[i] = new AgentProcessDetails();
            this.processDetails[i].readExternal(in);
        }
        this.requiredGlobalInstances = new HashMap<String, Integer>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.requiredGlobalInstances.put((String)in.readObject(), in.readInt());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Running [");
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (AgentProcessDetails detail : this.getProcessDetails()) {
            Integer value = (Integer)counts.get(detail.getServiceType());
            if (value == null) {
                value = 1;
            } else {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
            }
            counts.put(detail.getServiceType(), value);
        }
        for (Map.Entry entry : counts.entrySet()) {
            sb.append((String)entry.getKey()).append("(").append(entry.getValue()).append("),");
        }
        sb.append("], ");
        sb.append("Required Global [");
        for (Map.Entry entry : this.requiredGlobalInstances.entrySet()) {
            sb.append((String)entry.getKey()).append("(").append(entry.getValue()).append("),");
        }
        sb.append("]");
        return sb.toString();
    }
}

