/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.sun.jini.config.Config;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.resources.client.AbstractFaultDetectionHandler;

public class GSAFaultDetectionHandler
extends AbstractFaultDetectionHandler {
    public static final String INVOCATION_DELAY_KEY = "invocationDelay";
    private static final String COMPONENT = "com.gigaspaces.grid.gsa.GSAFaultDetectionHandler";
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsa.GSAFaultDetectionHandler");

    @Override
    public void setConfiguration(String[] configArgs) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        try {
            this.configArgs = new String[configArgs.length];
            System.arraycopy(configArgs, 0, this.configArgs, 0, configArgs.length);
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            this.invocationDelay = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)INVOCATION_DELAY_KEY, (long)60000L, (long)0L, (long)Long.MAX_VALUE);
            this.retryCount = Config.getIntEntry((Configuration)this.config, (String)COMPONENT, (String)"retryCount", (int)3, (int)0, (int)Integer.MAX_VALUE);
            this.retryTimeout = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)"retryTimeout", (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            if (logger.isLoggable(Level.CONFIG)) {
                StringBuilder buffer = new StringBuilder("GSAFaultDetectionHandler Properties : ");
                buffer.append("\n invocation delay=" + this.invocationDelay);
                buffer.append("\n retry count=" + this.retryCount + ", ");
                buffer.append("\n retry timeout=" + this.retryTimeout);
                buffer.append("\n configArgs: " + Arrays.toString(configArgs));
                logger.config(buffer.toString());
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.SEVERE, "Setting Configuration", e);
        }
    }

    @Override
    protected AbstractFaultDetectionHandler.ServiceMonitor getServiceMonitor() throws Exception {
        return new ServiceAdminManager();
    }

    class ServiceAdminManager
    implements AbstractFaultDetectionHandler.ServiceMonitor {
        Throwable lastThrown;
        ServiceDetails serviceDetails = new ServiceDetails();

        public ServiceAdminManager() {
            this.serviceDetails.serviceId = GSAFaultDetectionHandler.this.getServiceID();
            try {
                NIODetails nioDetails = ((GSA)GSAFaultDetectionHandler.this.proxy).getNIODetails();
                this.serviceDetails.host = nioDetails.getHostName() + "/" + nioDetails.getHostAddress();
            }
            catch (RemoteException re) {
                this.serviceDetails.host = GSAFaultDetectionHandler.this.proxy.toString();
            }
        }

        @Override
        public void drop() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Dropping monitor for service: " + this.serviceDetails);
            }
        }

        @Override
        public void reportFirstError() {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Suspecting failure of service: " + this.serviceDetails + ". Retrying to reach service.", this.lastThrown);
            }
        }

        @Override
        public void reportLastError() {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Detected failure of service: " + this.serviceDetails + ". This service cannot be reached.", this.lastThrown);
            }
        }

        @Override
        public boolean verify() {
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Requesting ping() on service: " + this.serviceDetails);
                }
                ((GSA)GSAFaultDetectionHandler.this.proxy).ping();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ping() successfully verified on service: " + this.serviceDetails);
                }
                return true;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Failed reaching service: " + this.serviceDetails + ", Reason: " + e, e);
                }
                this.lastThrown = e;
                return false;
            }
        }

        @Override
        public boolean shouldRetry() {
            return true;
        }

        public String toString() {
            return super.toString() + " " + this.serviceDetails;
        }

        class ServiceDetails {
            ServiceID serviceId;
            String host;

            ServiceDetails() {
            }

            public String toString() {
                String toString = "GSA at host: [" + this.host + "]";
                if (logger.isLoggable(Level.FINE)) {
                    toString = toString + " Id: [" + this.serviceId + "]";
                }
                return toString;
            }
        }
    }
}

