/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.grid.gsa.AgentProcessDetails;
import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsa.GSAProxy;
import com.gigaspaces.grid.gsa.GSProcess;
import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.grid.gsa.GSProcessRestartOnExit;
import com.gigaspaces.grid.gsa.GlobalProcessAlreadyRunningIOException;
import com.gigaspaces.grid.gsa.InstantiationMode;
import com.gigaspaces.grid.security.gsa.SecuredGSAExtension;
import com.gigaspaces.grid.security.gsa.SecuredGSAProxy;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.grid.zookeeper.ZookeeperClusterConfig;
import com.gigaspaces.grid.zookeeper.ZookeeperConfig;
import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpHelper;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.license.LicenseException;
import com.gigaspaces.log.CompoundLogEntries;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.gigaspaces.security.service.SecurityResolver;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.jini.config.Configuration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.jsb.ServiceBeanActivation;
import org.jini.rio.jsb.ServiceBeanAdapter;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GSAImpl
extends ServiceBeanAdapter
implements GSA,
RemoteSecuredService,
ServiceDiscoveryListener {
    static final String ROOT_COMPONENT = "com.gigaspaces";
    static final String GRID_COMPONENT = "com.gigaspaces.grid";
    public static final String CONFIG_COMPONENT = "com.gigaspaces.grid.gsa";
    public static final String GSA_PID_PROPERTY = "pid";
    public static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsa");
    private MetricManager metricManager;
    private SecurityInterceptor securityInterceptor;
    private LifeCycle lifeCycle;
    private String[] configArgs;
    private String localXapManager;
    private static AtomicInteger currentId = new AtomicInteger();
    private final Map<Integer, GSProcess> processes = new ConcurrentHashMap<Integer, GSProcess>();
    private final Map<String, GSAHolder> agents = new ConcurrentHashMap<String, GSAHolder>();
    private final Map<String, Integer> requiredGlobalInstances = new ConcurrentHashMap<String, Integer>();
    private ScheduledExecutorService scheduledMonitor;
    private ServiceDiscoveryManager sdm;
    private LookupCache cache;
    private File gsaFile;
    private RandomAccessFile gsaFileRaf;
    private FileLock gsaFileLock;

    public GSAImpl() throws Exception {
    }

    public GSAImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        this();
        this.lifeCycle = lifeCycle;
        this.logDeprecation();
        this.configArgs = this.preProcess(configArgs);
        this.validateSecurityPreConditions();
        this.bootstrap();
    }

    private void logDeprecation() {
        if ("true".equalsIgnoreCase(System.getenv("XAP_GSA_SKIP_DEPRECATED"))) {
            return;
        }
        String newline = System.lineSeparator();
        String docsUrl = PlatformVersion.getProductHelpUrl();
        StringBuilder sb = new StringBuilder();
        sb.append(newline);
        sb.append("******************************************************************************").append(newline);
        sb.append("The gs-agent script is deprecated and will be removed in the future.").append(newline);
        sb.append("Use the 'xap host run-agent' command instead. ").append(newline);
        sb.append("For more information:").append(newline);
        sb.append("   * Run 'xap host run-agent --help'").append(newline);
        sb.append("   * " + docsUrl + "/admin/admin-service-grid-agent.html").append(newline);
        sb.append("   * " + docsUrl + "/admin/upgrading-gs-agent.html").append(newline);
        sb.append("******************************************************************************");
        logger.info(sb.toString());
    }

    protected void bootstrap() throws Exception {
        try {
            String[] stringArray;
            String fdh = "com.gigaspaces.grid.gsa.GSAFaultDetectionHandler";
            Object[] fdhConfigArgs = new Object[]{new String[]{"-", "com.gigaspaces.grid.gsa.GSAFaultDetectionHandler.invocationDelay=" + System.getProperty("com.gigaspaces.grid.gsa.GSAFaultDetectionHandler.invocationDelay", "10000"), "com.gigaspaces.grid.gsa.GSAFaultDetectionHandler.retryCount=" + System.getProperty("com.gigaspaces.grid.gsa.GSAFaultDetectionHandler.retryCount", "0")}};
            ClassBundle faultDetectionHandler = new ClassBundle(fdh, null, new String[]{"setConfiguration"}, new Object[]{fdhConfigArgs});
            if (this.configArgs.length < 2) {
                stringArray = this.configArgs;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.configArgs[0];
            }
            this.context = ServiceBeanActivation.getServiceBeanContext(CONFIG_COMPONENT, "Grid Service Agent", "Service Grid Infrastructure", "com.gigaspaces.grid:type=GSA", faultDetectionHandler, stringArray, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting ServiceElement", e);
            throw e;
        }
        try {
            this.start(this.context);
            ServiceBeanActivation.LifeCycleManager lMgr = (ServiceBeanActivation.LifeCycleManager)this.context.getServiceBeanManager().getDiscardManager();
            if (lMgr != null) {
                lMgr.register(this.getServiceProxy(), this.context);
            } else {
                logger.log(Level.WARNING, "LifeCycleManager is null, unable to register");
            }
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Register to LifeCycleManager", e);
            throw e;
        }
    }

    @Override
    public synchronized void initialize(ServiceBeanContext context) throws Exception {
        if (SecurityResolver.isSecurityEnabled()) {
            this.securityInterceptor = new SecurityInterceptor("grid");
        }
        super.initialize(context);
        this.scheduledMonitor = Executors.newScheduledThreadPool(2);
        File workLocation = new File(SystemInfo.singleton().locations().work());
        this.initializeSparkProperties();
        File gsaDir = new File(workLocation, "gsa");
        gsaDir.mkdirs();
        this.gsaFile = new File(gsaDir, "gsa-" + SystemInfo.singleton().os().processId() + "~" + this.getServiceID());
        this.savePropertiesToFile();
        this.gsaFile.deleteOnExit();
        this.gsaFileRaf = new RandomAccessFile(this.gsaFile, "rw");
        Exception lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                logger.fine("Trying to get lock...");
                this.gsaFileLock = this.gsaFileRaf.getChannel().tryLock();
                if (this.gsaFileLock != null) break;
                lastException = new IOException("Failed to tryLock");
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Failed to get lock", e);
                lastException = e;
            }
            Thread.sleep(100L);
        }
        if (this.gsaFileLock == null) {
            logger.log(Level.WARNING, "Failed to obtain lock for GSA on [" + workLocation.getAbsolutePath() + "], this might be due NFS, if so, set the [com.gs.work] system property to a local file system location", lastException);
        }
        RuntimeInfo.logRuntimeInfo((Logger)logger, (String)"Starting GSA...");
        LicenseManager.getInstance().validate("Service Grid", LicenseType.PREMIUM);
        this.metricManager = MetricManager.acquire();
        JMXConnection jmxEntry = JMXUtilities.createJMXConnectionAttribute((String)context.getServiceElement().getName());
        if (jmxEntry != null) {
            this.addAttribute((Entry)jmxEntry);
        }
        Configuration config = ServiceConfigLoader.getConfiguration();
        logger.info("GSA will use discovery groups " + Arrays.toString(context.getServiceElement().getServiceBeanConfig().getGroups()) + " and locators " + Arrays.toString(context.getServiceElement().getServiceBeanConfig().getLocators()) + "");
        this.sdm = SharedDiscoveryManagement.getBackwardsServiceDiscoveryManager((String[])context.getServiceElement().getServiceBeanConfig().getGroups(), (LookupLocator[])context.getServiceElement().getServiceBeanConfig().getLocators(), null);
        ServiceTemplate template = new ServiceTemplate(null, new Class[]{GSA.class}, null);
        this.cache = this.sdm.createLookupCache(template, null, (ServiceDiscoveryListener)this);
        int processMonitorInterval = 1;
        int initialGlobalMonitorInterval = 30;
        int globalMonitorInterval = 10;
        for (String arg : this.configArgs) {
            int numberOfServices;
            String serviceType;
            int index;
            if (arg.startsWith("gsa.global.")) {
                index = (arg = arg.substring("gsa.global.".length())).indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException("GSA argument [" + arg + "] must specify the number of services to start");
                }
                serviceType = arg.substring(0, index);
                numberOfServices = Integer.parseInt(arg.substring(index + 2, arg.length() - 1));
                if (numberOfServices <= 0) continue;
                logger.info("GSA will globally manage [" + numberOfServices + "] of service [" + serviceType + "]");
                this.requiredGlobalInstances.put(serviceType, numberOfServices);
                continue;
            }
            if (!arg.startsWith("gsa.")) continue;
            index = (arg = arg.substring("gsa.".length())).indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("GSA argument [" + arg + "] must specify the number of services to start");
            }
            serviceType = arg.substring(0, index);
            numberOfServices = Integer.parseInt(arg.substring(index + 2, arg.length() - 1));
            if (serviceType.equalsIgnoreCase("processMonitorInterval")) {
                processMonitorInterval = numberOfServices;
                continue;
            }
            if (serviceType.equalsIgnoreCase("initialGlobalMonitorInterval")) {
                initialGlobalMonitorInterval = numberOfServices;
                continue;
            }
            if (serviceType.equalsIgnoreCase("globalMonitorInterval")) {
                globalMonitorInterval = numberOfServices;
                continue;
            }
            GSProcessOptions options = new GSProcessOptions(serviceType);
            Properties serviceProps = this.getProperties(options);
            if (serviceProps == null) {
                throw new IllegalArgumentException("No service defined in GSA properties for [" + serviceType + "]");
            }
            if (numberOfServices <= 0) continue;
            options.setUseScript(serviceProps.getProperty("initial-instances", "script").equalsIgnoreCase("script"));
            logger.info("Starting [" + numberOfServices + "] of [" + serviceType + "]");
            for (int i = 0; i < numberOfServices; ++i) {
                int id = currentId.incrementAndGet();
                GSProcess process = new GSProcess(id, options, serviceProps, InstantiationMode.LOCAL, this);
                try {
                    process.start();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, process.getLogId() + ": Failed to start, exiting", e);
                    System.exit(1);
                }
                this.processes.put(id, process);
            }
        }
        logger.info("GSA will use an interval of [" + processMonitorInterval + "] seconds to monitor processes");
        this.scheduledMonitor.scheduleWithFixedDelay(new ProcessMonitor(), processMonitorInterval, processMonitorInterval, TimeUnit.SECONDS);
        long actualInitialInterval = (long)(Math.random() * (double)initialGlobalMonitorInterval);
        logger.info("GSA will check for global managed instances every [" + globalMonitorInterval + "] seconds, with randomized initial delay of [" + actualInitialInterval + "] seconds out of [" + initialGlobalMonitorInterval + "] seconds");
        this.scheduledMonitor.scheduleWithFixedDelay(new GlobalInstancesMonitor(), actualInitialInterval, globalMonitorInterval, TimeUnit.SECONDS);
    }

    private void savePropertiesToFile() throws IOException {
        Properties gsaProperties = new Properties();
        long pid = this.getJVMDetails().getPid();
        gsaProperties.setProperty(GSA_PID_PROPERTY, String.valueOf(pid));
        FileOutputStream fileOutputStream = new FileOutputStream(this.gsaFile);
        gsaProperties.store(fileOutputStream, null);
        fileOutputStream.close();
    }

    private void validateSecurityPreConditions() {
        if (SecurityResolver.isSecurityEnabled() && this.managerArgExists() && this.isRestSslConfigMissing()) {
            logger.severe("XAP Manager security configuration is missing.\n* Security is enabled, but SSL is not configured. Please configure SSL using the system property 'com.gs.manager.rest.ssl.enabled'.\n* For more information: '" + PlatformVersion.getProductHelpUrl() + "/admin/xap-manager-rest.html#security'");
            System.exit(1);
        }
    }

    private boolean managerArgExists() {
        if (this.localXapManager != null) {
            return true;
        }
        for (String arg : this.configArgs) {
            if (!arg.equals("gsa.manager")) continue;
            return true;
        }
        return false;
    }

    private boolean isRestSslConfigMissing() {
        boolean configMissing;
        boolean bl = configMissing = System.getProperty("com.gs.manager.rest.ssl.enabled") == null;
        if (configMissing) {
            String xapManagerOptionsEnv = System.getenv("XAP_MANAGER_OPTIONS");
            configMissing = xapManagerOptionsEnv != null && !xapManagerOptionsEnv.contains("-Dcom.gs.manager.rest.ssl.enabled=");
        }
        return configMissing;
    }

    private void initializeSparkProperties() {
        XapManagerClusterInfo clusterInfo = this.localXapManager == null ? SystemInfo.singleton().getManagerClusterInfo() : new XapManagerClusterInfo(this.localXapManager, SystemInfo.singleton().network().getHost());
        ZookeeperClusterConfig zookeeperCluster = this.localXapManager == null ? ZookeeperClusterConfig.getInstance() : new ZookeeperClusterConfig(clusterInfo);
        System.setProperty("com.gs.manager.zookeeper.connection-string", zookeeperCluster.generateConnectionString(ZookeeperConfig.getDefaultConfig()));
        System.setProperty("com.gs.insightedge.master-url", GSAImpl.initializeSparkMasterUrl(clusterInfo));
        System.setProperty("com.gs.spark.host", this.initializeSparkHost());
    }

    private String initializeSparkHost() {
        if (this.localXapManager != null) {
            return this.localXapManager;
        }
        String sparkLocalIp = System.getenv("SPARK_LOCAL_IP");
        if (sparkLocalIp != null) {
            return sparkLocalIp;
        }
        return SystemInfo.singleton().network().getHostId();
    }

    private static String initializeSparkMasterUrl(XapManagerClusterInfo clusterInfo) {
        String port = System.getenv("SPARK_MASTER_PORT");
        if (port == null) {
            port = "7077";
        }
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (XapManagerConfig server : clusterInfo.getServers()) {
            sb.append(comma);
            comma = ",";
            sb.append(server.getHost() + ":" + port);
        }
        return "spark://" + sb.toString();
    }

    private String[] preProcess(String[] configArgs) {
        boolean defaultsEnabled = true;
        boolean foundGlobalLus = false;
        boolean foundGlobalGSM = false;
        boolean foundGsc = false;
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : configArgs) {
            if (arg.equals("-h") || arg.startsWith("--help")) {
                if (arg.equals("--help-old")) {
                    this.printHelpOld();
                } else {
                    this.printHelp(arg.equals("--help-full"));
                }
                System.exit(0);
            }
            if (arg.equals("-z") || arg.equalsIgnoreCase("--zero-defaults")) {
                defaultsEnabled = false;
                continue;
            }
            if (arg.startsWith("--")) {
                defaultsEnabled = false;
                arg = "gsa." + arg.substring("--".length());
                if (!arg.contains("=")) {
                    arg = arg + "=\"1\"";
                }
            }
            if (arg.startsWith("gsa.")) {
                if (arg.startsWith("gsa.global.lus")) {
                    foundGlobalLus = true;
                } else if (arg.startsWith("gsa.global.gsm")) {
                    foundGlobalGSM = true;
                } else if (arg.startsWith("gsa.gsc")) {
                    foundGsc = true;
                } else if (arg.equals("gsa.manager=\"1\"")) {
                    if (SystemInfo.singleton().getManagerClusterInfo().isEmpty()) {
                        System.out.println();
                        logger.severe("XAP Manager configuration is missing" + StringUtils.NEW_LINE + "* To run a standalone manager on this machine, use --manager-local instead of --manager" + StringUtils.NEW_LINE + "* To configure a cluster of managers on 1 or 3 machines (including this one), edit the setenv-overrides script (located in " + SystemInfo.singleton().locations().bin() + ") and set the " + "XAP_MANAGER_SERVERS" + " environment variable to list the designated manager servers");
                        System.exit(1);
                    }
                } else if (arg.equals("gsa.manager-local=\"1\"")) {
                    logger.info("Starting standalone XAP Manager on localhost (not recommended for production - for a highly-available cluster of managers configure XAP_MANAGER_SERVERS instead)");
                    this.localXapManager = "localhost";
                    arg = "gsa.manager=\"1\"";
                }
            }
            args.add(arg);
        }
        if (defaultsEnabled) {
            if (!foundGlobalGSM) {
                args.add("gsa.global.gsm=\"2\"");
            }
            if (!foundGlobalLus) {
                args.add("gsa.global.lus=\"2\"");
            }
            if (!foundGsc) {
                args.add("gsa.gsc=\"2\"");
            }
        }
        return args.toArray(new String[args.size()]);
    }

    private void printHelp(boolean full) {
        System.out.println();
        System.out.println("Usage");
        System.out.println("-----");
        System.out.println("gs-agent [--{service-type}={count}...]");
        System.out.println("gs-agent [-z | --zero-defaults]");
        System.out.println();
        System.out.println("Description");
        System.out.println("-----------");
        System.out.println("Starts (and supervises) Service Grid components on the current host. Services can be started");
        System.out.println("at startup (via command line arguments) or later (via XAP api and management tools, which");
        System.out.println("also supports terminating and restarting services).");
        System.out.println();
        System.out.println("To start services via command line, use --<service-type>=count. For example, '--gsc=2' will");
        System.out.println("start two gsc services. You can start multiple services (e.g. '--manager --gsc=2' will start");
        System.out.println("one manager and two GSCs).");
        System.out.println();
        System.out.println("In addition, if you specify '--global.<service-type>=count', the gs-agent will coordinate ");
        System.out.println("with all other gs-agents (across hosts) to maintain those services. This is useful (in some");
        System.out.println("scenarios) for gsm and lus. Read the docs for detailed information.");
        System.out.println();
        System.out.println("Starting gs-agent with no arguments will default to '--gsc=2 --global.gsm=2 --global.lus=2',");
        System.out.println("which is useful for running the built-in examples. If you'd like to start with no services");
        System.out.println("(e.g. you're managing services remotely), use '--zero-defaults' or '-z'.");
        System.out.println();
        System.out.println("If you're upgrading from a pre-12.1 version - the previous syntax is still supported, and ");
        System.out.println("scripts using it will function as before. Use '--help-old' to print the old help screen.");
        System.out.println();
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("  -h, --help");
        System.out.println("     Prints help screen with common options (use '--help-full' for all options)");
        System.out.println("  --manager");
        System.out.println("     Starts a XAP Manager, which bundles gsm, lus, zookeeper and a REST service");
        System.out.println("     (Starting more than one on the same host is not supported)");
        System.out.println("     Requires configuring a list of 1 or 3 manager servers using the XAP_MANAGER_SERVERS");
        System.out.println("     environment variable (see setenv-overrides script located in ");
        System.out.println("     " + SystemInfo.singleton().locations().bin() + ")");
        System.out.println("  --manager-local");
        System.out.println("     Starts a standalone XAP Manager on the local machine");
        System.out.println("  --gsc[=N]");
        System.out.println("     Starts N Grid Service Containers (if =N is not specified, defaults to 1)");
        System.out.println("  --gsm[=N]");
        System.out.println("     Starts N Grid Service Managers (if =N is not specified, defaults to 1)");
        System.out.println("  --lus[=N]");
        System.out.println("     Starts N LookUp Services (if =N is not specified, defaults to 1)");
        System.out.println("  --esm");
        System.out.println("     Starts Elastic Service Manager (starting more than 1 is not supported)");
        System.out.println("  -z, --zero-defaults");
        System.out.println("     Zero defaults (disables the default '--gsc=2 --global.gsm=2 --global.lus=2')");
        if (full) {
            System.out.println("  --processMonitorInterval={time}");
            System.out.println("     The interval (in seconds) to monitor if the managed processes are alive (default=1)");
            System.out.println("  --initialGlobalMonitorInterval={time}");
            System.out.println("     The randomized time window (in seconds) before global instance monitor is started");
            System.out.println("  --globalMonitorInterval={time}");
            System.out.println("     The interval (in seconds) to check if global instances contract is breached");
        }
    }

    private void printHelpOld() {
        System.out.println();
        System.out.println("Usage: gs-agent [gsa.{name} {count}] [gsa.global.{name} {count}] [options]");
        System.out.println("Options:");
        System.out.println("--------");
        System.out.println("  --help-old");
        System.out.println("     Prints this help screen (use -h or --help to print the new help screen)");
        System.out.println("  -z, --zero-defaults");
        System.out.println("     Zero defaults (if not specified, default is \"gsa.gsc 2 gsa.global.gsm 2 gsa.global.lus 2\")");
        System.out.println("  gsa.{name} {count}");
        System.out.println("     Start {count} number of local {name} processes");
        System.out.println("  gsa.global.{name} {count}");
        System.out.println("     Start {count} number of global {name} processes across all agents with the same ");
        System.out.println("     lookup group / locators");
        System.out.println("  gsa.processMonitorInterval {time}");
        System.out.println("     The interval (in seconds) to monitor if the managed processes are alive (default=1)");
        System.out.println("  gsa.initialGlobalMonitorInterval {time}");
        System.out.println("     The randomized time window (in seconds) before global instance monitor is started");
        System.out.println("  gsa.globalMonitorInterval {time}");
        System.out.println("     The interval (in seconds) to check if global instances contract is breached");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("---------");
        System.out.println("gs-agent");
        System.out.println("    Starts the default gsa.gsc 2 gsa.global.gsm 2 gsa.global.lus 2");
        System.out.println("gs-agent gsa.gsc 3");
        System.out.println("    Starts 3 gsc (instead of the default 2), and the remaining default (2 global gsm and lus)");
        System.out.println("gs-agent gsa.gsc 3 -z");
        System.out.println("    Starts 3 gsc (and ignore all the defaults)");
        System.out.println("gs-agent gsa.gsm 1 gsa.global.gsm 0");
        System.out.println("    Starts a local gsm and disable the default 2 global gsm, and the remaining default (2 gsc and 2 global lus)");
        System.out.println("gs-agent -z");
        System.out.println("    Starts an empty agent with no services (services can be started remotely via admin api)");
    }

    @Override
    protected void initializeJMX(Object mbean) throws Exception {
        if (this.isServiceSecured()) {
            mbean = new SecuredGSAExtension(mbean);
        }
        super.initializeJMX(mbean);
    }

    @Override
    public void advertise() throws IOException {
        super.advertise();
        logger.info("GSA started successfully with groups " + Arrays.toString(this.admin.getLookupGroups()) + " and locators " + Arrays.toString(this.admin.getLookupLocators()) + "");
    }

    @Override
    public void shutdown() throws RemoteException {
        try {
            this.destroy(true);
        }
        finally {
            System.exit(0);
        }
    }

    @Override
    public synchronized void destroy(boolean force) {
        logger.info("Stopping GSA ...");
        if (this.gsaFileLock != null) {
            try {
                this.gsaFileLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.gsaFileRaf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gsaFile.delete();
        this.agents.clear();
        this.scheduledMonitor.shutdownNow();
        try {
            this.cache.terminate();
            this.sdm.terminate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopGSProcesses();
        this.processes.clear();
        if (this.lifeCycle != null) {
            this.lifeCycle.unregister((Object)this);
        }
        this.metricManager.close();
        super.destroy(force);
        logger.info("GSA stopped successfully");
    }

    private void stopGSProcesses() {
        for (GSProcess process : this.processes.values()) {
            if (process.getOptions().getType().equals("lus")) continue;
            process.sendStop();
        }
        for (GSProcess process : this.processes.values()) {
            if (process.getOptions().getType().equals("lus")) continue;
            process.stop();
        }
        for (GSProcess process : this.processes.values()) {
            if (!process.getOptions().getType().equals("lus")) continue;
            process.sendStop();
        }
        for (GSProcess process : this.processes.values()) {
            if (!process.getOptions().getType().equals("lus")) continue;
            process.stop();
        }
    }

    @Override
    public int startProcess(GSProcessOptions options) throws RemoteException, IOException {
        InstantiationMode instantiationMode;
        Properties serviceProps = this.getProperties(options);
        if (serviceProps == null) {
            throw new IllegalArgumentException("No properties defined for service [" + options.getType() + "]");
        }
        int id = currentId.incrementAndGet();
        if (this.requiredGlobalInstances.containsKey(options.getType())) {
            instantiationMode = InstantiationMode.GLOBAL;
            for (GSProcess process : this.processes.values()) {
                if (!process.getOptions().getType().equals(options.getType())) continue;
                throw new GlobalProcessAlreadyRunningIOException("Can't start a process of type [" + options.getType() + "] that is globally managed and already running within this instance of the GSA");
            }
        } else {
            instantiationMode = InstantiationMode.LOCAL;
        }
        GSProcess process = new GSProcess(id, options, serviceProps, instantiationMode, this);
        logger.info(process.getLogId() + ": Received request to start");
        try {
            process.start();
            this.processes.put(id, process);
            return id;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, process.getLogId() + ": Failed to start process. Caused By " + e.getMessage(), e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killProcess(int id) throws RemoteException, IllegalArgumentException {
        GSProcess process = this.processes.remove(id);
        if (process == null) {
            throw new IllegalArgumentException("No process for id [" + id + "]");
        }
        GSProcess gSProcess = process;
        synchronized (gSProcess) {
            logger.info(process.getLogId() + ": Received request to stop");
            process.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartProcess(int id) throws IOException, RemoteException, IllegalArgumentException {
        GSProcess process = this.processes.get(id);
        if (process == null) {
            throw new IllegalArgumentException("No process for id [" + id + "]");
        }
        logger.info(process.getLogId() + ": Received request to restart");
        GSProcess gSProcess = process;
        synchronized (gSProcess) {
            process.stop();
            try {
                process.start();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, process.getLogId() + ": Failed to start, removing", e);
                this.processes.remove(id);
                throw e;
            }
        }
    }

    @Override
    public AgentProcessesDetails getDetails() throws RemoteException {
        ArrayList<AgentProcessDetails> processDetails = new ArrayList<AgentProcessDetails>();
        for (GSProcess process : this.processes.values()) {
            processDetails.add(new AgentProcessDetails(process.getId(), process.getProcessId(), process.getOptions().getType(), process.getInstantiationMode(), process.getCommand().toArray(new String[process.getCommand().size()])));
        }
        return new AgentProcessesDetails(this.serviceID, processDetails.toArray(new AgentProcessDetails[processDetails.size()]), this.requiredGlobalInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processError(GSProcess process, String message) {
        GSProcessRestartOnExit restartOnExit = process.getRestartOnExit();
        if (restartOnExit.equals((Object)GSProcessRestartOnExit.NEVER)) {
            logger.warning(process.getLogId() + ": Reported Error [" + message + "], stopping. restart-on-exit=" + (Object)((Object)restartOnExit));
            process.stop();
            this.processes.remove(process.getId());
        } else {
            logger.warning(process.getLogId() + ": Reported Error [" + message + "], restarting. restart-on-exit=" + (Object)((Object)restartOnExit));
            boolean success = false;
            int retryCount = 3;
            GSProcess gSProcess = process;
            synchronized (gSProcess) {
                for (int i = 0; i < retryCount; ++i) {
                    process.stop();
                    try {
                        process.start();
                        success = true;
                        break;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, process.getLogId() + ": Failed to start", e);
                        continue;
                    }
                }
                if (!success) {
                    logger.warning(process.getLogId() + ": Tried to start for [" + retryCount + "] and failed, stopping");
                    this.processes.remove(process.getId());
                }
            }
        }
    }

    @Override
    public LogEntries logEntries(LogProcessType type, long pid, LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntries((LogProcessType)type, (long)pid, (LogEntryMatcher)matcher);
    }

    @Override
    public CompoundLogEntries logEntries(LogProcessType[] types, long[] pids, LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntries((LogProcessType[])types, (long[])pids, (LogEntryMatcher)matcher);
    }

    @Override
    public CompoundLogEntries logEntries(LogProcessType type, LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntries((LogProcessType)type, (LogEntryMatcher)matcher);
    }

    public void reloadMetricConfiguration() throws RemoteException {
        MetricManager.reloadIfStarted();
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("gsa", this);
        return InternalDumpHelper.generateDump(cause, context);
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context, String ... contributors) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("gsa", this);
        return InternalDumpHelper.generateDump(cause, context, contributors);
    }

    public byte[] dumpBytes(String file, long from, int length) throws RemoteException, IOException {
        return InternalDumpHelper.dumpBytes(file, from, length);
    }

    public ServiceID getGSAServiceID() {
        return this.serviceID;
    }

    @Override
    protected Object createProxy() {
        Object proxy = this.doCreateProxy();
        return proxy;
    }

    private Object doCreateProxy() {
        GSAProxy proxy = null;
        proxy = this.securityInterceptor != null ? SecuredGSAProxy.getInstance((GSA)((Object)this.getExportedProxy()), this.getUuid()) : GSAProxy.getInstance((GSA)((Object)this.getExportedProxy()), this.getUuid());
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getProperties(GSProcessOptions processOptions) throws IOException {
        InputStream is;
        String serviceType = processOptions.getType();
        String configRelativeDir = "config/gsa/";
        String configBaseDir = System.getProperty("com.gigaspaces.grid.gsa.config-directory");
        if (configBaseDir == null) {
            configBaseDir = System.getProperty("com.gs.grid.gsa.config-directory");
        }
        if (configBaseDir == null) {
            configBaseDir = SystemConfig.getInstance().getHomeDir() + "/" + "config/gsa/";
        }
        String resourceNameLoaded = null;
        Properties props = new Properties();
        File file = new File(configBaseDir, serviceType + ".properties");
        if (file.exists()) {
            resourceNameLoaded = file.getAbsolutePath();
            is = new FileInputStream(file);
        } else {
            resourceNameLoaded = "classpath:config/gsa/" + serviceType + ".properties";
            is = GSAImpl.class.getClassLoader().getResourceAsStream("config/gsa/" + serviceType + ".properties");
        }
        if (is != null) {
            try {
                props.load(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        file = new File(configBaseDir, serviceType + ".xml");
        if (file.exists()) {
            resourceNameLoaded = file.getAbsolutePath();
            is = new FileInputStream(file);
        } else {
            resourceNameLoaded = "classpath:config/gsa/" + serviceType + ".xml";
            is = GSAImpl.class.getClassLoader().getResourceAsStream("config/gsa/" + serviceType + ".xml");
        }
        if (is != null) {
            try {
                List<Element> list;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                docBuilder.setErrorHandler(new SimpleSaxErrorHandler());
                Document doc = docBuilder.parse(new InputSource(is));
                Element processEle = doc.getDocumentElement();
                props.setProperty("initial-instances", processEle.getAttribute("initial-instances"));
                props.setProperty("shutdown.class", processEle.getAttribute("shutdown-class"));
                props.setProperty("restart-on-exit", processEle.getAttribute("restart-on-exit"));
                List<Element> restartRegexList = GSAImpl.getChildElementsByTagName(processEle, "restart-regex");
                if (!restartRegexList.isEmpty()) {
                    for (int i = 1; i <= restartRegexList.size(); ++i) {
                        props.setProperty("restart-regex." + i, GSAImpl.getTrimmedTextValue(restartRegexList.get(i - 1)));
                    }
                }
                if (!(list = GSAImpl.getChildElementsByTagName(processEle, "script")).isEmpty()) {
                    Element scriptEle = list.get(0);
                    props.setProperty("script.enable", scriptEle.getAttribute("enable"));
                    props.setProperty("script.work-dir", scriptEle.getAttribute("work-dir"));
                    props.setProperty("script.windows", scriptEle.getAttribute("windows"));
                    props.setProperty("script.unix", scriptEle.getAttribute("unix"));
                    List<Element> scriptArguments = GSAImpl.getChildElementsByTagName(scriptEle, "argument");
                    for (int i = 1; i <= scriptArguments.size(); ++i) {
                        props.setProperty("script.argument." + i, GSAImpl.getTrimmedTextValue(scriptArguments.get(i - 1)));
                    }
                    List<Element> scriptVariables = GSAImpl.getChildElementsByTagName(scriptEle, "environment");
                    for (Element variable : scriptVariables) {
                        props.setProperty("script.environment." + variable.getAttribute("name"), GSAImpl.getTrimmedTextValue(variable));
                    }
                }
                if (!(list = GSAImpl.getChildElementsByTagName(processEle, "vm")).isEmpty()) {
                    List<Element> vmArguments;
                    List<Element> vmInputArguments;
                    Element vmEle = list.get(0);
                    props.setProperty("vm.enable", vmEle.getAttribute("enable"));
                    props.setProperty("vm.work-dir", vmEle.getAttribute("work-dir"));
                    props.setProperty("vm.main-class", vmEle.getAttribute("main-class"));
                    List<Element> classpath = GSAImpl.getChildElementsByTagName(vmEle, "classpath");
                    if (!classpath.isEmpty()) {
                        for (int i = 1; i <= classpath.size(); ++i) {
                            props.setProperty("vm.classpath." + i, GSAImpl.getTrimmedTextValue(classpath.get(i - 1)));
                        }
                    }
                    if (!(vmInputArguments = GSAImpl.getChildElementsByTagName(vmEle, "input-argument")).isEmpty()) {
                        for (int i = 1; i <= vmInputArguments.size(); ++i) {
                            props.setProperty("vm.input-argument." + i, GSAImpl.getTrimmedTextValue(vmInputArguments.get(i - 1)));
                        }
                    }
                    if (!(vmArguments = GSAImpl.getChildElementsByTagName(vmEle, "argument")).isEmpty()) {
                        for (int i = 1; i <= vmArguments.size(); ++i) {
                            props.setProperty("vm.argument." + i, GSAImpl.getTrimmedTextValue(vmArguments.get(i - 1)));
                        }
                    }
                }
            }
            catch (Exception e) {
                IOException ioe = new IOException("Failed to start process based on xml configuration");
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (props.isEmpty()) {
            throw new IllegalArgumentException("Unknown service type [" + serviceType + "]");
        }
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        if (processOptions.getEnvironmentVariables() != null) {
            environment.putAll(processOptions.getEnvironmentVariables());
        }
        StringUtils.resolvePlaceholders((Properties)props, environment);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded [" + serviceType + "] configuration from  [" + resourceNameLoaded + "]");
        }
        return props;
    }

    public void serviceAdded(ServiceDiscoveryEvent event) {
        GSA gsa = (GSA)event.getPostEventServiceItem().getService();
        ServiceID serviceID = event.getPostEventServiceItem().serviceID;
        if (serviceID.equals((Object)this.getServiceID())) {
            return;
        }
        try {
            GSAHolder holder = new GSAHolder(gsa, serviceID, gsa.getJVMDetails().getPid(), gsa.getOSDetails());
            this.agents.put(serviceID.toString(), holder);
            logger.info("GSA discovered " + holder);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, "Failed to discover GSA with service id [" + serviceID + "]", e);
        }
    }

    public void serviceRemoved(ServiceDiscoveryEvent event) {
        ServiceID serviceID = event.getPreEventServiceItem().serviceID;
        GSAHolder gsa = this.agents.remove(serviceID.toString());
        if (gsa != null) {
            logger.info("GSA removed " + gsa);
        } else {
            logger.info("GSA removed " + serviceID);
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent event) {
    }

    public void appendAgentEnvironment(Map<String, String> environment, GSProcess gsProcess) {
        environment.put("AGENT_ID", "" + gsProcess.getId());
        environment.put("GSA_SERVICE_TYPE", gsProcess.getOptions().getType());
        environment.put("GSA_SERVICE_ID", this.getServiceID().toString());
        if (DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
            environment.put("ENABLE_DYNAMIC_LOCATORS", "true");
        }
        if (this.localXapManager != null) {
            environment.put("XAP_MANAGER_SERVERS", this.localXapManager);
        }
    }

    public NIODetails getNIODetails() throws RemoteException {
        return NIOInfoHelper.getDetails();
    }

    public NIOStatistics getNIOStatistics() throws RemoteException {
        return NIOInfoHelper.getNIOStatistics();
    }

    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    public long getCurrentTimestamp() throws RemoteException {
        return System.currentTimeMillis();
    }

    public OSDetails getOSDetails() throws RemoteException {
        return OSHelper.getDetails();
    }

    public OSStatistics getOSStatistics() throws RemoteException {
        return OSHelper.getStatistics();
    }

    public JVMDetails getJVMDetails() throws RemoteException {
        return JVMHelper.getDetails();
    }

    public JVMStatistics getJVMStatistics() throws RemoteException {
        return JVMHelper.getStatistics();
    }

    public void runGc() throws RemoteException {
        System.gc();
    }

    public String[] getZones() throws RemoteException {
        return ZoneHelper.getSystemZones();
    }

    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntriesDirect((LogProcessType)LogProcessType.GSA, (LogEntryMatcher)matcher);
    }

    public static List<Element> getChildElementsByTagName(Element ele, String childEleName) {
        NodeList nl = ele.getChildNodes();
        ArrayList<Element> childEles = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            String name = node.getNodeName();
            if (!(node instanceof Element) || !childEleName.equals(name)) continue;
            childEles.add((Element)node);
        }
        return childEles;
    }

    public static String getTrimmedTextValue(Element valueEle) {
        return GSAImpl.getTextValue(valueEle).trim();
    }

    public static String getTextValue(Element valueEle) {
        StringBuffer value = new StringBuffer();
        NodeList nl = valueEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }

    public boolean isServiceSecured() throws RemoteException {
        return this.securityInterceptor != null;
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        throw new SecurityException("Invalid method call.");
    }

    public SecurityContext login(SecurityContext securityContext) throws RemoteException {
        if (this.isServiceSecured()) {
            return this.securityInterceptor.authenticate(securityContext);
        }
        return null;
    }

    private static class GSAHolder {
        final GSA gsa;
        final ServiceID serviceID;
        final long pid;
        final OSDetails osDetails;

        private GSAHolder(GSA gsa, ServiceID serviceID, long pid, OSDetails osDetails) {
            this.gsa = gsa;
            this.serviceID = serviceID;
            this.pid = pid;
            this.osDetails = osDetails;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ServiceID [").append(this.serviceID).append("], ");
            if (this.pid != -1L) {
                sb.append("pid [").append(this.pid).append("],");
            }
            sb.append(" host [").append(this.osDetails.getHostName()).append("/").append(this.osDetails.getHostAddress()).append("]");
            return sb.toString();
        }
    }

    private static class SimpleSaxErrorHandler
    implements ErrorHandler {
        private SimpleSaxErrorHandler() {
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            logger.log(Level.WARNING, "Ignored XML validation warning [" + ex.getMessage() + "]", ex);
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }

    private class ProcessMonitor
    implements Runnable {
        private ProcessMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator iterator = GSAImpl.this.processes.values().iterator();
            while (iterator.hasNext()) {
                GSProcess process;
                GSProcess gSProcess = process = (GSProcess)iterator.next();
                synchronized (gSProcess) {
                    if (!GSAImpl.this.processes.containsKey(process.getId())) {
                        continue;
                    }
                    try {
                        boolean restartProcess;
                        int exitValue = process.exitValue();
                        GSProcessRestartOnExit restartOnExit = process.getRestartOnExit();
                        boolean bl = restartProcess = restartOnExit.equals((Object)GSProcessRestartOnExit.ALWAYS) || restartOnExit.equals((Object)GSProcessRestartOnExit.ONERROR) && exitValue != 0;
                        if (restartProcess) {
                            logger.warning(process.getLogId() + ": Abnormal termination with exit code [" + exitValue + "], restarting... (restart-on-exit [" + (Object)((Object)restartOnExit) + "])");
                            process.stop();
                            try {
                                process.start();
                            }
                            catch (IOException e) {
                                logger.log(Level.WARNING, process.getLogId() + ": Failed to start, removing", e);
                                GSAImpl.this.processes.remove(process.getId());
                            }
                        } else {
                            if (exitValue == 0) {
                                logger.info(process.getLogId() + ": Normal termination, removing (restart-on-exit [" + (Object)((Object)restartOnExit) + "])");
                            } else {
                                logger.warning(process.getLogId() + ": Abnormal termination with exit code [" + exitValue + "], removing (restart-on-exit [" + (Object)((Object)restartOnExit) + "])");
                            }
                            process.stop();
                            GSAImpl.this.processes.remove(process.getId());
                        }
                    }
                    catch (IllegalStateException e) {
                        if (process.getRestartOnExit().equals((Object)GSProcessRestartOnExit.NEVER)) {
                            logger.warning(process.getLogId() + " is not running. exit code unknown. restart-on-exit=" + (Object)((Object)process.getRestartOnExit()));
                            GSAImpl.this.processes.remove(process.getId());
                        } else {
                            logger.warning(process.getLogId() + ": No process. exit code unknown. restarting.  restart-on-exit=" + (Object)((Object)process.getRestartOnExit()));
                            try {
                                process.start();
                            }
                            catch (IOException e1) {
                                logger.log(Level.WARNING, process.getLogId() + ": Failed to start, removing", e);
                                GSAImpl.this.processes.remove(process.getId());
                            }
                        }
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class GlobalInstancesMonitor
    implements Runnable {
        private GlobalInstancesMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashMap<String, AgentProcessesDetails> agentsDetails = new HashMap<String, AgentProcessesDetails>();
                try {
                    agentsDetails.put(GSAImpl.this.getServiceID().toString(), GSAImpl.this.getDetails());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                for (GSAHolder gSAHolder : GSAImpl.this.agents.values()) {
                    AgentProcessesDetails details;
                    try {
                        details = gSAHolder.gsa.getDetails();
                    }
                    catch (RemoteException e) {
                        continue;
                    }
                    agentsDetails.put(details.getAgentServiceID().toString(), details);
                }
                if (logger.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Checking global instance counts:\n\r");
                    sb.append("\t").append("Self ");
                    AgentProcessesDetails agentProcessesDetails = GSAImpl.this.getDetails();
                    sb.append(agentProcessesDetails);
                    sb.append("\n\r");
                    for (GSAHolder gsa : GSAImpl.this.agents.values()) {
                        sb.append("\t").append(gsa).append(" ");
                        AgentProcessesDetails agentProcessesDetails2 = (AgentProcessesDetails)agentsDetails.get(gsa.serviceID.toString());
                        sb.append(agentProcessesDetails2);
                        sb.append("\n\r");
                    }
                    logger.fine(sb.toString());
                }
                block13: for (Map.Entry entry : GSAImpl.this.requiredGlobalInstances.entrySet()) {
                    GSProcess process;
                    String serviceType = (String)entry.getKey();
                    ArrayList<String> agentsWithServiceServiceIds = new ArrayList<String>();
                    ArrayList<String> agentsWithoutServiceServiceIds = new ArrayList<String>();
                    int globalServiceCount = 0;
                    for (AgentProcessesDetails agentProcessesDetails : agentsDetails.values()) {
                        if (!agentProcessesDetails.getRequiredGlobalInstances().containsKey(serviceType) || agentProcessesDetails.getRequiredGlobalInstances().get(serviceType) <= 0) continue;
                        boolean added = false;
                        for (AgentProcessDetails details : agentProcessesDetails.getProcessDetails()) {
                            if (!details.getServiceType().equals(serviceType)) continue;
                            added = true;
                            ++globalServiceCount;
                            agentsWithServiceServiceIds.add(agentProcessesDetails.getAgentServiceID().toString());
                        }
                        if (added) continue;
                        agentsWithoutServiceServiceIds.add(agentProcessesDetails.getAgentServiceID().toString());
                    }
                    Collections.sort(agentsWithServiceServiceIds);
                    Collections.sort(agentsWithoutServiceServiceIds);
                    if (globalServiceCount > (Integer)entry.getValue()) {
                        if (agentsWithServiceServiceIds.isEmpty() || !((String)agentsWithServiceServiceIds.get(0)).equals(GSAImpl.this.getServiceID().toString())) continue;
                        Iterator iterator = GSAImpl.this.processes.values().iterator();
                        while (iterator.hasNext()) {
                            GSProcess added = process = (GSProcess)iterator.next();
                            synchronized (added) {
                                if (!GSAImpl.this.processes.containsKey(process.getId())) {
                                    continue;
                                }
                                if (process.getOptions().getType().equals(serviceType)) {
                                    GSAImpl.this.processes.remove(process.getId());
                                    logger.info(process.getLogId() + ": Global instances (" + globalServiceCount + ") breached, removing instance...");
                                    process.stop();
                                    continue block13;
                                }
                            }
                        }
                        continue;
                    }
                    if (globalServiceCount >= (Integer)entry.getValue() || agentsWithoutServiceServiceIds.isEmpty() || !((String)agentsWithoutServiceServiceIds.get(0)).equals(GSAImpl.this.getServiceID().toString())) continue;
                    GSProcessOptions options = new GSProcessOptions(serviceType);
                    process = null;
                    try {
                        Properties serviceProps = GSAImpl.this.getProperties(options);
                        options.setUseScript(serviceProps.getProperty("initial-instances", "script").equalsIgnoreCase("script"));
                        int id = currentId.incrementAndGet();
                        process = new GSProcess(id, options, serviceProps, InstantiationMode.GLOBAL, GSAImpl.this);
                        logger.info(process.getLogId() + ": Global instances (" + globalServiceCount + ") breached, adding instance...");
                        process.start();
                        GSAImpl.this.processes.put(id, process);
                    }
                    catch (Exception e) {
                        if (process != null) {
                            logger.log(Level.WARNING, process.getLogId() + ": Failed to start, exiting", e);
                            continue;
                        }
                        logger.log(Level.WARNING, serviceType + ": Failed to start, exiting", e);
                    }
                }
                logger.fine("Done checking global instance counts");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to globally check instance counts", e);
            }
        }
    }
}

