/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.log.CompoundLogEntries;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.id.Uuid;
import org.jini.rio.resources.servicecore.AbstractProxy;

public class GSAProxy
extends AbstractProxy
implements GSA,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;

    static GSAProxy getInstance(GSA gsc, Uuid id) {
        return new GSAProxy(gsc, id);
    }

    protected GSAProxy(GSA gsa, Uuid id) {
        super((Remote)((Object)gsa), id);
    }

    @Override
    public int startProcess(GSProcessOptions options) throws RemoteException, IOException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        return ((GSA)((Object)this.server)).startProcess(options);
    }

    @Override
    public void killProcess(int id) throws RemoteException, IllegalArgumentException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        ((GSA)((Object)this.server)).killProcess(id);
    }

    @Override
    public void restartProcess(int id) throws IOException, RemoteException, IllegalArgumentException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        ((GSA)((Object)this.server)).restartProcess(id);
    }

    @Override
    public void shutdown() throws RemoteException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        ((GSA)((Object)this.server)).shutdown();
    }

    @Override
    public AgentProcessesDetails getDetails() throws RemoteException {
        return ((GSA)((Object)this.server)).getDetails();
    }

    @Override
    public CompoundLogEntries logEntries(LogProcessType[] types, long[] pids, LogEntryMatcher matcher) throws RemoteException, IOException {
        CompoundLogEntries logEntries = ((GSA)((Object)this.server)).logEntries(types, pids, matcher);
        LogEntries[] x = logEntries.getEntries();
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == null) continue;
            x[i] = InternalLogHelper.clientSideProcess((LogEntryMatcher)matcher, (LogEntries)x[i]);
        }
        return logEntries;
    }

    @Override
    public LogEntries logEntries(LogProcessType type, long pid, LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.clientSideProcess((LogEntryMatcher)matcher, (LogEntries)((GSA)((Object)this.server)).logEntries(type, pid, matcher));
    }

    @Override
    public CompoundLogEntries logEntries(LogProcessType type, LogEntryMatcher matcher) throws RemoteException, IOException {
        CompoundLogEntries logEntries = ((GSA)((Object)this.server)).logEntries(type, matcher);
        LogEntries[] x = logEntries.getEntries();
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == null) continue;
            x[i] = InternalLogHelper.clientSideProcess((LogEntryMatcher)matcher, (LogEntries)x[i]);
        }
        return logEntries;
    }

    public boolean isServiceSecured() throws RemoteException {
        return ((GSA)((Object)this.server)).isServiceSecured();
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        return this.login((RemoteSecuredService)this.server, credentialsProvider);
    }
}

