/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.grid.gsa.GSAImpl;
import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.grid.gsa.GSProcessRestartOnExit;
import com.gigaspaces.grid.gsa.InstantiationMode;
import com.gigaspaces.grid.gsa.ShutdownProcessHandler;
import com.gigaspaces.internal.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import org.jini.rio.boot.BootUtil;

public class GSProcess {
    private static final String LOCATORS_PROP_PLACEHOLDER = "$LOCATORS_PROP_PLACEHOLDER$";
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsa");
    private static final long PROCESS_KILL_TIMEOUT = Long.getLong("com.gs.service-grid.process-kill-timeout", 5000L);
    private final int id;
    private volatile long processId = -1L;
    private final Properties properties;
    private final GSProcessOptions options;
    private final InstantiationMode instantiationMode;
    private final GSAImpl gsa;
    private final List<String> command;
    private final ShutdownProcessHandler shutdownProcessHandler;
    private final Pattern[] restartPatterns;
    private Process process;
    private ExecutorService executorService;
    private ProcessReader reader;

    public GSProcess(int id, GSProcessOptions options, Properties properties, InstantiationMode instantiationMode, GSAImpl gsa) {
        this.id = id;
        this.options = options;
        this.instantiationMode = instantiationMode;
        this.properties = properties;
        this.gsa = gsa;
        String shutdownProcessClass = properties.getProperty("shutdown.class");
        if (shutdownProcessClass != null && shutdownProcessClass.length() > 0) {
            try {
                this.shutdownProcessHandler = (ShutdownProcessHandler)GSProcess.class.getClassLoader().loadClass(shutdownProcessClass).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create shutdown class [" + shutdownProcessClass + "]", e);
            }
        } else {
            this.shutdownProcessHandler = null;
        }
        String[] restartRegex = this.parseArguments(properties, "restart-regex.");
        this.restartPatterns = new Pattern[restartRegex.length];
        for (int i = 0; i < restartRegex.length; ++i) {
            this.restartPatterns[i] = Pattern.compile(restartRegex[i]);
        }
        this.command = new ArrayList<String>();
        if (options.isUseScript()) {
            boolean isWindowsOS = System.getProperty("os.name").startsWith("Win");
            String script = isWindowsOS ? properties.getProperty("script.windows") : properties.getProperty("script.unix");
            this.command.add(script);
            if (options.getScriptArguments() != null) {
                this.command.addAll(Arrays.asList(options.getScriptArguments()));
            } else {
                this.command.addAll(Arrays.asList(this.parseArguments(properties, "script.argument.")));
                if (options.getScriptAppendableArguments() != null) {
                    this.command.addAll(Arrays.asList(options.getScriptAppendableArguments()));
                }
            }
            Map<String, String> environment = this.extractProperties(properties, "script.environment.");
            if (options.getEnvironmentVariables() == null) {
                options.setEnvironmentVariables(environment);
            } else {
                options.getEnvironmentVariables().putAll(environment);
            }
        } else {
            this.command.add(this.getJVM());
            if (options.getVmInputArguments() != null) {
                this.command.addAll(Arrays.asList(options.getVmInputArguments()));
                for (String inputSrguemnt : this.getInputArguments()) {
                    if (!inputSrguemnt.contains("com.gs.jini_lus.groups") && !inputSrguemnt.contains("com.gs.jini_lus.locators")) continue;
                    if (inputSrguemnt.startsWith("-")) {
                        this.command.add(inputSrguemnt);
                        continue;
                    }
                    int lastIndex = this.command.size() - 1;
                    this.command.set(lastIndex, this.command.get(lastIndex) + " " + inputSrguemnt);
                }
            } else {
                for (String inputSrguemnt : this.getInputArguments()) {
                    if (inputSrguemnt.startsWith("-")) {
                        this.command.add(inputSrguemnt);
                        continue;
                    }
                    int lastIndex = this.command.size() - 1;
                    this.command.set(lastIndex, this.command.get(lastIndex) + " " + inputSrguemnt);
                }
                this.command.addAll(Arrays.asList(this.parseArguments(properties, "vm.input-argument.")));
                if (options.getVmAppendableInputArguments() != null) {
                    this.command.addAll(Arrays.asList(options.getVmAppendableInputArguments()));
                }
            }
            this.command.add("-DagentId=" + id);
            this.command.add("-DgsaServiceID=" + gsa.getServiceID());
            this.command.add("-DenableDynamicLocators=" + DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled());
            if (DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
                this.command.add(LOCATORS_PROP_PLACEHOLDER);
            }
            this.command.add("-cp");
            this.command.add(this.getClasspath(properties));
            String mainClass = properties.getProperty("vm.main-class");
            if (mainClass == null) {
                throw new IllegalArgumentException("When starting [" + options.getType() + "] with virtual machine, main class must be provided");
            }
            this.command.add(mainClass);
            if (options.getVmArguments() != null) {
                this.command.addAll(Arrays.asList(options.getVmArguments()));
            } else {
                this.command.addAll(Arrays.asList(this.parseArguments(properties, "vm.argument.")));
                if (options.getVmAppendableArguments() != null) {
                    this.command.addAll(Arrays.asList(options.getVmAppendableArguments()));
                }
            }
        }
    }

    public String getLogId() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getOptions().getType()).append("][").append(this.getId()).append("/");
        if (this.processId != -1L) {
            sb.append(this.processId);
        }
        sb.append("]");
        return sb.toString();
    }

    public int getId() {
        return this.id;
    }

    public long getProcessId() {
        return this.processId;
    }

    public GSProcessOptions getOptions() {
        return this.options;
    }

    public InstantiationMode getInstantiationMode() {
        return this.instantiationMode;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public GSAImpl getGSA() {
        return this.gsa;
    }

    private void updateGSProcessOptionsWithDynamicLocators(GSProcessOptions options) throws RemoteException {
        LookupLocator[] lookupLocators = ((JoinAdmin)this.getGSA().getAdmin()).getLookupLocators();
        String currentLocators = BootUtil.toLookupLocatorURLs((LookupLocator[])lookupLocators, (boolean)true);
        if (options.isUseScript()) {
            if (options.getEnvironmentVariables() == null) {
                options.setEnvironmentVariables(new HashMap<String, String>());
            }
            Map<String, String> env = options.getEnvironmentVariables();
            env.put("XAP_LOOKUP_LOCATORS", currentLocators);
        } else {
            String locatorsPropPrefix = "-Dcom.gs.jini_lus.locators=";
            String locatorsProp = locatorsPropPrefix + currentLocators;
            for (int i = 0; i < this.command.size(); ++i) {
                if (!LOCATORS_PROP_PLACEHOLDER.equals(this.command.get(i)) && !this.command.get(i).startsWith(locatorsPropPrefix)) continue;
                this.command.set(i, locatorsProp);
            }
        }
    }

    public synchronized void start() throws IOException {
        String workDir;
        if (DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
            this.updateGSProcessOptionsWithDynamicLocators(this.options);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.options.isUseScript()) {
            workDir = this.properties.getProperty("script.work-dir");
            if (StringUtils.hasLength((String)workDir)) {
                processBuilder.directory(new File(workDir));
            }
        } else {
            workDir = this.properties.getProperty("vm.work-dir");
            if (StringUtils.hasLength((String)workDir)) {
                processBuilder.directory(new File(workDir));
            }
        }
        if (this.options.getEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : this.options.getEnvironmentVariables().entrySet()) {
                processBuilder.environment().put(entry.getKey(), entry.getValue());
            }
        }
        this.gsa.appendAgentEnvironment(processBuilder.environment(), this);
        processBuilder.command(this.command);
        processBuilder.redirectErrorStream(true);
        logger.info(this.getLogId() + ": Starting with command " + this.command);
        this.executorService = Executors.newSingleThreadExecutor();
        this.process = processBuilder.start();
        this.reader = new ProcessReader();
        this.executorService.submit(this.reader);
    }

    public synchronized int exitValue() throws IllegalThreadStateException, IllegalStateException {
        if (this.process == null) {
            throw new IllegalStateException();
        }
        return this.process.exitValue();
    }

    public synchronized void sendStop() {
        if (this.process == null) {
            return;
        }
        if (this.shutdownProcessHandler != null) {
            this.shutdownProcessHandler.shutdown(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.process == null) {
            return;
        }
        logger.info(this.getLogId() + ": Stopping process");
        long scheduledSystemBootTime = Long.parseLong(System.getProperty("gs.start.scheduledSystemBootTime", "10000"));
        int numberOfRetries = (int)(scheduledSystemBootTime / 100L * 2L);
        int stopWaitCount = 0;
        try {
            if (this.shutdownProcessHandler != null) {
                this.shutdownProcessHandler.shutdown(this);
            }
            while (!this.reader.isStopped() && this.process.isAlive() && stopWaitCount++ <= numberOfRetries) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (stopWaitCount <= numberOfRetries) {
                logger.info(this.getLogId() + ": Process stopped successfully through shutdown hook");
            }
            if (this.shutdownProcessHandler != null) {
                this.shutdownProcessHandler.afterShutdown(this);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            if (this.process.isAlive()) {
                logger.info(this.getLogId() + ": Process is still alive - Killing with process.destroy.");
                this.process.destroy();
                try {
                    this.process.waitFor(PROCESS_KILL_TIMEOUT, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.process.isAlive()) {
                    logger.info(this.getLogId() + ": Process is still alive - Killing with process.destroyForcibly.");
                    this.process.destroyForcibly();
                    if (this.process.isAlive()) {
                        logger.warning(this.getLogId() + ": Process is still alive.");
                    }
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            if (stopWaitCount > numberOfRetries) {
                logger.info(this.getLogId() + ": Process destroyed without shutdown hook");
            }
            this.reader.stop();
            this.executorService.shutdownNow();
            this.process = null;
            this.processId = -1L;
        }
    }

    private String getJVM() {
        StringBuilder buff = new StringBuilder();
        String javaCmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        buff.append(javaCmd);
        boolean isWindows = System.getProperty("os.name").startsWith("Win");
        if (isWindows) {
            buff.append(".exe");
        }
        return buff.toString();
    }

    protected Process getProcess() {
        return this.process;
    }

    private List<String> getInputArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    private String getClasspath(Properties properties) {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        String[] additionalClasspath = this.parseArguments(properties, "vm.classpath.");
        StringBuilder sb = new StringBuilder(classPath);
        if (additionalClasspath.length > 0 && classPath.length() > 0 && classPath.charAt(classPath.length() - 1) != File.pathSeparatorChar) {
            sb.append(File.pathSeparatorChar);
        }
        for (String addClasspath : additionalClasspath) {
            sb.append(addClasspath);
            sb.append(File.pathSeparatorChar);
        }
        return sb.toString();
    }

    private String[] parseArguments(Properties props, String prefix) {
        ArrayList<ArgumentHolder> argumentHolders = new ArrayList<ArgumentHolder>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix) || (value = (String)entry.getValue()) == null || value.length() <= 0) continue;
            int index = Integer.parseInt(key.substring(prefix.length()));
            ArgumentHolder argumentHolder = new ArgumentHolder();
            argumentHolder.index = index;
            argumentHolder.value = value;
            argumentHolders.add(argumentHolder);
        }
        if (argumentHolders.isEmpty()) {
            return new String[0];
        }
        Collections.sort(argumentHolders, new Comparator<ArgumentHolder>(){

            @Override
            public int compare(ArgumentHolder o1, ArgumentHolder o2) {
                return o1.index.compareTo(o2.index);
            }
        });
        String[] retVal = new String[argumentHolders.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = ((ArgumentHolder)argumentHolders.get((int)i)).value;
        }
        return retVal;
    }

    private Map<String, String> extractProperties(Properties props, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix) || (value = (String)entry.getValue()) == null || value.length() <= 0) continue;
            result.put(key.substring(prefix.length()), value);
        }
        return result;
    }

    public GSProcessRestartOnExit getRestartOnExit() {
        GSProcessRestartOnExit value = GSProcessRestartOnExit.ALWAYS;
        if (this.options.getRestartOnExit() != null) {
            value = this.options.getRestartOnExit();
        } else {
            String propertyValue = this.getProperties().getProperty("restart-on-exit");
            if (StringUtils.hasText((String)propertyValue)) {
                value = GSProcessRestartOnExit.convertFromXmlValue(propertyValue);
            }
        }
        return value;
    }

    private static class ArgumentHolder {
        Integer index;
        String value;

        private ArgumentHolder() {
        }
    }

    private class ProcessReader
    implements Runnable {
        private final BufferedReader in;
        private volatile boolean stopped = false;

        public ProcessReader() {
            this.in = new BufferedReader(new InputStreamReader(GSProcess.this.process.getInputStream()));
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                String line = this.readLine();
                if (line == null) continue;
                if (GSProcess.this.shutdownProcessHandler != null && GSProcess.this.shutdownProcessHandler.isShutdownVerification(GSProcess.this, line)) {
                    this.stopped = true;
                    continue;
                }
                if (line.startsWith("pid=")) {
                    try {
                        GSProcess.this.processId = Long.parseLong(line.substring("pid=".length()));
                        logger.info(GSProcess.this.getLogId() + ": Assigned process id");
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Failed to read process id", e);
                    }
                } else {
                    System.out.print(GSProcess.this.getLogId());
                    System.out.print("\t");
                    System.out.println(line);
                }
                for (Pattern pattern : GSProcess.this.restartPatterns) {
                    if (!pattern.matcher(line).matches()) continue;
                    GSProcess.this.gsa.processError(GSProcess.this, "Restart Regex [" + pattern.pattern() + "] matching [" + line + "]");
                }
            }
        }

        public String readLine() {
            try {
                return this.in.readLine();
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

