/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsa;

import com.gigaspaces.grid.gsa.GSAImpl;
import com.gigaspaces.grid.gsa.GSProcess;
import com.gigaspaces.grid.gsa.ShutdownProcessHandler;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;

public class GigaSpacesShutdownProcessHandler
implements ShutdownProcessHandler {
    @Override
    public void afterShutdown(GSProcess process) {
        File workLocation = new File(SystemInfo.singleton().locations().work());
        File f = new File(workLocation, "/gsa/gsa-" + process.getGSA().getServiceID() + "-" + process.getId() + "-stop");
        if (f.exists()) {
            f.delete();
        }
    }

    @Override
    public void shutdown(GSProcess process) {
        File workLocation = new File(SystemInfo.singleton().locations().work());
        File f = new File(workLocation, "/gsa/gsa-" + process.getGSA().getServiceID() + "-" + process.getId() + "-stop");
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            raf.write(1);
            raf.close();
        }
        catch (IOException e) {
            GSAImpl.logger.log(Level.WARNING, process.getLogId() + ": Failed to write stop request", e);
        }
    }

    @Override
    public boolean isShutdownVerification(GSProcess process, String line) {
        return "gsa-exit-done".equals(line);
    }
}

