/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.ClassAnnotator;
import org.jini.rio.resources.util.PropertyHelper;

public class AdaptiveClassAnnotator
extends ClassAnnotator {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsc");

    public AdaptiveClassAnnotator(URL[] codebase, Properties props) {
        super(codebase, props);
    }

    public void setAnnotationURLs(URL[] urls) {
        Properties p = this.getProperties();
        String adaptCodebase = p.getProperty("adaptiveCodebase");
        if (adaptCodebase != null && adaptCodebase.equals("yes")) {
            super.setAnnotationURLs(this.adaptAnnotation(urls));
        } else {
            super.setAnnotationURLs(urls);
        }
    }

    private URL[] adaptAnnotation(URL[] urls) {
        ArrayList<URL> codebaseList = new ArrayList<URL>();
        String codeserver = System.getProperty("com.gigaspaces.system.codeserver");
        if (codeserver == null) {
            logger.finest("Could not obtain a Webster instance");
            return urls;
        }
        String codeserverAddr = codeserver.substring(4);
        for (int i = 0; i < urls.length; ++i) {
            String proto = urls[i].getProtocol();
            boolean fromFile = false;
            if (proto.equals("file")) {
                proto = "http";
                fromFile = true;
            }
            URL url = null;
            try {
                url = new URL(proto + codeserverAddr + this.getJarPart(urls[i]));
                codebaseList.add(this.canServe(urls[i], url, fromFile));
                continue;
            }
            catch (MalformedURLException e) {
                codebaseList.add(urls[i]);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Bad URL [" + proto + codeserverAddr + this.getJarPart(urls[i]) + "]", e);
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Bad URL [" + proto + codeserverAddr + this.getJarPart(urls[i]) + "]");
            }
        }
        URL[] modifiedCodebase = codebaseList.toArray(new URL[codebaseList.size()]);
        if (logger.isLoggable(Level.FINEST)) {
            int i;
            StringBuilder buffer = new StringBuilder("Original codebase\n");
            for (i = 0; i < urls.length; ++i) {
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append("\t" + urls[i].toExternalForm());
            }
            buffer.append("\nAdapted codebase\n");
            for (i = 0; i < modifiedCodebase.length; ++i) {
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append("\t" + modifiedCodebase[i].toExternalForm());
            }
            logger.finest(buffer.toString());
        }
        return modifiedCodebase;
    }

    private URL canServe(URL original, URL candidate, boolean fromFile) {
        URL chosenOne;
        block9: {
            chosenOne = null;
            String fileName = candidate.getFile();
            if (fileName != null && !fileName.endsWith("/")) {
                try {
                    if (fromFile) {
                        URLConnection conn = candidate.openConnection();
                        if (conn.getContentLength() > 0) {
                            chosenOne = candidate;
                        } else {
                            chosenOne = original;
                            File f = new File(new URI(original.toString()));
                            if (!f.exists()) {
                                logger.warning("The file [" + f.getAbsolutePath() + "] does not exist, the codebase is invalid");
                            } else {
                                logger.warning("File based codebase could not be adapted using [" + candidate.toExternalForm() + "], remote clients may not be able to load proxy");
                            }
                        }
                        break block9;
                    }
                    chosenOne = candidate;
                }
                catch (Exception e) {
                    chosenOne = original;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Cannot serve [" + candidate.toExternalForm() + "]", e);
                    }
                    break block9;
                }
            }
            chosenOne = candidate;
        }
        return chosenOne;
    }

    private String getDigest(URL url) {
        String file = url.getFile();
        StringTokenizer tok = new StringTokenizer(file, "/;=");
        tok.nextToken();
        tok.nextToken();
        String digest = tok.nextToken();
        return digest;
    }

    private String getJarPart(URL url) {
        int ndx;
        Properties p = this.getProperties();
        String configuredCodebase = p.getProperty("configuredCodebase");
        if (configuredCodebase != null) {
            configuredCodebase = PropertyHelper.expandProperties(configuredCodebase, PropertyHelper.RUNTIME);
            try {
                URL u = new URL(configuredCodebase);
                configuredCodebase = u.toExternalForm();
            }
            catch (MalformedURLException e) {
                configuredCodebase = null;
            }
        }
        String jarPart = null;
        String s = url.toExternalForm();
        jarPart = s.startsWith("file:") ? (configuredCodebase != null && s.indexOf(configuredCodebase) != -1 ? s.substring(configuredCodebase.length()) : ((ndx = s.lastIndexOf("/")) == -1 ? "" : s.substring(ndx))) : url.getFile();
        if (!jarPart.startsWith("/")) {
            jarPart = "/" + jarPart;
        }
        return jarPart;
    }

    private void drainStream(InputStream is) throws IOException {
        BufferedInputStream reader = new BufferedInputStream(is);
        while (reader.read() != -1) {
        }
    }
}

