/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class CPULoadDetector {
    private static final Logger logger = Logger.getLogger(CPULoadDetector.class.getName());
    private final int frequency;
    private final int allowedDiversion;
    private final int maxViolationRepetition;
    private Timer timer;
    private long expectedNextWakeUpMillis;
    private int violationRepetition;

    public CPULoadDetector(int frequency, int allowedDiversion, int maxViolationRepetition) {
        this.frequency = frequency;
        this.allowedDiversion = allowedDiversion;
        this.maxViolationRepetition = maxViolationRepetition;
    }

    public CPULoadDetector() {
        this(10, 1000, 20);
    }

    public synchronized void start() {
        if (this.timer != null) {
            this.stop();
        }
        this.timer = new Timer("CPULoadDetector", true);
        this.fire();
    }

    private void fire() {
        this.expectedNextWakeUpMillis = System.currentTimeMillis() + (long)(this.frequency * 1000);
        this.timer.schedule((TimerTask)new CPULoadTimerTask(), this.frequency * 1000);
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.violationRepetition = 0;
    }

    private class CPULoadTimerTask
    extends TimerTask {
        private CPULoadTimerTask() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            if ((long)CPULoadDetector.this.allowedDiversion < currentTime - CPULoadDetector.this.expectedNextWakeUpMillis) {
                logger.finest("scheduling delay violation " + (currentTime - CPULoadDetector.this.expectedNextWakeUpMillis) + " milliseconds.");
                ++CPULoadDetector.this.violationRepetition;
            } else {
                CPULoadDetector.this.violationRepetition = Math.max(0, CPULoadDetector.this.violationRepetition - 1);
            }
            if (CPULoadDetector.this.maxViolationRepetition <= CPULoadDetector.this.violationRepetition) {
                CPULoadDetector.this.violationRepetition = 0;
                int delay = (int)(currentTime - CPULoadDetector.this.expectedNextWakeUpMillis);
                logger.warning("Scheduling delay violation detected. Current thread scheduling delay is " + delay + " milliseconds.");
            }
            CPULoadDetector.this.fire();
        }
    }
}

