/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.grid.gsa.AgentHelper;
import com.gigaspaces.grid.gsc.CPULoadDetector;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsc.GSCProxy;
import com.gigaspaces.grid.security.gsc.SecuredGSCExtension;
import com.gigaspaces.grid.security.gsc.SecuredGSCProxy;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpHelper;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.utils.ClassLoaderUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.gigaspaces.security.service.SecurityResolver;
import com.gigaspaces.start.ClasspathBuilder;
import com.gigaspaces.start.Locator;
import com.gigaspaces.start.SystemBoot;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.XapModules;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.sun.jini.config.Config;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceInfo;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.Schedule;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.provision.ServiceProvisionEvent;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.opstring.OpStringLoader;

public class GSCImpl
extends CybernodeImpl
implements GSC,
RemoteSecuredService {
    static final String ROOT_COMPONENT = "com.gigaspaces";
    static final String GRID_COMPONENT = "com.gigaspaces.grid";
    static final String SYSTEM_COMPONENT_NAME = "com.gigaspaces.system";
    static final String CONFIG_COMPONENT = "com.gigaspaces.grid.gsc";
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsc");
    static final String SPACE_PROPERTY_PREFIX = "gs.space.url.arg.";
    private SecurityInterceptor securityInterceptor;
    private CPULoadDetector cpuLoadDetector;
    private MetricManager metricManager;

    public GSCImpl() throws Exception {
        this.initialize();
    }

    public GSCImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        super(configArgs, lifeCycle);
        this.initialize();
        Properties p = GSCImpl.parseArguments(configArgs);
        if (!p.isEmpty()) {
            logger.info("Starting processing unit instance with: " + p);
            try {
                this.instantiate(new ServiceProvisionEvent(this, null, GSCImpl.toServiceElement(p)));
            }
            catch (Exception e) {
                logger.severe("Failed to instantiate: " + e);
                throw e;
            }
        }
    }

    private static Properties parseArguments(String[] args) {
        Properties p = new Properties();
        for (String arg : args) {
            int pos;
            if (!arg.startsWith("--") || (pos = arg.indexOf(61)) == -1) continue;
            String key = arg.substring(2, pos);
            String value = arg.substring(pos + 1);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            p.setProperty(key, value);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceElement toServiceElement(Properties p) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException {
        long instanceID;
        OperationalString operationalString;
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader tempClassLoader = new URLClassLoader(new ClasspathBuilder().appendLib(XapModules.ADMIN.getJarFilePath()).toURLsArray(), origClassLoader);
        Thread.currentThread().setContextClassLoader(tempClassLoader);
        try {
            Class<?> c = tempClassLoader.loadClass("org.openspaces.admin.internal.gsm.DefaultGridServiceManager");
            Method method = c.getMethod("toOperationalString", Properties.class);
            operationalString = (OperationalString)method.invoke(null, p);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
            tempClassLoader.close();
        }
        int partitionId = Integer.parseInt(p.getProperty("partitionId", "0"));
        boolean ha = Boolean.parseBoolean(p.getProperty("ha", "false"));
        String clusterGroup = String.valueOf(ha ? partitionId : 1);
        if (p.containsKey("partitions")) {
            int backupId = Integer.parseInt(p.getProperty("backupId", "0"));
            instanceID = ha ? (long)(backupId + 1) : (long)partitionId;
        } else {
            instanceID = Integer.parseInt(p.getProperty("instanceId"));
        }
        for (ServiceElement serviceElement : operationalString.getServices()) {
            if (!serviceElement.getServiceBeanConfig().getInitParameters().get("clusterGroup").equals(clusterGroup)) continue;
            serviceElement.getServiceBeanConfig().setInstanceID(instanceID);
            return serviceElement;
        }
        throw new IllegalStateException("Failed to find matching ServiceElement for partition " + partitionId);
    }

    public GSCImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        super(activationID, data);
        this.initialize();
    }

    private void initialize() {
        this.metricManager = MetricManager.acquire();
    }

    @Override
    protected Object createProxy() {
        if (this.securityInterceptor != null) {
            return SecuredGSCProxy.getInstance((GSC)((Object)this.getExportedProxy()), this.getUuid());
        }
        return GSCProxy.getInstance((GSC)((Object)this.getExportedProxy()), this.getUuid());
    }

    @Override
    protected void initializeJMX(Object mbean) throws Exception {
        if (this.isServiceSecured()) {
            mbean = new SecuredGSCExtension(mbean);
        }
        super.initializeJMX(mbean);
    }

    @Override
    protected void bootstrap(String[] configArgs) throws Exception {
        this.setConfigComponent(CONFIG_COMPONENT);
        super.bootstrap(configArgs);
    }

    @Override
    public void initialize(ServiceBeanContext context) throws Exception {
        this.cpuLoadDetector = new CPULoadDetector();
        this.cpuLoadDetector.start();
        if (System.getProperty("com.gigaspaces.grid.gsc.home") == null) {
            String gigaHome = Locator.getProductHomeDirectoryName();
            System.setProperty("org.jini.rio.home", gigaHome);
            System.setProperty("com.gigaspaces.grid.gsc.home", gigaHome);
        }
        System.setProperty("com.gigaspaces.gsc.running", "true");
        System.setProperty("com.gs.start-embedded-lus", "false");
        System.setProperty("com.gs.embedded-services.httpd.enabled", "false");
        System.setProperty("com.gigaspaces.lookupfinder.actualclose", "false");
        SystemBoot.iAmTheGSC();
        SystemBoot.addShutdownHook((Thread)new Thread(){

            @Override
            public void run() {
                LookupFinder.forceClose();
                SharedDiscoveryManagement.forceTerminate();
            }
        });
        RuntimeInfo.logRuntimeInfo((Logger)logger, (String)"Starting GSC...");
        LicenseManager.getInstance().validate("Service Grid", LicenseType.PREMIUM);
        System.setProperty("com.j_spaces.core.container.shutdown_hook", "false");
        if (SecurityResolver.isSecurityEnabled()) {
            this.securityInterceptor = new SecurityInterceptor("grid");
        }
        super.initialize(context);
        JMXConnection jmxEntry = JMXUtilities.createJMXConnectionAttribute((String)context.getServiceElement().getName());
        if (jmxEntry != null) {
            this.addAttribute((Entry)jmxEntry);
        }
        long initialServiceLoadDelay = 5000L;
        try {
            initialServiceLoadDelay = Config.getLongEntry((Configuration)context.getConfiguration(), (String)GSCImpl.getConfigComponent(), (String)"initialServiceLoadDelay", (long)initialServiceLoadDelay, (long)0L, (long)Long.MAX_VALUE);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception getting initialServiceLoadDelay", t);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("initialServiceLoadDelay=" + initialServiceLoadDelay);
        }
        if (initialServiceLoadDelay > 0L) {
            long now = System.currentTimeMillis();
            this.getTaskTimer().schedule((TimerTask)new InitialServicesLoadTask(context.getConfiguration()), new Date(now + initialServiceLoadDelay));
        } else {
            InitialServicesLoadTask serviceLoader = new InitialServicesLoadTask(context.getConfiguration());
            serviceLoader.loadInitialServices();
        }
    }

    @Override
    public void advertise() throws IOException {
        super.advertise();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("GSC started successfully [groups=" + Arrays.toString(this.admin.getLookupGroups()) + ", locators=" + Arrays.toString(this.admin.getLookupLocators()) + ", service-id=" + this.getServiceID() + "]");
            logger.info(ClassLoaderUtils.getCurrentClassPathString((String)"GSC Class Loader"));
        }
    }

    @Override
    public void destroy(boolean force) {
        logger.info("Stopping GSC");
        if (this.cpuLoadDetector != null) {
            this.cpuLoadDetector.stop();
        }
        if (this.metricManager != null) {
            this.metricManager.close();
        }
        super.destroy(force);
    }

    private void activate(ServiceElement sElem) {
        ServiceProvisionEvent spe = new ServiceProvisionEvent(this.getServiceProxy(), null, sElem);
        try {
            this.instantiate(spe);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Activating service [" + sElem.getName() + "]", t);
        }
    }

    @Override
    protected ServiceInfo getServiceInfo() {
        return new ServiceInfo(this.context.getServiceElement().getName(), "GigaSpaces Technologies, Inc.", "", PlatformVersion.getOfficialVersion(), "", "");
    }

    void dumpOpStringError(Map errorMap) {
        if (!errorMap.isEmpty()) {
            Set keys = errorMap.keySet();
            StringBuilder sb = new StringBuilder("+========================+\n");
            for (Object comp : keys) {
                sb.append("Component: " + comp);
                Object o = errorMap.get(comp);
                if (o instanceof Throwable) {
                    StackTraceElement[] el = ((Throwable)o).getStackTrace();
                    for (int i = 0; i < el.length; ++i) {
                        sb.append("\tat " + el[i] + "\n");
                    }
                    continue;
                }
                sb.append(" " + o.toString());
            }
            sb.append("\n+========================+");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, sb.toString());
            }
        }
    }

    @Override
    public Schedule getSchedule() throws RemoteException {
        return this.getAvailabilitySchedule();
    }

    @Override
    public void enlist(Schedule schedule) throws RemoteException {
        this.doEnlist(schedule);
    }

    @Override
    public void release(boolean terminateServices) throws RemoteException {
        TimerTask[] registrationTasks = this.getRegistrationTasks();
        for (int i = 0; i < registrationTasks.length; ++i) {
            registrationTasks[i].cancel();
        }
        this.setEnlisted(false);
    }

    public int getAgentId() {
        return AgentHelper.getAgentId();
    }

    public String getGSAServiceID() throws RemoteException {
        return AgentHelper.getGSAServiceID();
    }

    public NIODetails getNIODetails() throws RemoteException {
        return NIOInfoHelper.getDetails();
    }

    public NIOStatistics getNIOStatistics() throws RemoteException {
        return NIOInfoHelper.getNIOStatistics();
    }

    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    public long getCurrentTimestamp() throws RemoteException {
        return System.currentTimeMillis();
    }

    public OSDetails getOSDetails() throws RemoteException {
        return OSHelper.getDetails();
    }

    public OSStatistics getOSStatistics() throws RemoteException {
        return OSHelper.getStatistics();
    }

    public JVMDetails getJVMDetails() throws RemoteException {
        return JVMHelper.getDetails();
    }

    public JVMStatistics getJVMStatistics() throws RemoteException {
        return JVMHelper.getStatistics();
    }

    public void runGc() throws RemoteException {
        System.gc();
    }

    public String[] getZones() throws RemoteException {
        return ZoneHelper.getSystemZones();
    }

    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntriesDirect((LogProcessType)LogProcessType.GSC, (LogEntryMatcher)matcher);
    }

    public void reloadMetricConfiguration() throws RemoteException {
        MetricManager.reloadIfStarted();
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("gsc", this);
        return InternalDumpHelper.generateDump(cause, context);
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context, String ... contributors) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("gsc", this);
        return InternalDumpHelper.generateDump(cause, context, contributors);
    }

    public byte[] dumpBytes(String file, long from, int length) throws RemoteException, IOException {
        return InternalDumpHelper.dumpBytes(file, from, length);
    }

    public boolean isServiceSecured() throws RemoteException {
        return this.securityInterceptor != null;
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        throw new SecurityException("Invalid method call.");
    }

    public SecurityContext login(SecurityContext securityContext) throws RemoteException {
        if (this.isServiceSecured()) {
            return this.securityInterceptor.authenticate(securityContext);
        }
        return null;
    }

    class InitialServicesLoadTask
    extends TimerTask {
        Configuration config;

        InitialServicesLoadTask(Configuration config) {
            if (config == null) {
                throw new NullPointerException("config is null");
            }
            this.config = config;
        }

        @Override
        public void run() {
            this.loadInitialServices();
        }

        void loadInitialServices() {
            String[] initialServices = new String[]{};
            try {
                initialServices = (String[])this.config.getEntry(CybernodeImpl.getConfigComponent(), "initialServices", String[].class, (Object)initialServices);
            }
            catch (ConfigurationException e) {
                logger.log(Level.WARNING, "Getting initialServices", e);
            }
            if (initialServices.length == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Loading [" + initialServices.length + "] initialServices");
                }
            } else if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Loading [" + initialServices.length + "] initialServices");
            }
            for (int i = 0; i < initialServices.length; ++i) {
                URL deploymentURL = null;
                try {
                    deploymentURL = initialServices[i].startsWith("http:") ? new URL(initialServices[i]) : new File(initialServices[i]).toURI().toURL();
                    Map errorMap = this.load(deploymentURL);
                    GSCImpl.this.dumpOpStringError(errorMap);
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Loading initial services : " + initialServices[i], t);
                }
            }
        }

        Map load(URL deploymentURL) {
            if (deploymentURL == null) {
                throw new NullPointerException("Deployment URL cannot be null");
            }
            HashMap map = new HashMap();
            try {
                OpStringLoader opStringLoader = new OpStringLoader(this.getClass().getClassLoader());
                String group = SystemInfo.singleton().lookup().groups();
                if (group != null) {
                    opStringLoader.setDefaultGroups(BootUtil.toArray((String)group));
                }
                opStringLoader.setCodebaseOverride(GSCImpl.this.context.getExportCodebase());
                OperationalString[] opStrings = opStringLoader.parseOperationalString(deploymentURL);
                if (opStrings != null) {
                    for (int i = 0; i < opStrings.length; ++i) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Activating Deployment [" + opStrings[i].getName() + "]");
                        }
                        ServiceElement[] services = opStrings[i].getServices();
                        for (int j = 0; j < services.length; ++j) {
                            GSCImpl.this.activate(services[j]);
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Activating OperationalString", t);
            }
            return map;
        }
    }
}

