/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc;

import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.Schedule;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceProvisionEvent;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.core.provision.ServiceStatement;
import org.jini.rio.resources.servicecore.AbstractProxy;

public class GSCProxy
extends AbstractProxy
implements GSC,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;

    static GSCProxy getInstance(GSC gsc, Uuid id) {
        GSCProxy gscProxy = gsc instanceof RemoteMethodControl ? new ConstrainableGSCProxy(gsc, id, null) : new GSCProxy(gsc, id);
        GSCProxy.initProxy(gscProxy);
        return gscProxy;
    }

    private static void initProxy(GSCProxy gscProxy) {
        try {
            gscProxy.getName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected GSCProxy(GSC gsc, Uuid id) {
        super((Remote)((Object)gsc), id);
    }

    @Override
    public Schedule getSchedule() throws RemoteException {
        return ((GSC)((Object)this.server)).getSchedule();
    }

    @Override
    public void enlist(Schedule schedule) throws RemoteException {
        if (schedule == null) {
            throw new NullPointerException("schedule is null");
        }
        ((GSC)((Object)this.server)).enlist(schedule);
    }

    @Override
    public void release(boolean terminateServices) throws RemoteException {
        ((GSC)((Object)this.server)).release(terminateServices);
    }

    @Override
    public ServiceBeanInstance instantiate(ServiceProvisionEvent event) throws JSBInstantiationException, UnknownEventException, RemoteException {
        return ((GSC)((Object)this.server)).instantiate(event);
    }

    @Override
    public void destroy(ServiceProvisionEvent event) throws UnknownEventException, RemoteException {
        ((GSC)((Object)this.server)).destroy(event);
    }

    @Override
    public ServiceStatement[] getServiceStatements() throws RemoteException {
        return ((GSC)((Object)this.server)).getServiceStatements();
    }

    @Override
    public ServiceBeanInstance[] getServiceBeanInstances(ServiceElement element) throws RemoteException {
        return ((GSC)((Object)this.server)).getServiceBeanInstances(element);
    }

    @Override
    public ServiceRecord[] getServiceRecords(int filter) throws RemoteException {
        return ((GSC)((Object)this.server)).getServiceRecords(filter);
    }

    @Override
    public void update(ServiceElement[] sElements, OperationalStringManager opStringMgr) throws RemoteException {
        ((GSC)((Object)this.server)).update(sElements, opStringMgr);
    }

    @Override
    public String getName() throws RemoteException {
        if (this.name == null) {
            this.name = ((GSC)((Object)this.server)).getName();
        }
        return this.name;
    }

    @Override
    public Uuid getInstantiatorUuid() throws RemoteException {
        return this.getReferentUuid();
    }

    public int getAgentId() throws RemoteException {
        return ((GSC)((Object)this.server)).getAgentId();
    }

    public String getGSAServiceID() throws RemoteException {
        return ((GSC)((Object)this.server)).getGSAServiceID();
    }

    public boolean isServiceSecured() throws RemoteException {
        return ((GSC)((Object)this.server)).isServiceSecured();
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        return this.login((RemoteSecuredService)this.server, credentialsProvider);
    }

    static final class ConstrainableGSCProxy
    extends GSCProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;

        private ConstrainableGSCProxy(GSC gsc, Uuid id, MethodConstraints methodConstraints) {
            super(ConstrainableGSCProxy.constrainServer(gsc, methodConstraints), id);
        }

        private static GSC constrainServer(GSC gsc, MethodConstraints methodConstraints) {
            Method[] methods = GSC.class.getMethods();
            Method[] methodMapping = new Method[methods.length * 2];
            for (int i = 0; i < methodMapping.length; ++i) {
                methodMapping[i] = methods[i / 2];
            }
            return (GSC)((RemoteMethodControl)gsc).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)methodConstraints, (Method[])methodMapping));
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableGSCProxy((GSC)((Object)this.server), this.uuid, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.server).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableGSCProxy.readObject failure - server does not implement constrainable functionality");
            }
        }
    }
}

