/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class BeanPropertiesComponent
extends JPanel {
    private static final long serialVersionUID = -4562774425351467865L;
    private JTable _beanPropertiesTable;
    private BeanPropertiesTableModel beanPropertiesTableModel;

    public BeanPropertiesComponent() {
        this((Color)null);
    }

    public BeanPropertiesComponent(Color columnBackground) {
        this.setLayout(new BorderLayout());
        this.beanPropertiesTableModel = new BeanPropertiesTableModel();
        this._beanPropertiesTable = new JTable(this.beanPropertiesTableModel);
        this._beanPropertiesTable.setAutoResizeMode(3);
        JTableHeader header = this._beanPropertiesTable.getTableHeader();
        header.setReorderingAllowed(false);
        this._beanPropertiesTable.setAutoCreateColumnsFromModel(false);
        this._beanPropertiesTable.setAutoscrolls(true);
        this._beanPropertiesTable.setShowGrid(true);
        TableColumnModel cm = this._beanPropertiesTable.getColumnModel();
        if (columnBackground != null) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setBackground(new Color(230, 230, 230));
            renderer.setForeground(Color.BLACK);
            cm.getColumn(0).setCellRenderer(renderer);
        }
        this._beanPropertiesTable.getTableHeader().addMouseListener(new ColumnSortListener(this._beanPropertiesTable, this.beanPropertiesTableModel));
        JScrollPane scroller = new JScrollPane(this._beanPropertiesTable);
        this.add((Component)scroller, "Center");
    }

    public void setData(Map<String, Properties> beanLevelPropertiesMap) {
        this.beanPropertiesTableModel.setData(beanLevelPropertiesMap);
    }

    class BeanPropertiesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1600376949136925779L;
        final String[] columnNames = new String[]{"Scope", "Key", "Value"};
        private List<BeanPropertyWrapper> beanPropertyWrappersList = new ArrayList<BeanPropertyWrapper>();

        void setData(Map<String, Properties> beanLevelPropertiesMap) {
            this.clear();
            Set<Map.Entry<String, Properties>> entrySet = beanLevelPropertiesMap.entrySet();
            for (Map.Entry<String, Properties> mapEntry : entrySet) {
                String scope = mapEntry.getKey();
                Properties properties = mapEntry.getValue();
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = properties.getProperty(key);
                    if (key.indexOf("password") >= 0 || key.indexOf("username") >= 0) {
                        value = "****";
                    }
                    BeanPropertyWrapper beanPropertyWrapper = new BeanPropertyWrapper(scope, key, value);
                    this.beanPropertyWrappersList.add(beanPropertyWrapper);
                    this.fireTableRowsInserted(this.beanPropertyWrappersList.size() - 1, this.beanPropertyWrappersList.size() - 1);
                }
            }
        }

        public void clear() {
            int curRowCount = this.getRowCount();
            if (curRowCount > 0) {
                this.beanPropertyWrappersList.clear();
                this.fireTableRowsDeleted(0, curRowCount - 1);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int colIndex) {
            if (row >= 0 && row < this.beanPropertyWrappersList.size()) {
                BeanPropertyWrapper beanPropertyWrapper = this.beanPropertyWrappersList.get(row);
                return this.getCellValue(beanPropertyWrapper, colIndex);
            }
            return "";
        }

        public String getCellValue(BeanPropertyWrapper beanPropertyWrapper, int colIndex) {
            switch (colIndex) {
                case 0: {
                    return beanPropertyWrapper.getScope();
                }
                case 1: {
                    return beanPropertyWrapper.getKey();
                }
                case 2: {
                    return beanPropertyWrapper.getValue() == null ? "" : beanPropertyWrapper.getValue();
                }
            }
            return null;
        }

        public int getWrapperIndex(BeanPropertyWrapper beanPropertyWrapper) {
            return this.beanPropertyWrappersList.indexOf(beanPropertyWrapper);
        }

        public BeanPropertyWrapper getWrapperAt(int row) {
            if (row >= 0 && row < this.beanPropertyWrappersList.size()) {
                return this.beanPropertyWrappersList.get(row);
            }
            return null;
        }

        public List<BeanPropertyWrapper> getWrappersList() {
            return this.beanPropertyWrappersList;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.beanPropertyWrappersList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }
    }

    public static class BeanPropertyWrapper {
        private String _scope;
        private String _key;
        private String _value;

        public BeanPropertyWrapper(String scope, String key, String value) {
            this._scope = scope;
            this._key = key;
            this._value = value;
        }

        public String getScope() {
            return this._scope;
        }

        public String getKey() {
            return this._key;
        }

        public String getValue() {
            return this._value;
        }
    }

    private static class ColumnSortListener
    extends MouseAdapter {
        private boolean _ascending = false;
        private int _sortedColumnIndex = -1;
        private JTable _table;
        private BeanPropertiesTableModel _tableModel;
        private TableColumnModel _columnModel;

        public ColumnSortListener(JTable table, BeanPropertiesTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
            this._columnModel = this._table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(e.getX());
                this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
                this._tableModel.fireTableDataChanged();
                this._ascending = !this._ascending;
            }
        }

        private void sortAllRowsBy(int colIndex, boolean ascending) {
            int selRow = this._table.getSelectedRow();
            BeanPropertyWrapper selWrapper = null;
            if (selRow >= 0) {
                selWrapper = this._tableModel.getWrapperAt(selRow);
            }
            Collections.sort(this._tableModel.getWrappersList(), new ColumnSorter(colIndex, ascending));
            this.selectTableRow(selWrapper);
        }

        protected void sortAllRows() {
            if (this._sortedColumnIndex >= 0) {
                this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
            }
        }

        private void selectTableRow(BeanPropertyWrapper selWrapper) {
            int wrapperIndex;
            if (selWrapper != null && (wrapperIndex = this._tableModel.getWrapperIndex(selWrapper)) != -1) {
                this._table.setRowSelectionInterval(wrapperIndex, wrapperIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        _table.scrollRectToVisible(_table.getCellRect(wrapperIndex, -1, true));
                    }
                });
            }
        }

        private class ColumnSorter
        implements Comparator {
            private int colIndex;
            private boolean ascending;

            public ColumnSorter(int colIndex, boolean ascending) {
                this.colIndex = colIndex;
                this.ascending = ascending;
            }

            public int compare(Object obj1, Object obj2) {
                BeanPropertyWrapper beanPropertyWrapper1 = (BeanPropertyWrapper)obj1;
                BeanPropertyWrapper beanPropertyWrapper2 = (BeanPropertyWrapper)obj2;
                String str1 = ColumnSortListener.this._tableModel.getCellValue(beanPropertyWrapper1, this.colIndex);
                String str2 = ColumnSortListener.this._tableModel.getCellValue(beanPropertyWrapper2, this.colIndex);
                if (this.ascending) {
                    return str1.compareToIgnoreCase(str2);
                }
                return str2.compareToIgnoreCase(str1);
            }
        }
    }
}

