/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc.ui;

import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsc.ui.ServiceTable;
import com.gigaspaces.management.entry.JMXConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.entry.ComputeResourceUtilization;

public class GscUI
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -2341634719246042732L;
    private ServiceTable serviceTable;
    private ServiceItem item;
    private JTextField maxSvcCount;
    private JTextField currentSvcCount;
    private GSC gsc;
    private CybernodeAdmin cybernodeAdmin;
    private JButton apply;
    private Integer svcCount;
    private Integer maxCount;
    private List queue = Collections.synchronizedList(new LinkedList());
    private boolean keepAlive = true;
    private transient Thread thread;
    private String jmxServiceURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GscUI(Object arg) {
        this.getAccessibleContext().setAccessibleName("GSC Admin");
        this.item = (ServiceItem)arg;
        this.gsc = (GSC)this.item.getService();
        try {
            this.cybernodeAdmin = (CybernodeAdmin)this.gsc.getAdmin();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        JLabel label1 = new JLabel();
        for (int i = 0; i < this.item.attributeSets.length; ++i) {
            if (!(this.item.attributeSets[i] instanceof JMXConnection)) continue;
            this.jmxServiceURL = ((JMXConnection)this.item.attributeSets[i]).jmxServiceURL;
            break;
        }
        JPanel qPanel = new JPanel();
        qPanel.setLayout(new BoxLayout(qPanel, 0));
        qPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JMX Connectivity"), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        qPanel.add(label1);
        qPanel.add(Box.createHorizontalStrut(8));
        JButton launch = new JButton("Launch JConsole...");
        launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    Runtime.getRuntime().exec("jconsole " + GscUI.this.jmxServiceURL);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.jmxServiceURL != null) {
            label1.setText("<html>A JMX Connector has been identified</html>");
            launch.setToolTipText("Press to launch JConsole using the exported JMX Connector");
        } else {
            label1.setText("<html>A JMX Connector has not been identified</html>");
            launch.setEnabled(false);
            launch.setToolTipText("The GSC has not exported a JMX Connector");
        }
        qPanel.add(launch);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new GridLayout(0, 3, 4, 4));
        cPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Grid Service Container Attributes"), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.maxSvcCount = new JTextField();
        this.currentSvcCount = new JTextField();
        this.currentSvcCount.setEnabled(false);
        this.apply = new JButton("Apply");
        this.apply.addActionListener(new ApplyHandler(this));
        this.maxCount = new Integer(0);
        this.svcCount = new Integer(0);
        try {
            this.maxCount = this.cybernodeAdmin.getServiceLimit();
            this.maxSvcCount.setText(this.maxCount.toString());
            this.svcCount = this.cybernodeAdmin.getServiceCount();
            this.currentSvcCount.setText(this.svcCount.toString());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        cPanel.add(new JLabel("Contained Services"));
        cPanel.add(this.currentSvcCount);
        cPanel.add(new JLabel(""));
        cPanel.add(new JLabel("Service Limit"));
        cPanel.add(this.maxSvcCount);
        cPanel.add(this.apply);
        JPanel cq = new JPanel();
        cq.setLayout(new BorderLayout());
        cq.add("Center", cPanel);
        this.serviceTable = new ServiceTable();
        this.setLayout(new BorderLayout(8, 8));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add((Component)cq, "North");
        this.add((Component)this.serviceTable, "Center");
        this.add((Component)qPanel, "South");
        this.thread = new Thread(this);
        this.thread.start();
        List list = this.queue;
        synchronized (list) {
            this.queue.add(new Object());
            this.queue.notifyAll();
        }
    }

    @Override
    public void removeNotify() {
        this.terminate();
    }

    @Override
    public void run() {
        if (this.gsc == null) {
            this.showError("Reference to Grid Service Container is null");
            return;
        }
        while (!this.thread.isInterrupted() && this.keepAlive) {
            try {
                this.serviceTable.clear();
                ServiceRecord[] records = this.gsc.getServiceRecords(1);
                for (int i = 0; i < records.length; ++i) {
                    this.serviceTable.addService(records[i]);
                }
                this.currentSvcCount.setText(this.getCybernodeCount().toString());
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.keepAlive) continue;
                }
            }
            catch (Exception e) {
                if (!this.keepAlive) break;
                e.printStackTrace();
                this.showError(e.toString());
                if (this.apply == null) break;
                this.apply.setEnabled(false);
            }
            break;
        }
    }

    public void terminate() {
        this.keepAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.apply != null) {
            this.apply.setEnabled(false);
        }
    }

    protected void showInformation(String text) {
        JOptionPane.showMessageDialog(this, text, "Information Message", 1);
    }

    protected void showError(String text) {
        JOptionPane.showMessageDialog(this, text, "System Error", 0);
    }

    JTextField createAttrTextField() {
        JTextField tf = new JTextField();
        tf.setEnabled(false);
        return tf;
    }

    Integer getCybernodeCount() {
        try {
            this.svcCount = this.cybernodeAdmin.getServiceCount();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return this.svcCount;
    }

    ComputeResourceUtilization getComputeResourceUtilization(Entry[] attrs) {
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof ComputeResourceUtilization)) continue;
            return (ComputeResourceUtilization)attrs[x];
        }
        return null;
    }

    class ApplyHandler
    implements ActionListener {
        Component comp;

        ApplyHandler(Component comp) {
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String title;
                Integer newCount = null;
                Integer count = GscUI.this.cybernodeAdmin.getServiceLimit();
                String s = GscUI.this.maxSvcCount.getText();
                try {
                    newCount = new Integer(s);
                }
                catch (Throwable t) {
                    GscUI.this.showError("You must enter a valid number");
                    return;
                }
                if (count.equals(newCount)) {
                    return;
                }
                String message = "Set service limit to [" + s + "] ?";
                int answer = JOptionPane.showConfirmDialog(this.comp, message, title = "GSC Configuration Change Confirmation", 0);
                if (answer == 1) {
                    return;
                }
                GscUI.this.cybernodeAdmin.setServiceLimit(newCount);
                GscUI.this.maxCount = GscUI.this.cybernodeAdmin.getServiceLimit();
            }
            catch (RemoteException re) {
                re.printStackTrace();
                GscUI.this.showError(re.getMessage());
            }
        }
    }
}

