/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc.ui;

import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsc.ui.PropertiesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.qos.capability.PlatformCapability;

public class PlatformCapabilityUI
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 1791344140988516356L;
    private final GSC gsc;
    private CybernodeAdmin cybernodeAdmin;
    private final JTable capabilityTable;
    private final PlatformCapabilityModel dataModel;
    private final JCheckBox supportsProvisioning;

    public PlatformCapabilityUI(Object arg) {
        this.getAccessibleContext().setAccessibleName("Platform Capabilities");
        ServiceItem item = (ServiceItem)arg;
        this.gsc = (GSC)item.getService();
        try {
            this.cybernodeAdmin = (CybernodeAdmin)this.gsc.getAdmin();
        }
        catch (Exception e) {
            this.showError(e);
        }
        this.setLayout(new BorderLayout(2, 4));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel provPanel = new JPanel();
        provPanel.setLayout(new BorderLayout(8, 8));
        provPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Persistent Provisioning"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JLabel label = new JLabel("<html>Set whether the Grid Service Container supports persistent provisioning of qualitative capabilities</html>");
        provPanel.add((Component)label, "North");
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        this.supportsProvisioning = new JCheckBox("Supports persistent provisioning");
        label.setLabelFor(this.supportsProvisioning);
        subPanel.add(this.supportsProvisioning);
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    PlatformCapabilityUI.this.cybernodeAdmin.setPersistentProvisioning(PlatformCapabilityUI.this.supportsProvisioning.isSelected());
                }
                catch (Exception e) {
                    PlatformCapabilityUI.this.showError(e);
                }
            }
        });
        subPanel.add(Box.createHorizontalGlue());
        subPanel.add(apply);
        provPanel.add((Component)subPanel, "Center");
        this.add((Component)provPanel, "North");
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout(8, 8));
        tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Current Platform Capabilities"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.capabilityTable = new JTable();
        this.capabilityTable.addMouseListener(new RowListener());
        this.dataModel = new PlatformCapabilityModel();
        this.capabilityTable.setModel(this.dataModel);
        TableColumnModel cm = this.capabilityTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(30);
        this.capabilityTable.setAutoResizeMode(3);
        JScrollPane scroller = new JScrollPane(this.capabilityTable);
        tablePanel.add((Component)scroller, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton details = new JButton("Details");
        details.setToolTipText("Get details on the selected PlatformCapability");
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = PlatformCapabilityUI.this.capabilityTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                PlatformCapabilityUI.this.showDetails(PlatformCapabilityUI.this.getPlatformCapability(row));
            }
        });
        buttons.add(details);
        tablePanel.add((Component)buttons, "South");
        this.add((Component)tablePanel, "Center");
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        try {
            this.supportsProvisioning.setSelected(this.cybernodeAdmin.getPersistentProvisioning());
            PlatformCapability[] pCaps = this.cybernodeAdmin.getPlatformCapabilties();
            for (int i = 0; i < pCaps.length; ++i) {
                this.addPlatformCapability(pCaps[i]);
            }
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    void addPlatformCapability(PlatformCapability pCap) {
        this.dataModel.addItem(pCap);
        this.dataModel.fireTableDataChanged();
    }

    void removePlatformCapability(int row) {
        this.dataModel.removeItem(row);
    }

    void clearPlatformCapabilities() {
        this.dataModel.clear();
    }

    PlatformCapability getPlatformCapability(int row) {
        if (row == -1) {
            return null;
        }
        return (PlatformCapability)this.dataModel.getItem(row);
    }

    void showError(Exception e) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            buffer.append("at " + trace[i] + "<br>");
        }
        this.showError("<html>Exception : <font color=red>" + e.getClass().getName() + "</font><br>" + buffer.toString() + "</html>");
    }

    void showError(String text) {
        JOptionPane.showMessageDialog(this, text, "System Error", 0);
    }

    void showDetails(PlatformCapability pCap) {
        PlatformCapabilityDetails details = new PlatformCapabilityDetails(null, pCap);
        if (details.changed) {
            Thread thread = new Thread(this);
            this.clearPlatformCapabilities();
            thread.start();
        }
    }

    private static class PlatformCapabilityDetails
    extends JDialog {
        private static final long serialVersionUID = 1759871060309717121L;
        final PlatformCapability pCap;
        JPanel base;
        JDialog instance;
        PropertiesTable propsTable;
        boolean changed = false;

        PlatformCapabilityDetails(JFrame frameOwner, PlatformCapability pCap) {
            super(frameOwner, "Platform Capability Details", true);
            this.pCap = pCap;
            this.instance = this;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout(2, 4));
            this.base.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            JPanel basics = new JPanel();
            basics.setLayout(new GridLayout(3, 2, 4, 4));
            basics.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General Information"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            basics.add(new JLabel("Description"));
            basics.add(this.createTextField(pCap.getDescription()));
            basics.add(new JLabel("Class"));
            basics.add(this.createTextField(pCap.getClass().getName()));
            basics.add(new JLabel("Type"));
            basics.add(this.createTextField(pCap.getType() == 1 ? "STATIC" : "PROVISIONABLE"));
            this.base.add((Component)basics, "North");
            JPanel capabilityPanel = new JPanel();
            capabilityPanel.setLayout(new BorderLayout(4, 4));
            capabilityPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Capability Support Mappings"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            Properties props = new Properties();
            Object[] keys = pCap.getPlatformKeys();
            for (int i = 0; i < keys.length; ++i) {
                props.put(keys[i], pCap.getValue(keys[i]));
            }
            if (pCap.getPath() != null) {
                props.put("Path", pCap.getPath());
            }
            String storageClass = "org.jini.rio.qos.capability.system.StorageCapability";
            if (pCap.getClass().getName().equals(storageClass)) {
                Double dVal = (Double)props.get("Available");
                if (dVal != null) {
                    props.put("Available", this.formatStorageCapabilityValue(dVal));
                }
                if ((dVal = (Double)props.get("Capacity")) != null) {
                    props.put("Capacity", this.formatStorageCapabilityValue(dVal));
                }
            }
            this.propsTable = new PropertiesTable(props);
            capabilityPanel.add((Component)this.propsTable, "Center");
            this.base.add((Component)capabilityPanel, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            JButton close = new JButton("Close");
            close.setToolTipText("Close the dialog");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.dispose();
                }
            });
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(close);
            buttonPanel.add(Box.createHorizontalGlue());
            this.base.add((Component)buttonPanel, "South");
            this.getContentPane().add(this.base);
            this.pack();
            this.showDialog();
        }

        JTextField createTextField(String text) {
            JTextField tf = new JTextField(text);
            tf.setEditable(false);
            return tf;
        }

        String formatStorageCapabilityValue(Double dVal) {
            String result = dVal.toString();
            try {
                double value = dVal / 1024.0;
                result = (int)value + " kbytes";
            }
            catch (Exception e) {
                System.err.println("Bad StorageCapability value [" + dVal + "]");
            }
            return result;
        }

        private void showDialog() {
            int width = 400;
            int height = 370;
            this.pack();
            this.setSize(width, height);
            this.getContentPane().add(this.base);
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.dispose();
                }
            };
            this.addWindowListener(l);
            this.setVisible(true);
        }
    }

    class RowListener
    extends MouseAdapter {
        RowListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clickCount = e.getClickCount();
            if (clickCount == 2) {
                int row = PlatformCapabilityUI.this.capabilityTable.rowAtPoint(new Point(e.getX(), e.getY()));
                if (row == -1) {
                    return;
                }
                PlatformCapabilityUI.this.showDetails(PlatformCapabilityUI.this.getPlatformCapability(row));
            }
        }
    }

    private static class PlatformCapabilityModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2894212283721994545L;
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Name", "Description", "Class", "Package"};

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                PlatformCapability pCap = (PlatformCapability)this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return pCap.getValue("Name");
                    }
                    case 1: {
                        return pCap.getDescription();
                    }
                    case 2: {
                        String name = pCap.getClass().getName();
                        int ndx = name.lastIndexOf(".");
                        if (ndx != -1) {
                            name = name.substring(ndx + 1, name.length());
                        }
                        return name;
                    }
                    case 3: {
                        String pkgName = pCap.getClass().getName();
                        int x = pkgName.lastIndexOf(".");
                        if (x != -1) {
                            pkgName = pkgName.substring(0, x);
                        }
                        return pkgName;
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void clear() {
            this.tableData.clear();
            this.fireTableDataChanged();
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.removeElementAt(row);
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }
}

