/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class PropertiesTable
extends JPanel {
    private static final long serialVersionUID = 2337962038023658652L;
    JTable propertiesTable;
    PropertiesTableModel propertiesTableModel;
    boolean editable = false;
    private ColumnSortListener _columnSortListener;
    private static final String COMPLETE_TABLE_DATA_MESSAGE = "Please complete filling all data in the table.";
    private Component _parentComponent;

    public PropertiesTable(boolean editable, Color columnBackground) {
        this(null, editable, columnBackground, null);
    }

    public PropertiesTable(boolean editable, Color columnBackground, String[] columnNames) {
        this(null, editable, columnBackground, columnNames);
    }

    public PropertiesTable(Properties props) {
        this(props, false, null, null);
    }

    public PropertiesTable(Properties props, boolean editable, Color columnBackground, String[] columnNames) {
        this.editable = editable;
        this.setLayout(new BorderLayout());
        this.propertiesTable = new JTable();
        this.propertiesTableModel = new PropertiesTableModel(columnNames);
        this.propertiesTable.setModel(this.propertiesTableModel);
        this.propertiesTable.setAutoResizeMode(3);
        this._columnSortListener = new ColumnSortListener(this.propertiesTable, this.propertiesTableModel);
        JTableHeader header = this.propertiesTable.getTableHeader();
        header.addMouseListener(this._columnSortListener);
        header.setReorderingAllowed(false);
        this.propertiesTable.setAutoCreateColumnsFromModel(false);
        this.propertiesTable.setAutoscrolls(true);
        this.propertiesTable.setShowGrid(true);
        TableColumnModel cm = this.propertiesTable.getColumnModel();
        if (columnBackground != null) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setBackground(new Color(230, 230, 230));
            renderer.setForeground(Color.BLACK);
            cm.getColumn(0).setCellRenderer(renderer);
        }
        if (props != null) {
            this.setProperties(props);
            String longString = "";
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String value = (String)en.nextElement();
                longString = longString.length() > value.length() ? longString : value;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.stringWidth(longString) == 0 ? 125 : fontMetrics.stringWidth(longString) + 4;
            cm.getColumn(0).setPreferredWidth(width);
        } else {
            cm.getColumn(0).setPreferredWidth(155);
        }
        JScrollPane scroller = new JScrollPane(this.propertiesTable);
        this.add((Component)scroller, "Center");
    }

    public void setProperties(Properties props) {
        if (props == null) {
            throw new NullPointerException("props is null");
        }
        this.propertiesTableModel.setData(props);
    }

    public void setMap(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.propertiesTableModel.setData(map);
    }

    public void stopCellEditing() {
        TableCellEditor tableCellEditor = this.propertiesTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    public void addMapping(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.isNewRowCanBeAdded()) {
            this.propertiesTableModel.addKeyValue(key, value);
        }
    }

    private boolean isNewRowCanBeAdded() {
        int rowCount = this.propertiesTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String val = this.propertiesTable.getValueAt(i, 0).toString();
            if (val.trim().length() != 0) continue;
            if (this._parentComponent == null) {
                this.initParentComponent();
            }
            JOptionPane.showMessageDialog(this._parentComponent, COMPLETE_TABLE_DATA_MESSAGE, "Missing data", 1);
            return false;
        }
        return true;
    }

    private void initParentComponent() {
        this._parentComponent = SwingUtilities.getRoot(this);
    }

    public String getKey(int row) {
        return (String)this.propertiesTableModel.getValueAt(row, 0);
    }

    public String getValue(int row) {
        if (row == -1) {
            return null;
        }
        return (String)this.propertiesTableModel.getValueAt(row, 1);
    }

    public void setKey(String key, int row) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.propertiesTableModel.setValueAt(key, row, 0);
    }

    public void setValue(String value, int row) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.propertiesTableModel.setValueAt(value, row, 1);
    }

    public Properties getProperties() {
        this.stopCellEditing();
        return this.propertiesTableModel.getProperties();
    }

    public void clearTable() {
        this.propertiesTableModel.removeAll();
    }

    public boolean removeSelectedRow() {
        int[] rows = this.propertiesTable.getSelectedRows();
        if (rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        int minSelRow = rows[0];
        for (int i = rows.length - 1; i >= 0; --i) {
            this.propertiesTableModel.removeItem(rows[i]);
        }
        int nextSelectedRow = minSelRow;
        int rowsCount = this.propertiesTable.getRowCount();
        if (nextSelectedRow < rowsCount) {
            this.propertiesTable.setRowSelectionInterval(nextSelectedRow, nextSelectedRow);
        } else if (rowsCount > 0) {
            this.propertiesTable.setRowSelectionInterval(rowsCount - 1, rowsCount - 1);
        }
        return true;
    }

    public int getSelectedRow() {
        return this.propertiesTable.getSelectedRow();
    }

    private static class ColumnSortListener
    extends MouseAdapter {
        private boolean _ascending = false;
        private int _sortedColumnIndex = -1;
        private JTable _table;
        private PropertiesTableModel _propertiesTableModel;
        private TableColumnModel _columnModel;

        public ColumnSortListener(JTable table, PropertiesTableModel tableModel) {
            this._table = table;
            this._propertiesTableModel = tableModel;
            this._columnModel = this._table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(e.getX());
                this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
                this._propertiesTableModel.fireTableDataChanged();
                this._ascending = !this._ascending;
            }
        }

        private void sortAllRowsBy(int colIndex, boolean ascending) {
            int selRow = this._table.getSelectedRow();
            PropertyEntry selPropertyEntry = null;
            if (selRow >= 0) {
                selPropertyEntry = this._propertiesTableModel.getPropertyEntryAt(selRow);
            }
            Collections.sort(this._propertiesTableModel.getPropertiesEntriesList(), new ColumnSorter(colIndex, ascending));
            this.selectTableRow(selPropertyEntry);
            this._propertiesTableModel.fireTableDataChanged();
        }

        protected void sortAllRows() {
            if (this._sortedColumnIndex >= 0) {
                this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
            }
        }

        private void selectTableRow(PropertyEntry selPropertyEntry) {
            int wrapperIndex;
            if (selPropertyEntry != null && (wrapperIndex = this._propertiesTableModel.getPropertyEntryIndex(selPropertyEntry)) != -1) {
                this._table.setRowSelectionInterval(wrapperIndex, wrapperIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        _table.scrollRectToVisible(_table.getCellRect(wrapperIndex, -1, true));
                    }
                });
            }
        }

        private class ColumnSorter
        implements Comparator {
            private int colIndex;
            private boolean ascending;

            public ColumnSorter(int colIndex, boolean ascending) {
                this.colIndex = colIndex;
                this.ascending = ascending;
            }

            public int compare(Object a, Object b) {
                PropertyEntry propertyEntry1 = (PropertyEntry)a;
                PropertyEntry propertyEntry2 = (PropertyEntry)b;
                if (this.colIndex == 0) {
                    String key1 = propertyEntry1.getKey();
                    String key2 = propertyEntry2.getKey();
                    if (this.ascending) {
                        return key1.compareToIgnoreCase(key2);
                    }
                    return key2.compareToIgnoreCase(key1);
                }
                if (this.colIndex == 1) {
                    String value1 = propertyEntry1.getValue();
                    String value2 = propertyEntry2.getValue();
                    if (this.ascending) {
                        return value1.compareToIgnoreCase(value2);
                    }
                    return value2.compareToIgnoreCase(value1);
                }
                return 0;
            }
        }
    }

    class PropertiesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -3888450561468182813L;
        private List<PropertyEntry> elements = new ArrayList<PropertyEntry>();
        private String[] columnNames;
        private final String[] DEFAULT_COLUMN_NAMES = new String[]{"Key", "Value"};

        public PropertiesTableModel() {
            this(null);
        }

        public PropertiesTableModel(String[] columnNames) {
            this.columnNames = columnNames == null ? this.DEFAULT_COLUMN_NAMES : columnNames;
        }

        void setData(Properties props) {
            this.elements.clear();
            Set<Map.Entry<Object, Object>> set = props.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                this.elements.add(new PropertyEntry((String)entry.getKey(), (String)entry.getValue()));
            }
            this.fireTableDataChanged();
        }

        void setData(Map<String, String> map) {
            this.elements.clear();
            Set<Map.Entry<String, String>> entrySet = map.entrySet();
            for (Map.Entry<String, String> mapEntry : entrySet) {
                this.elements.add(new PropertyEntry(mapEntry.getKey(), mapEntry.getValue()));
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return PropertiesTable.this.editable;
        }

        void addKeyValue(String key, String value) {
            this.elements.add(new PropertyEntry(key, value));
            this.fireTableRowsInserted(this.elements.size() - 1, this.elements.size() - 1);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < this.elements.size()) {
                PropertyEntry propertyEntry = this.elements.get(row);
                if (column == 0) {
                    propertyEntry.setKey((String)value);
                } else {
                    propertyEntry.setValue((String)value);
                }
                this.fireTableRowsUpdated(row, row);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                switch (column) {
                    case 0: {
                        return this.elements.get(row).getKey();
                    }
                    case 1: {
                        return this.elements.get(row).getValue();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.elements == null) {
                return 0;
            }
            return this.elements.size();
        }

        public void removeAll() {
            this.elements.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void removeItem(int row) {
            this.elements.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public Properties getProperties() {
            Properties props = new Properties();
            for (PropertyEntry propertyEntry : this.elements) {
                props.put(propertyEntry.getKey(), propertyEntry.getValue());
            }
            return props;
        }

        public List<PropertyEntry> getPropertiesEntriesList() {
            return this.elements;
        }

        public int getPropertyEntryIndex(PropertyEntry propertyEntry) {
            return this.elements.indexOf(propertyEntry);
        }

        public PropertyEntry getPropertyEntryAt(int index) {
            return this.elements.get(index);
        }
    }

    private static class PropertyEntry {
        private String _key;
        private String _value;

        public PropertyEntry(String key, String value) {
            this._key = key;
            this._value = value;
        }

        private String getKey() {
            return this._key;
        }

        public String getValue() {
            return this._value;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public void setValue(String value) {
            this._value = value;
        }
    }
}

