/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsc.ui;

import java.awt.BorderLayout;
import java.net.InetAddress;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.resources.util.TimeUtil;

public class ServiceTable
extends JPanel {
    private static final long serialVersionUID = -4590602925912260672L;
    InetAddress address;
    JTable serviceTable;
    ServiceTableModel dataModel;

    public ServiceTable() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Active Services"), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.serviceTable = new JTable();
        this.dataModel = new ServiceTableModel();
        this.serviceTable.setModel(this.dataModel);
        this.serviceTable.setAutoResizeMode(3);
        TableColumnModel cm = this.serviceTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(0).setMaxWidth(500);
        cm.getColumn(1).setPreferredWidth(200);
        cm.getColumn(1).setMaxWidth(350);
        this.add("Center", new JScrollPane(this.serviceTable));
    }

    public int getServiceCount() {
        return this.dataModel.tableData.size();
    }

    public void addService(ServiceRecord record) {
        this.dataModel.addItem(record);
    }

    public void clear() {
        this.dataModel.clear();
    }

    public int getSelectedRow() {
        int elements = this.dataModel.tableData.size();
        if (elements == 0) {
            return -1;
        }
        return this.serviceTable.getSelectedRow();
    }

    static class ServiceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2624988758276459737L;
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Name", "Implementation Class", "Time Active"};

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                ServiceRecord record = (ServiceRecord)this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return record.getName();
                    }
                    case 1: {
                        String impl = "";
                        if (record.getServiceElement().getComponentBundle() != null) {
                            impl = record.getServiceElement().getComponentBundle().getClassName();
                        }
                        return impl;
                    }
                    case 2: {
                        return TimeUtil.format(record.computeElapsedTime());
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.removeElementAt(row);
            this.fireTableDataChanged();
        }

        public void clear() {
            this.tableData.clear();
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }
}

