/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsm;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.admin.quiesce.QuiesceFailedException;
import com.gigaspaces.grid.gsa.AgentHelper;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.gsm.GSMLookupLocatorsChangeListener;
import com.gigaspaces.grid.gsm.GSMProxy;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import com.gigaspaces.grid.security.gsm.SecuredGSMExtension;
import com.gigaspaces.grid.security.gsm.SecuredGSMProxy;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpHelper;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.internal.dump.gsm.GsmDumpProcessor;
import com.gigaspaces.internal.io.FileUtils;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.quiesce.InternalQuiesceRequest;
import com.gigaspaces.internal.quiesce.QuiesceTask;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.gigaspaces.security.service.SecurityResolver;
import com.gigaspaces.start.SystemInfo;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import net.jini.discovery.dynamic.LookupLocatorsChangeListener;
import net.jini.id.UuidFactory;
import net.jini.lookup.entry.ServiceInfo;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.RequiredDependencies;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceElementTracker;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.monitor.ProvisionMonitorImpl;
import org.jini.rio.monitor.ServiceElementManager;
import org.jini.rio.monitor.event.Events;
import org.jini.rio.opstring.OpStringLoader;
import org.jini.rio.resources.resource.PoolableThread;

public class GSMImpl
extends ProvisionMonitorImpl
implements GSM,
RemoteSecuredService {
    static final String ROOT_COMPONENT = "com.gigaspaces";
    static final String GRID_COMPONENT = "com.gigaspaces.grid";
    static final String SYSTEM_COMPONENT_NAME = "com.gigaspaces.system";
    static final String CONFIG_COMPONENT = "com.gigaspaces.grid.gsm";
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm");
    private static final boolean QUIESCE_DISABLED = Boolean.getBoolean("com.gs.engine.disableQuiesceMode");
    private SecurityInterceptor securityInterceptor;
    private MetricManager metricManager;

    public GSMImpl() throws Exception {
        this.initialize();
    }

    public GSMImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        super(configArgs, lifeCycle);
        this.initialize();
    }

    public GSMImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        super(activationID, data);
        this.initialize();
    }

    private void initialize() {
        this.metricManager = MetricManager.acquire();
    }

    @Override
    protected Object createProxy() {
        if (this.securityInterceptor != null) {
            return SecuredGSMProxy.getInstance((GSM)this.getExportedProxy(), this.getUuid());
        }
        return GSMProxy.getInstance((GSM)this.getExportedProxy(), this.getUuid());
    }

    @Override
    public void advertise() throws IOException {
        super.advertise();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("GSM started successfully [groups=" + Arrays.toString(this.admin.getLookupGroups()) + ", locators=" + Arrays.toString(this.admin.getLookupLocators()) + ", service-id=" + this.getServiceID() + "]");
        }
    }

    @Override
    public void destroy(boolean force) {
        logger.info("Stopping GSM");
        if (this.metricManager != null) {
            this.metricManager.close();
        }
        super.destroy(force);
        logger.info("GSM stopped.");
    }

    @Override
    public void initialize(ServiceBeanContext context) throws Exception {
        if (SecurityResolver.isSecurityEnabled()) {
            this.securityInterceptor = new SecurityInterceptor("grid");
        }
        super.initialize(context);
        RuntimeInfo.logRuntimeInfo((Logger)logger, (String)"Starting GSM...");
        LicenseManager.getInstance().validate("Service Grid", LicenseType.PREMIUM);
        JMXConnection jmxEntry = JMXUtilities.createJMXConnectionAttribute((String)context.getServiceElement().getName());
        if (jmxEntry != null) {
            this.addAttribute((Entry)jmxEntry);
        }
        if (DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
            GSMLookupLocatorsChangeListener discoveryListener = new GSMLookupLocatorsChangeListener(this);
            LookupDiscoveryManager ldm = (LookupDiscoveryManager)this.getServiceBeanContext().getDiscoveryManagement();
            ldm.getDynamicLocatorDiscovery().addLookupLocatorsChangeListener((LookupLocatorsChangeListener)discoveryListener);
        }
    }

    @Override
    protected void initializeJMX(Object mbean) throws Exception {
        if (this.isServiceSecured()) {
            mbean = new SecuredGSMExtension(mbean);
        }
        super.initializeJMX(mbean);
    }

    @Override
    public Set<String> getExportCodebasesSet() throws RemoteException {
        URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
        URL[] urls = cl.getURLs();
        HashSet<String> codebaseSet = new HashSet<String>(urls.length);
        for (URL url : urls) {
            String exportCodebase = this.retrieveCodebase(url);
            codebaseSet.add(exportCodebase);
        }
        return codebaseSet;
    }

    private String retrieveCodebase(URL url) {
        String exportCodebase;
        block4: {
            exportCodebase = null;
            try {
                exportCodebase = url.toURI().toString();
            }
            catch (URISyntaxException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, e.toString(), e);
            }
        }
        if (exportCodebase == null) {
            return "";
        }
        if (exportCodebase.startsWith("httpmd")) {
            exportCodebase = "http" + exportCodebase.substring(6);
        }
        return exportCodebase;
    }

    @Override
    protected OpStringLoader getOpStringLoader() throws Exception {
        OpStringLoader ops = new OpStringLoader(this.getClass().getClassLoader());
        String group = SystemInfo.singleton().lookup().groups();
        if (group != null) {
            ops.setDefaultGroups(BootUtil.toArray((String)group));
        }
        ops.setDefaultExportJars(new String[]{"gs-dl.jar"});
        return ops;
    }

    @Override
    protected ServiceInfo getServiceInfo() {
        return new ServiceInfo(this.context.getServiceElement().getName(), "GigaSpaces Technologies, Inc.", "", PlatformVersion.getOfficialVersion(), "", "");
    }

    @Override
    public String getDeployPath() throws RemoteException {
        return System.getProperty("com.gs.deploy");
    }

    @Override
    public boolean hasPUUnderDeploy(String puName) throws RemoteException {
        String path = System.getProperty("com.gs.deploy") + "/" + puName.replace('\\', '/');
        return new File(path).exists();
    }

    @Override
    public PUsDetails getPUsDetails() throws RemoteException {
        OperationalStringManager[] operationalStringManagers = this.getOperationalStringManagers();
        PUDetails[] puDetails = new PUDetails[operationalStringManagers.length];
        for (int i = 0; i < puDetails.length; ++i) {
            OperationalStringManager osm = operationalStringManagers[i];
            OperationalString operationalString = osm.getOperationalString();
            ServiceElement[] serviceElements = operationalString.getServices();
            int numberOfInstances = (Integer)serviceElements[0].getServiceBeanConfig().getInitParameters().get("numberOfInstances");
            int numberOfBackups = (Integer)serviceElements[0].getServiceBeanConfig().getInitParameters().get("numberOfBackups");
            if (numberOfBackups == 0) {
                numberOfInstances = 0;
                for (ServiceElement serviceElement : serviceElements) {
                    numberOfInstances += serviceElement.getPlanned() + serviceElement.getRelocateInstanceCount();
                }
            }
            MarshalledObject beanLevelProperties = (MarshalledObject)serviceElements[0].getServiceBeanConfig().getInitParameters().get("beanLevelProperties");
            MarshalledObject sla = (MarshalledObject)serviceElements[0].getServiceBeanConfig().getInitParameters().get("sla");
            Map<String, String> elasticProperties = serviceElements[0].getElasticProperties();
            String processingUnitType = String.valueOf(serviceElements[0].getServiceBeanConfig().getInitParameters().get("pu.type"));
            String processingUnitArchiveName = String.valueOf(serviceElements[0].getServiceBeanConfig().getInitParameters().get("fullArchiveName"));
            int actualNumberOfInstances = 0;
            ProvisionMonitorImpl.OpStringManager serviceElementManagerFinder = this.getOpStringManager(operationalString.getName());
            if (serviceElementManagerFinder != null) {
                for (ServiceElement serviceElement : serviceElements) {
                    ServiceElementManager serviceElementManager = serviceElementManagerFinder.getServiceElementManager(serviceElement);
                    if (serviceElementManager == null) continue;
                    actualNumberOfInstances += serviceElementManager.getActual();
                }
            }
            RequiredDependencies instanceDeploymentDependencies = serviceElements[0].getInstanceDeploymentDependencies();
            RequiredDependencies instanceStartDependencies = serviceElements[0].getInstanceStartDependencies();
            String applicationName = serviceElements[0].getApplicationName();
            puDetails[i] = new PUDetails(operationalString.getName(), this.getPuStatus(osm), osm.isManaging(), numberOfInstances, numberOfBackups, processingUnitType, beanLevelProperties, sla, elasticProperties, actualNumberOfInstances, instanceDeploymentDependencies, instanceStartDependencies, applicationName, processingUnitArchiveName);
        }
        return new PUsDetails(puDetails);
    }

    private int getPuStatus(OperationalStringManager osm) throws RemoteException {
        int status = osm.getOperationalString().getStatus();
        if (status == 3 || status == 4) {
            int pendingCount = 0;
            for (ServiceElement serviceElement : osm.getOperationalString().getServices()) {
                ServiceElementTracker serviceElementTracker = osm.getServiceElementTracker(serviceElement);
                if (serviceElementTracker.getInProcessCount() > 0) {
                    return 1;
                }
                pendingCount += serviceElementTracker.getPendingCount();
            }
            if (pendingCount == 0) {
                return 1;
            }
        }
        return status;
    }

    @Override
    public boolean isOrphanInstancesBeingProvisioned(String name) {
        return super.getOpStringManager(name) == null && super.isInstancesBeingProvisioned(name);
    }

    @Override
    public void relocate(String opStringName, ServiceID serviceToRelocate, ServiceID gscToRelocateTo, ServiceProvisionListener listener) throws RemoteException, OperationalStringException {
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(opStringName);
        ServiceBeanInstance serviceBeanInstance = null;
        for (ServiceElement se : operationalStringManager.getOperationalString().getServices()) {
            ServiceBeanInstance[] instances;
            for (ServiceBeanInstance sbInstance : instances = operationalStringManager.getServiceBeanInstances(se)) {
                if (sbInstance.getServiceBeanID().getLeastSignificantBits() != serviceToRelocate.getLeastSignificantBits() || sbInstance.getServiceBeanID().getMostSignificantBits() != serviceToRelocate.getMostSignificantBits()) continue;
                serviceBeanInstance = sbInstance;
                break;
            }
            if (serviceBeanInstance != null) break;
        }
        if (serviceBeanInstance == null) {
            throw new OperationalStringException("Failed to find service bean instance");
        }
        operationalStringManager.relocate(serviceBeanInstance, listener, gscToRelocateTo == null ? null : UuidFactory.create((long)gscToRelocateTo.getMostSignificantBits(), (long)gscToRelocateTo.getLeastSignificantBits()));
    }

    @Override
    public void increment(String opStringName, ServiceProvisionListener listener) throws RemoteException, OperationalStringException {
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(opStringName);
        ServiceElement element = operationalStringManager.getOperationalString().getServices()[0];
        operationalStringManager.increment(element, true, listener, false);
    }

    @Override
    public void decrement(String opStringName, ServiceID serviceToDecrement, boolean mandate) throws RemoteException, OperationalStringException {
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(opStringName);
        ServiceBeanInstance serviceBeanInstance = null;
        ServiceElement element = null;
        ServiceElement[] serviceElementArray = operationalStringManager.getOperationalString().getServices();
        int n = serviceElementArray.length;
        for (int i = 0; i < n; ++i) {
            ServiceBeanInstance[] instances;
            ServiceElement se;
            element = se = serviceElementArray[i];
            for (ServiceBeanInstance sbInstance : instances = operationalStringManager.getServiceBeanInstances(se)) {
                if (sbInstance.getServiceBeanID().getLeastSignificantBits() != serviceToDecrement.getLeastSignificantBits() || sbInstance.getServiceBeanID().getMostSignificantBits() != serviceToDecrement.getMostSignificantBits()) continue;
                serviceBeanInstance = sbInstance;
                break;
            }
            if (serviceBeanInstance != null) break;
        }
        if (serviceBeanInstance == null) {
            throw new OperationalStringException("Failed to find service bean instance");
        }
        if (element.getPlanned() == 0) {
            return;
        }
        operationalStringManager.decrement(serviceBeanInstance, mandate, true, false);
    }

    @Override
    public boolean decrementPlannedIfPending(String opStringName) throws RemoteException, OperationalStringException {
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(opStringName);
        ServiceElement sElem = operationalStringManager.getOperationalString().getServices()[0];
        return operationalStringManager.decrementPlannedIfPending(sElem);
    }

    @Override
    public void updateElasticProperties(String opStringName, Map<String, String> properties) throws RemoteException, OperationalStringException {
        ServiceElement[] services;
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(opStringName);
        for (ServiceElement serviceElement : services = operationalStringManager.getOperationalString().getServices()) {
            serviceElement.setElasticProperties(properties);
            operationalStringManager.updateServiceElement(serviceElement);
        }
    }

    @Override
    public void destroy(String opStringName, ServiceID serviceToDestroy) throws RemoteException, OperationalStringException {
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(opStringName);
        ServiceBeanInstance serviceBeanInstance = null;
        for (ServiceElement se : operationalStringManager.getOperationalString().getServices()) {
            ServiceBeanInstance[] instances;
            for (ServiceBeanInstance sbInstance : instances = operationalStringManager.getServiceBeanInstances(se)) {
                if (sbInstance.getServiceBeanID().getLeastSignificantBits() != serviceToDestroy.getLeastSignificantBits() || sbInstance.getServiceBeanID().getMostSignificantBits() != serviceToDestroy.getMostSignificantBits()) continue;
                serviceBeanInstance = sbInstance;
                break;
            }
            if (serviceBeanInstance != null) break;
        }
        if (serviceBeanInstance == null) {
            throw new OperationalStringException("Failed to find service id:[" + serviceToDestroy + "] to destroy");
        }
        logger.info("Request to destroy instance [" + serviceBeanInstance.toString() + "] ");
        operationalStringManager.destroy(serviceBeanInstance);
    }

    public int getAgentId() {
        return AgentHelper.getAgentId();
    }

    public String getGSAServiceID() throws RemoteException {
        return AgentHelper.getGSAServiceID();
    }

    public NIODetails getNIODetails() throws RemoteException {
        return NIOInfoHelper.getDetails();
    }

    public NIOStatistics getNIOStatistics() throws RemoteException {
        return NIOInfoHelper.getNIOStatistics();
    }

    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    public long getCurrentTimestamp() throws RemoteException {
        return System.currentTimeMillis();
    }

    public OSDetails getOSDetails() throws RemoteException {
        return OSHelper.getDetails();
    }

    public OSStatistics getOSStatistics() throws RemoteException {
        return OSHelper.getStatistics();
    }

    public JVMDetails getJVMDetails() throws RemoteException {
        return JVMHelper.getDetails();
    }

    public JVMStatistics getJVMStatistics() throws RemoteException {
        return JVMHelper.getStatistics();
    }

    public void runGc() throws RemoteException {
        System.gc();
    }

    public String[] getZones() throws RemoteException {
        return ZoneHelper.getSystemZones();
    }

    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws IOException {
        return InternalLogHelper.logEntriesDirect((LogProcessType)LogProcessType.GSM, (LogEntryMatcher)matcher);
    }

    public void reloadMetricConfiguration() throws RemoteException {
        MetricManager.reloadIfStarted();
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("gsm", this);
        context.put("context-processor", new GsmDumpProcessor());
        return InternalDumpHelper.generateDump(cause, context);
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context, String ... contributors) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("gsm", this);
        context.put("context-processor", new GsmDumpProcessor());
        return InternalDumpHelper.generateDump(cause, context, contributors);
    }

    public byte[] dumpBytes(String file, long from, int length) throws IOException {
        return InternalDumpHelper.dumpBytes(file, from, length);
    }

    public boolean isServiceSecured() throws RemoteException {
        return this.securityInterceptor != null;
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        throw new SecurityException("Invalid method call.");
    }

    public SecurityContext login(SecurityContext securityContext) throws RemoteException {
        if (this.isServiceSecured()) {
            return this.securityInterceptor.authenticate(securityContext);
        }
        return null;
    }

    @Override
    public Events getEvents(long cursor, int maxEvents) {
        return super.getEvents(cursor, maxEvents);
    }

    @Override
    public InternalQuiesceDetails getQuiesceDetails(String processingUnitName) throws RemoteException, OperationalStringException {
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(processingUnitName);
        OperationalString pu = operationalStringManager.getOperationalString();
        return pu.getQuiesceDetails();
    }

    @Override
    public boolean deleteResource(String resourceName) throws RemoteException {
        return FileUtils.deleteFileOrDirectoryIfExists((File)new File(SystemInfo.singleton().locations().deploy() + File.separator + resourceName));
    }

    @Override
    public InternalQuiesceDetails quiesce(String processingUnitName, InternalQuiesceRequest quiesceRequest) throws RemoteException, OperationalStringException, QuiesceFailedException {
        this.checkQuiesceEnabled();
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(processingUnitName);
        OperationalString pu = operationalStringManager.getOperationalString();
        OperationalStringManager operationalStringManager2 = operationalStringManager;
        synchronized (operationalStringManager2) {
            InternalQuiesceDetails details = pu.quiesce(quiesceRequest);
            if (quiesceRequest.getToken().equals(details.getToken())) {
                PoolableThread quiesceThread = this.executeQuiesce(new QuiesceTask(operationalStringManager, details, pu));
                if (quiesceThread == null) {
                    throw new QuiesceFailedException("Failed to submit quiesce task", details.getStatus(), details.getDescription());
                }
                operationalStringManager.setQuiesceThread(quiesceThread);
                return details;
            }
            throw new QuiesceFailedException("Quiesce is already in progress", details.getStatus(), details.getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unquiesce(String processingUnitName, InternalQuiesceRequest quiesceRequest) throws RemoteException, OperationalStringException, QuiesceFailedException {
        this.checkQuiesceEnabled();
        OperationalStringManager operationalStringManager = this.getOperationalStringManager(processingUnitName);
        OperationalString pu = operationalStringManager.getOperationalString();
        OperationalStringManager operationalStringManager2 = operationalStringManager;
        synchronized (operationalStringManager2) {
            InternalQuiesceDetails details = pu.unquiesce(quiesceRequest);
            PoolableThread quiesceThread = this.executeQuiesce(new QuiesceTask(operationalStringManager, details, pu));
            if (quiesceThread == null) {
                throw new QuiesceFailedException("Failed to submit unquiesce task", details.getStatus(), details.getDescription());
            }
            operationalStringManager.setQuiesceThread(quiesceThread);
        }
    }

    private void checkQuiesceEnabled() throws QuiesceFailedException {
        if (QUIESCE_DISABLED) {
            throw new QuiesceFailedException("Quiesce disabled by system property: com.gs.engine.disableQuiesceMode");
        }
    }
}

