/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsm;

import com.gigaspaces.grid.gsm.GSMImpl;
import com.gigaspaces.internal.utils.StringUtils;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.dynamic.LocatorsChangedEvent;
import net.jini.discovery.dynamic.LookupLocatorsChangeListener;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.jsb.ServiceElementUtil;

public class GSMLookupLocatorsChangeListener
implements LookupLocatorsChangeListener {
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.LocatorsChangeListener");
    private final GSMImpl gsm;

    public GSMLookupLocatorsChangeListener(GSMImpl gsm) {
        this.gsm = gsm;
    }

    public void locatorsChanged(LocatorsChangedEvent event) {
        Object[] newLocators = event.getLocators();
        for (OperationalStringManager opStringManager : this.gsm.getOperationalStringManagers()) {
            try {
                for (ServiceElement element : opStringManager.getOperationalString().getServices()) {
                    LookupLocator[] currentLocators;
                    boolean different;
                    if (!opStringManager.isManaging() || !(different = ServiceElementUtil.areLocatorsDifferent(currentLocators = element.getServiceBeanConfig().getLocators(), (LookupLocator[])newLocators))) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Updating service bean config of service element: " + element.getName() + " with new lookup locators: " + StringUtils.arrayToCommaDelimitedString((Object[])newLocators));
                    }
                    opStringManager.updateServiceElement(GSMLookupLocatorsChangeListener.copyServiceElementWithNewLookupLocators(element, (LookupLocator[])newLocators));
                }
            }
            catch (RemoteException ex) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Failed updating service bean config lookup locators", ex);
            }
            catch (OperationalStringException ex) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Failed updating service bean config lookup locators", ex);
            }
        }
    }

    private static ServiceElement copyServiceElementWithNewLookupLocators(ServiceElement element, LookupLocator[] newLocators) {
        ServiceElement newElement = ServiceElementUtil.copyServiceElement(element);
        ServiceBeanConfig sbConfig = ServiceElementUtil.addConfigParameter(newElement.getServiceBeanConfig(), "lookupLocators", newLocators);
        newElement.setServiceBeanConfig(sbConfig);
        return newElement;
    }
}

