/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsm;

import com.gigaspaces.admin.quiesce.QuiesceFailedException;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.gsm.PUsDetails;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.quiesce.InternalQuiesceRequest;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.event.Events;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.resources.servicecore.AbstractProxy;

public class GSMProxy
extends AbstractProxy
implements GSM,
Serializable {
    private static final long serialVersionUID = 1L;

    static GSMProxy getInstance(GSM monitor, Uuid id) {
        if (monitor instanceof RemoteMethodControl) {
            return new ConstrainableGSMProxy(monitor, id, null);
        }
        return new GSMProxy(monitor, id);
    }

    protected GSMProxy(GSM monitor, Uuid id) {
        super(monitor, id);
    }

    @Override
    public OperationalStringManager getPrimary(String name) throws RemoteException, OperationalStringException {
        return ((GSM)this.server).getPrimary(name);
    }

    @Override
    public boolean assignBackupFor(ProvisionMonitor monitor) throws RemoteException {
        return ((GSM)this.server).assignBackupFor(monitor);
    }

    @Override
    public boolean removeBackupFor(ProvisionMonitor monitor) throws RemoteException {
        return ((GSM)this.server).removeBackupFor(monitor);
    }

    @Override
    public boolean isManaging() throws RemoteException {
        return ((GSM)this.server).isManaging();
    }

    @Override
    public void update(ProvisionMonitor.PeerInfo info) throws RemoteException {
        ((GSM)this.server).update(info);
    }

    @Override
    public ProvisionMonitor.PeerInfo getPeerInfo() throws RemoteException {
        return ((GSM)this.server).getPeerInfo();
    }

    @Override
    public Set<String> getExportCodebasesSet() throws RemoteException {
        return ((GSM)this.server).getExportCodebasesSet();
    }

    @Override
    public EventRegistration register(ServiceBeanInstantiator instantiator, MarshalledObject handback, ResourceCapability resourceCapability, int serviceLimit, long duration, ServiceRecord[] serviceRecords) throws LeaseDeniedException, RemoteException {
        return ((GSM)this.server).register(instantiator, handback, resourceCapability, serviceLimit, duration, serviceRecords);
    }

    @Override
    public void update(ServiceBeanInstantiator instantiator, ResourceCapability resourceCapability, int serviceLimit, ServiceRecord[] serviceRecords) throws UnknownLeaseException, RemoteException {
        ((GSM)this.server).update(instantiator, resourceCapability, serviceLimit, serviceRecords);
    }

    @Override
    public boolean hasPUUnderDeploy(String puName) throws RemoteException {
        return ((GSM)this.server).hasPUUnderDeploy(puName);
    }

    @Override
    public String getDeployPath() throws RemoteException {
        return ((GSM)this.server).getDeployPath();
    }

    @Override
    public PUsDetails getPUsDetails() throws RemoteException {
        return ((GSM)this.server).getPUsDetails();
    }

    @Override
    public void relocate(String opStringName, ServiceID serviceToRelocate, ServiceID gscToRelocateTo, ServiceProvisionListener listener) throws RemoteException, OperationalStringException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        ((GSM)this.server).relocate(opStringName, serviceToRelocate, gscToRelocateTo, listener);
    }

    @Override
    public void increment(String opStringName, ServiceProvisionListener listener) throws RemoteException, OperationalStringException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        ((GSM)this.server).increment(opStringName, listener);
    }

    @Override
    public void decrement(String opStringName, ServiceID serviceToDecrement, boolean mandate) throws RemoteException, OperationalStringException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        ((GSM)this.server).decrement(opStringName, serviceToDecrement, mandate);
    }

    @Override
    public boolean decrementPlannedIfPending(String opStringName) throws RemoteException, OperationalStringException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        return ((GSM)this.server).decrementPlannedIfPending(opStringName);
    }

    @Override
    public void updateElasticProperties(String opStringName, Map<String, String> properties) throws RemoteException, OperationalStringException {
        ((GSM)this.server).updateElasticProperties(opStringName, properties);
    }

    @Override
    public void destroy(String opStringName, ServiceID serviceToDestroy) throws RemoteException, OperationalStringException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        ((GSM)this.server).destroy(opStringName, serviceToDestroy);
    }

    public int getAgentId() throws RemoteException {
        return ((GSM)this.server).getAgentId();
    }

    public String getGSAServiceID() throws RemoteException {
        return ((GSM)this.server).getGSAServiceID();
    }

    @Override
    public Events getEvents(long cursor, int maxEvents) {
        return ((GSM)this.server).getEvents(cursor, maxEvents);
    }

    public boolean isServiceSecured() throws RemoteException {
        return ((GSM)this.server).isServiceSecured();
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        return this.login((RemoteSecuredService)this.server, credentialsProvider);
    }

    @Override
    public boolean isOrphanInstancesBeingProvisioned(String opStringName) throws RemoteException {
        if (LRMIUtilities.getServicePlatformLogicalVersion((Object)this.server).greaterOrEquals(PlatformLogicalVersion.v9_7_0) || LRMIUtilities.getServicePlatformLogicalVersion((Object)this.server).patchSameOrGreater(PlatformLogicalVersion.v9_5_2_PATCH3)) {
            return ((GSM)this.server).isOrphanInstancesBeingProvisioned(opStringName);
        }
        return false;
    }

    @Override
    public InternalQuiesceDetails quiesce(String processingUnitName, InternalQuiesceRequest quiesceRequest) throws RemoteException, OperationalStringException, QuiesceFailedException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        return ((GSM)this.server).quiesce(processingUnitName, quiesceRequest);
    }

    @Override
    public void unquiesce(String processingUnitName, InternalQuiesceRequest quiesceRequest) throws RemoteException, OperationalStringException, QuiesceFailedException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        ((GSM)this.server).unquiesce(processingUnitName, quiesceRequest);
    }

    @Override
    public InternalQuiesceDetails getQuiesceDetails(String processingUnitName) throws RemoteException, OperationalStringException {
        return ((GSM)this.server).getQuiesceDetails(processingUnitName);
    }

    @Override
    public boolean deleteResource(String resourceName) throws RemoteException {
        return ((GSM)this.server).deleteResource(resourceName);
    }

    static final class ConstrainableGSMProxy
    extends GSMProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        private ConstrainableGSMProxy(GSM monitor, Uuid id, MethodConstraints constraints) {
            super(ConstrainableGSMProxy.constrainServer(monitor, constraints), id);
        }

        private static GSM constrainServer(GSM monitor, MethodConstraints constraints) {
            Method[] methods = GSM.class.getMethods();
            Method[] methodMapping = new Method[methods.length * 2];
            for (int i = 0; i < methodMapping.length; ++i) {
                methodMapping[i] = methods[i / 2];
            }
            return (GSM)((RemoteMethodControl)monitor).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)constraints, (Method[])methodMapping));
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableGSMProxy((GSM)this.server, this.uuid, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.server).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableGSMProxy.readObject failure - server does not implement constrainable functionality ");
            }
        }
    }
}

