/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.gsm;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalledObject;
import java.util.Map;
import org.jini.rio.core.RequiredDependencies;

public class PUDetails
implements Externalizable {
    private static final long serialVersionUID = 4005114646205838121L;
    private String name;
    private boolean managing;
    private int status;
    private int numberOfInstances;
    private int numberOfBackups;
    private MarshalledObject<?> beanLevelProperties;
    private MarshalledObject<?> sla;
    private Map<String, String> elasticProperties;
    private String processingUnitType;
    private int actualNumberOfInstances;
    private RequiredDependencies instanceDeploymentDependencies;
    private RequiredDependencies instanceStartDependencies;
    private String applicationName;
    private String archiveName;

    public PUDetails() {
    }

    public PUDetails(String name, int status, boolean managing, int numberOfInstances, int numberOfBackups, String processingUnitType, MarshalledObject<?> beanLevelProperties, MarshalledObject<?> sla, Map<String, String> elasticProperties, int actualNumberOfInstances, RequiredDependencies instanceDeploymentDependencies, RequiredDependencies instanceStartDependencies, String applicationName, String archiveName) {
        this.name = name;
        this.managing = managing;
        this.status = status;
        this.numberOfInstances = numberOfInstances;
        this.numberOfBackups = numberOfBackups;
        this.processingUnitType = processingUnitType;
        this.beanLevelProperties = beanLevelProperties;
        this.sla = sla;
        this.elasticProperties = elasticProperties;
        this.actualNumberOfInstances = actualNumberOfInstances;
        this.instanceDeploymentDependencies = instanceDeploymentDependencies;
        this.instanceStartDependencies = instanceStartDependencies;
        this.applicationName = applicationName;
        this.archiveName = archiveName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isManaging() {
        return this.managing;
    }

    public int getStatus() {
        return this.status;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public int getNumberOfBackups() {
        return this.numberOfBackups;
    }

    public String getType() {
        return this.processingUnitType;
    }

    public MarshalledObject<?> getBeanLevelProperties() {
        return this.beanLevelProperties;
    }

    public MarshalledObject<?> getSla() {
        return this.sla;
    }

    public Map<String, String> getElasticProperties() {
        return this.elasticProperties;
    }

    public int getActualNumberOfInstances() {
        return this.actualNumberOfInstances;
    }

    public RequiredDependencies getInstanceDeploymentDependencies() {
        return this.instanceDeploymentDependencies;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public RequiredDependencies getInstanceStartDependencies() {
        return this.instanceStartDependencies;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        out.writeUTF(this.name);
        out.writeBoolean(this.managing);
        out.writeInt(this.status);
        out.writeInt(this.numberOfInstances);
        out.writeInt(this.numberOfBackups);
        out.writeObject(this.beanLevelProperties);
        out.writeObject(this.sla);
        out.writeObject(this.elasticProperties);
        out.writeUTF(this.processingUnitType);
        out.writeInt(this.actualNumberOfInstances);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.instanceDeploymentDependencies);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.instanceStartDependencies);
        IOUtils.writeString((ObjectOutput)out, (String)this.applicationName);
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            IOUtils.writeString((ObjectOutput)out, (String)this.archiveName);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        this.name = in.readUTF();
        this.managing = in.readBoolean();
        this.status = in.readInt();
        this.numberOfInstances = in.readInt();
        this.numberOfBackups = in.readInt();
        this.beanLevelProperties = (MarshalledObject)in.readObject();
        this.sla = (MarshalledObject)in.readObject();
        this.elasticProperties = (Map)in.readObject();
        this.processingUnitType = in.readUTF();
        this.actualNumberOfInstances = in.readInt();
        this.instanceDeploymentDependencies = (RequiredDependencies)IOUtils.readObject((ObjectInput)in);
        this.instanceStartDependencies = (RequiredDependencies)IOUtils.readObject((ObjectInput)in);
        this.applicationName = IOUtils.readString((ObjectInput)in);
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            this.archiveName = IOUtils.readString((ObjectInput)in);
        }
    }
}

