/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.lookup;

import com.gigaspaces.internal.lookup.RegistrarFactory;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.start.SystemBoot;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupHandler {
    static final String BASE_COMPONENT = "com.gigaspaces.grid";
    static final String COMPONENT = "com.gigaspaces.grid.lookup";
    public static final int UNDEFINED = -1;
    String[] configArgs;
    Configuration config;
    Object createdProxy;
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.lookup");

    public LookupHandler(String[] configArgs, LifeCycle lifeCycle) throws IOException, ConfigurationException {
        if (configArgs == null || configArgs.length == 0) {
            throw new ConfigurationException("cannot create an instance of LookupHandler without a configuration");
        }
        this.configArgs = configArgs;
        this.config = ConfigurationProvider.getInstance((String[])configArgs);
        try {
            Registrar impl = RegistrarFactory.createRegistrar((String[])configArgs, (LifeCycle)new ReggieLifeCycle());
            if (impl instanceof ServiceProxyAccessor) {
                this.createdProxy = impl.getServiceProxy();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create reggie", (Throwable)e);
        }
        SystemBoot.addShutdownHook((Thread)((Object)new Shutdown()));
    }

    boolean terminateSelf(ServiceID[] peerIDs) {
        if (this.createdProxy == null) {
            return false;
        }
        boolean terminate = true;
        ServiceID myID = ((ServiceRegistrar)this.createdProxy).getServiceID();
        for (int i = 0; i < peerIDs.length; ++i) {
            if (peerIDs[i].equals((Object)myID) || this.lessThan(myID, peerIDs[i])) continue;
            terminate = false;
            break;
        }
        if (terminate) {
            this.terminateReggie();
        }
        return terminate;
    }

    boolean lessThan(ServiceID id1, ServiceID id2) {
        long val2;
        long val1 = id1.getMostSignificantBits() + id1.getLeastSignificantBits();
        return val1 < (val2 = id2.getMostSignificantBits() + id2.getLeastSignificantBits());
    }

    String getReggieHost(LookupLocator locator) {
        if (locator == null) {
            throw new NullPointerException("locator is null");
        }
        String host = "";
        try {
            host = locator.getHost();
        }
        catch (Exception e) {
            host = "<unknown>";
        }
        host = host + ":" + locator.getPort();
        return host;
    }

    String fromArray(String[] array) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    void terminateReggie() {
        if (this.createdProxy == null) {
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Stopping LUS");
        }
        try {
            Object admin = ((Administrable)this.createdProxy).getAdmin();
            ((DestroyAdmin)admin).destroy();
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, "Terminating ServiceRegistrar", e);
        }
    }

    public static void main(String[] args) {
        try {
            String[] stringArray;
            if (args.length > 0) {
                stringArray = args;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "-";
            }
            String[] configArgs = stringArray;
            new LookupHandler(configArgs, null);
            Thread.sleep(600000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Shutdown
    extends GSThread {
        private volatile boolean ran;

        public Shutdown() {
            super("LookupHandler-Shutdown");
            this.ran = false;
        }

        public void run() {
            if (this.ran) {
                return;
            }
            this.ran = true;
            LookupHandler.this.terminateReggie();
        }
    }

    class ReggieLifeCycle
    implements LifeCycle {
        ReggieLifeCycle() {
        }

        public boolean unregister(Object arg) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ServiceRegistrar terminated");
            }
            LookupHandler.this.createdProxy = null;
            return true;
        }
    }
}

