/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.security.gsa;

import com.gigaspaces.grid.security.interceptor.ProxySecurityInterceptor;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import java.rmi.RemoteException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceRegistrar;
import org.jini.rio.core.JSBControlException;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.resources.servicecore.ServiceAdmin;

public class SecuredServiceAdminProxy<T extends ServiceAdmin>
implements ServiceAdmin {
    protected final T admin;
    protected final ProxySecurityInterceptor securityInterceptor;

    public SecuredServiceAdminProxy(T serviceAdmin, ProxySecurityInterceptor securityInterceptor) {
        this.admin = serviceAdmin;
        this.securityInterceptor = securityInterceptor;
    }

    @Override
    public ServiceRegistrar[] getJoinSet() throws RemoteException {
        return this.admin.getJoinSet();
    }

    @Override
    public ServiceElement getServiceElement() throws RemoteException {
        return this.admin.getServiceElement();
    }

    @Override
    public long getUpTime() throws RemoteException {
        return this.admin.getUpTime();
    }

    @Override
    public void setServiceElement(ServiceElement elem) throws RemoteException {
        this.admin.setServiceElement(elem);
    }

    @Override
    public void advertise() throws JSBControlException, RemoteException {
        this.admin.advertise();
    }

    @Override
    public Object start() throws JSBControlException, RemoteException {
        this.intercept(GridAuthority.GridPrivilege.MANAGE_GRID);
        return this.admin.start();
    }

    @Override
    public void stop(boolean force) throws JSBControlException, RemoteException {
        this.intercept(GridAuthority.GridPrivilege.MANAGE_GRID);
        this.admin.stop(force);
    }

    @Override
    public void unadvertise() throws JSBControlException, RemoteException {
        this.admin.unadvertise();
    }

    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.admin.addLookupAttributes(attrSets);
    }

    public void addLookupGroups(String[] groups) throws RemoteException {
        this.admin.addLookupGroups(groups);
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.admin.addLookupLocators(locators);
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        return this.admin.getLookupAttributes();
    }

    public String[] getLookupGroups() throws RemoteException {
        return this.admin.getLookupGroups();
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.admin.getLookupLocators();
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.admin.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.admin.removeLookupGroups(groups);
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.admin.removeLookupLocators(locators);
    }

    public void setLookupGroups(String[] groups) throws RemoteException {
        this.admin.setLookupGroups(groups);
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.admin.setLookupLocators(locators);
    }

    public void destroy() throws RemoteException {
        this.intercept(GridAuthority.GridPrivilege.MANAGE_GRID);
        this.admin.destroy();
    }

    @Override
    public void undeployEvent() throws RemoteException {
        this.admin.undeployEvent();
    }

    protected void intercept(GridAuthority.GridPrivilege privilege) {
        this.securityInterceptor.intercept((Privilege)privilege);
    }
}

