/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.security.gsm;

import com.gigaspaces.grid.security.interceptor.ProxySecurityInterceptor;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import net.jini.id.Uuid;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceElementTracker;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.resources.resource.PoolableThread;

public class SecuredOperationalStringManager
implements OperationalStringManager {
    private final ProxySecurityInterceptor securityInterceptor;
    private final OperationalStringManager operationalStringManager;

    public SecuredOperationalStringManager(OperationalStringManager operationalStringManager, ProxySecurityInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
        this.operationalStringManager = operationalStringManager;
    }

    @Override
    public void addServiceElement(ServiceElement elem) throws OperationalStringException, RemoteException {
        this.operationalStringManager.addServiceElement(elem);
    }

    @Override
    public void decrement(ServiceBeanInstance instance, boolean mandate, boolean destroy, boolean relocated) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.operationalStringManager.decrement(instance, mandate, destroy, relocated);
    }

    @Override
    public boolean decrementPlannedIfPending(ServiceElement sElem) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        return this.operationalStringManager.decrementPlannedIfPending(sElem);
    }

    @Override
    public void destroy(ServiceBeanInstance instance) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.operationalStringManager.destroy(instance);
    }

    @Override
    public String getDeployPath() throws RemoteException {
        return this.operationalStringManager.getDeployPath();
    }

    @Override
    public long getLastModified(String puName) throws RemoteException {
        return this.operationalStringManager.getLastModified(puName);
    }

    @Override
    public String getDeployURL() throws RemoteException, MalformedURLException {
        return this.operationalStringManager.getDeployURL();
    }

    @Override
    public String getDeployHost() throws RemoteException, MalformedURLException {
        return this.operationalStringManager.getDeployHost();
    }

    @Override
    public String getPeerInfoString() throws RemoteException {
        return this.operationalStringManager.getPeerInfoString();
    }

    @Override
    public Date[] getDeploymentDates() throws RemoteException {
        return this.operationalStringManager.getDeploymentDates();
    }

    @Override
    public OperationalString getOperationalString() throws RemoteException {
        return this.operationalStringManager.getOperationalString();
    }

    @Override
    public int getPendingCount(ServiceElement elem) throws RemoteException {
        return this.operationalStringManager.getPendingCount(elem);
    }

    @Override
    public ServiceBeanInstance[] getServiceBeanInstances(ServiceElement elem) throws OperationalStringException, RemoteException {
        return this.operationalStringManager.getServiceBeanInstances(elem);
    }

    @Override
    public ServiceElement getServiceElement(Object proxy) throws OperationalStringException, RemoteException {
        return this.operationalStringManager.getServiceElement(proxy);
    }

    @Override
    public ServiceElement getServiceElement(String[] interfaces, String name) throws OperationalStringException, RemoteException {
        return this.operationalStringManager.getServiceElement(interfaces, name);
    }

    @Override
    public void increment(ServiceElement elem, boolean permanent, ServiceProvisionListener listener, boolean relocated) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.operationalStringManager.increment(elem, permanent, listener, relocated);
    }

    @Override
    public boolean isManaging() throws RemoteException {
        return this.operationalStringManager.isManaging();
    }

    @Override
    public void redeploy(ServiceElement elem, ServiceBeanInstance instance, boolean clean, long delay, ServiceProvisionListener listener) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.operationalStringManager.redeploy(elem, instance, clean, delay, listener);
    }

    @Override
    public void relocate(ServiceBeanInstance instance, ServiceProvisionListener listener, Uuid uuid) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.operationalStringManager.relocate(instance, listener, uuid);
    }

    @Override
    public void removeServiceElement(ServiceElement elem, boolean destroy) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.operationalStringManager.removeServiceElement(elem, destroy);
    }

    @Override
    public void setManaging(boolean active) throws RemoteException {
        this.operationalStringManager.setManaging(active);
    }

    @Override
    public int trim(ServiceElement elem, int trimUp) throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        return this.operationalStringManager.trim(elem, trimUp);
    }

    @Override
    public boolean undeploy() throws OperationalStringException, RemoteException {
        this.securityInterceptor.intercept((Privilege)GridAuthority.GridPrivilege.PROVISION_PU);
        return this.operationalStringManager.undeploy();
    }

    @Override
    public Map updateOperationalString(OperationalString opstring) throws OperationalStringException, RemoteException {
        return this.operationalStringManager.updateOperationalString(opstring);
    }

    @Override
    public void updateServiceBeanInstance(ServiceBeanInstance instance) throws OperationalStringException, RemoteException {
        this.operationalStringManager.updateServiceBeanInstance(instance);
    }

    @Override
    public void updateServiceElement(ServiceElement elem) throws OperationalStringException, RemoteException {
        this.operationalStringManager.updateServiceElement(elem);
    }

    @Override
    public boolean shouldDispatch(ServiceElement sElem) throws RemoteException {
        return this.operationalStringManager.shouldDispatch(sElem);
    }

    @Override
    public boolean missingInstanceId(ServiceElement sElem) throws RemoteException {
        return this.operationalStringManager.missingInstanceId(sElem);
    }

    @Override
    public ServiceElementTracker getServiceElementTracker(ServiceElement sElem) throws RemoteException {
        return this.operationalStringManager.getServiceElementTracker(sElem);
    }

    @Override
    public InternalQuiesceDetails getQuiesceDetails() throws RemoteException {
        return this.operationalStringManager.getQuiesceDetails();
    }

    @Override
    public void setQuiesceDetails(InternalQuiesceDetails details) throws RemoteException {
        this.operationalStringManager.setQuiesceDetails(details);
    }

    @Override
    public void setQuiesceThread(PoolableThread quiesceThread) throws RemoteException {
        this.operationalStringManager.setQuiesceThread(quiesceThread);
    }
}

