/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.security.gsm;

import com.gigaspaces.grid.security.gsa.SecuredServiceAdminProxy;
import com.gigaspaces.grid.security.gsm.SecuredOperationalStringManager;
import com.gigaspaces.grid.security.interceptor.ProxySecurityInterceptor;
import com.gigaspaces.security.authorities.GridAuthority;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Map;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorAdmin;

public class SecuredProvisionMonitorAdminProxy
extends SecuredServiceAdminProxy<ProvisionMonitorAdmin>
implements ProvisionMonitorAdmin {
    SecuredProvisionMonitorAdminProxy(ProvisionMonitorAdmin admin, ProxySecurityInterceptor securityInterceptor) {
        super(admin, securityInterceptor);
    }

    @Override
    public String getDeployURL() throws RemoteException {
        return ((ProvisionMonitorAdmin)this.admin).getDeployURL();
    }

    @Override
    public ProvisionMonitor.PeerInfo[] getBackupInfo() throws RemoteException {
        return ((ProvisionMonitorAdmin)this.admin).getBackupInfo();
    }

    @Override
    public Map deploy(URL opStringUrl) throws OperationalStringException, RemoteException {
        this.interceptDeploy(SecuredProvisionMonitorAdminProxy.isElastic(opStringUrl));
        return ((ProvisionMonitorAdmin)this.admin).deploy(opStringUrl);
    }

    @Override
    public Map deploy(URL opStringUrl, ServiceProvisionListener listener) throws OperationalStringException, RemoteException {
        this.interceptDeploy(SecuredProvisionMonitorAdminProxy.isElastic(opStringUrl));
        return ((ProvisionMonitorAdmin)this.admin).deploy(opStringUrl, listener);
    }

    @Override
    public Map deploy(OperationalString opstring) throws OperationalStringException, RemoteException {
        this.interceptDeploy(SecuredProvisionMonitorAdminProxy.isElastic(opstring));
        return ((ProvisionMonitorAdmin)this.admin).deploy(opstring);
    }

    @Override
    public Map deploy(OperationalString opstring, ServiceProvisionListener listener) throws OperationalStringException, RemoteException {
        this.interceptDeploy(SecuredProvisionMonitorAdminProxy.isElastic(opstring));
        return ((ProvisionMonitorAdmin)this.admin).deploy(opstring, listener);
    }

    @Override
    public OperationalStringManager getOperationalStringManager(String name) throws OperationalStringException, RemoteException {
        OperationalStringManager operationalStringManager = ((ProvisionMonitorAdmin)this.admin).getOperationalStringManager(name);
        return new SecuredOperationalStringManager(operationalStringManager, this.securityInterceptor);
    }

    @Override
    public OperationalStringManager[] getOperationalStringManagers() throws RemoteException {
        OperationalStringManager[] operationalStringManagers = ((ProvisionMonitorAdmin)this.admin).getOperationalStringManagers();
        for (int i = 0; i < operationalStringManagers.length; ++i) {
            operationalStringManagers[i] = new SecuredOperationalStringManager(operationalStringManagers[i], this.securityInterceptor);
        }
        return operationalStringManagers;
    }

    @Override
    public boolean hasDeployed(String opStringName) throws RemoteException {
        return ((ProvisionMonitorAdmin)this.admin).hasDeployed(opStringName);
    }

    @Override
    public boolean undeploy(String opStringName) throws OperationalStringException, RemoteException {
        this.intercept(GridAuthority.GridPrivilege.PROVISION_PU);
        return ((ProvisionMonitorAdmin)this.admin).undeploy(opStringName);
    }

    @Override
    public boolean removeUndeployed(String opStringName) throws RemoteException {
        this.intercept(GridAuthority.GridPrivilege.PROVISION_PU);
        return ((ProvisionMonitorAdmin)this.admin).removeUndeployed(opStringName);
    }

    private void interceptDeploy(boolean isElastic) {
        this.intercept(GridAuthority.GridPrivilege.PROVISION_PU);
        if (isElastic) {
            this.intercept(GridAuthority.GridPrivilege.MANAGE_GRID);
            this.intercept(GridAuthority.GridPrivilege.MANAGE_PU);
        }
    }

    private static boolean isElastic(URL opStringUrl) {
        return false;
    }

    private static boolean isElastic(OperationalString opstring) {
        ServiceElement[] services = opstring.getServices();
        if (services == null || services.length == 0 || services[0] == null) {
            return false;
        }
        Map<String, String> elasticProperties = services[0].getElasticProperties();
        return elasticProperties != null && !elasticProperties.isEmpty();
    }
}

