/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.security.interceptor;

import com.gigaspaces.grid.security.interceptor.ProxySecurityInterceptor;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.authorities.GrantedAuthorities;
import com.gigaspaces.security.authorities.Privilege;

public class PrivilegedProxySecurityInterceptor
extends ProxySecurityInterceptor {
    private final GrantedAuthorities grantedAuthorities;

    public PrivilegedProxySecurityInterceptor(Authentication authentication) {
        super(authentication.getUserDetails().getUsername());
        this.grantedAuthorities = authentication.getGrantedAuthorities();
        if (this.grantedAuthorities == null) {
            throw new AuthenticationException("Authentication request is invalid");
        }
    }

    @Override
    protected boolean isGranted(Privilege privilege) {
        return this.grantedAuthorities.isGranted(privilege);
    }
}

