/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.security.interceptor;

import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.authorities.Privilege;

public abstract class ProxySecurityInterceptor {
    public static final ProxySecurityInterceptor TRUSTED = new ProxySecurityInterceptor("_trusted"){

        @Override
        protected boolean isGranted(Privilege privilege) {
            return true;
        }
    };
    public static final ProxySecurityInterceptor UNTRUSTED = new ProxySecurityInterceptor("_untrusted"){

        @Override
        protected boolean isGranted(Privilege privilege) {
            throw new AuthenticationException("Authentication request is invalid - you are not logged in.");
        }
    };
    private final String username;

    protected ProxySecurityInterceptor(String username) {
        this.username = username;
    }

    public void intercept(Privilege privilege) {
        if (!this.isGranted(privilege)) {
            throw new AccessDeniedException("User [" + this.username + "] lacks [" + privilege + "] privileges");
        }
    }

    protected abstract boolean isGranted(Privilege var1);
}

