/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.zookeeper;

import com.gigaspaces.grid.zookeeper.ZookeeperConfig;
import com.gigaspaces.grid.zookeeper.ZookeeperServerConfig;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import com.gigaspaces.start.manager.XapManagerConfig;

public class ZookeeperClusterConfig {
    private static final ZookeeperClusterConfig instance = new ZookeeperClusterConfig(SystemInfo.singleton().getManagerClusterInfo());
    private final ZookeeperServerConfig[] servers;
    private final ZookeeperServerConfig currServer;
    private final String desc;

    public ZookeeperClusterConfig(XapManagerClusterInfo managerClusterInfo) {
        this.servers = new ZookeeperServerConfig[managerClusterInfo.getServers().length];
        for (int i = 0; i < this.servers.length; ++i) {
            this.servers[i] = new ZookeeperServerConfig(i + 1, managerClusterInfo.getServers()[i].getHost(), managerClusterInfo.getServers()[i].getZookeeper());
        }
        this.currServer = ZookeeperClusterConfig.findByHost(this.servers, managerClusterInfo.getCurrServer());
        this.desc = ZookeeperClusterConfig.toString(this.servers);
    }

    private static ZookeeperServerConfig findByHost(ZookeeperServerConfig[] servers, XapManagerConfig currHost) {
        if (currHost != null) {
            for (ZookeeperServerConfig server : servers) {
                if (!server.getHost().equals(currHost.getHost())) continue;
                return server;
            }
        }
        return null;
    }

    private static String toString(ZookeeperServerConfig[] servers) {
        StringBuilder sb = new StringBuilder();
        for (ZookeeperServerConfig server : servers) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(server.toString());
        }
        return sb.toString();
    }

    public static ZookeeperClusterConfig getInstance() {
        return instance;
    }

    public ZookeeperServerConfig getCurrServer() {
        return this.currServer;
    }

    public ZookeeperServerConfig[] getServers() {
        return this.servers;
    }

    public boolean isEmpty() {
        return this.servers.length == 0 || this.servers[0].getHost().equals("");
    }

    public String generateConnectionString(ZookeeperConfig config) {
        String clientPort = config.getClientPort();
        String result = "";
        for (ZookeeperServerConfig zkServer : this.servers) {
            if (result.length() != 0) {
                result = result + ",";
            }
            result = result + zkServer.getHost() + ":" + clientPort;
        }
        return result;
    }

    public String toString() {
        return this.desc;
    }
}

