/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.zookeeper;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ZookeeperConfig {
    private static final String DEFAULT_CLIENT_PORT = "2181";
    private static final ZookeeperConfig instance = new ZookeeperConfig(ZookeeperConfig.findZookeeperConfigFile());
    private final Properties properties = new Properties();

    public static ZookeeperConfig getDefaultConfig() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZookeeperConfig(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Zookeeper client file path is not defined in system property nor environment variable.");
        }
        File configFile = new File(path);
        if (!configFile.exists()) {
            throw new IllegalArgumentException("File not found: " + path);
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            this.properties.load(in);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read properties from " + path);
        }
        StringUtils.resolvePlaceholders((Properties)this.properties);
    }

    public String getClientPort() {
        return this.properties.getProperty("clientPort", DEFAULT_CLIENT_PORT);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void saveToFile(File target) throws IOException {
        try (FileOutputStream fileOut = new FileOutputStream(target);){
            this.properties.store(fileOut, "");
        }
    }

    private static String findZookeeperConfigFile() {
        String result = System.getProperty("com.gs.zookeeper.config-file");
        if (result == null) {
            result = System.getenv("XAP_ZOOKEEPER_SERVER_CONFIG_FILE");
        }
        if (result == null) {
            result = SystemInfo.singleton().locations().config() + "/zookeeper/zoo.cfg";
        }
        return result;
    }
}

