/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class InternalAbstractDump
implements InternalDump {
    private final long timestamp;
    private final String cause;
    private final Map<String, Object> context;
    private final ArrayList<File> files = new ArrayList();
    private final LinkedList<String> prefixes = new LinkedList();

    protected InternalAbstractDump(long timestamp, String cause, Map<String, Object> context) {
        this.timestamp = timestamp;
        this.cause = cause;
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        this.context = context;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Map<String, Object> context() {
        return this.context;
    }

    public String cause() {
        return this.cause;
    }

    public File[] files() {
        return this.files.toArray(new File[this.files.size()]);
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void removePrefix() {
        this.prefixes.removeLast();
    }

    public File createFile(String name) throws InternalDumpException {
        StringBuffer actualName = new StringBuffer();
        for (String prefix : this.prefixes) {
            actualName.append(prefix);
        }
        actualName.append(name);
        File file = this.doCreateFile(actualName.toString());
        if (!file.isDirectory()) {
            file.deleteOnExit();
            this.files.add(file);
        }
        file.getParentFile().mkdirs();
        return file;
    }

    protected abstract File doCreateFile(String var1) throws InternalDumpException;

    public FileOutputStream createFileOutputStream(String name) throws InternalDumpException {
        try {
            return new FileOutputStream(this.createFile(name));
        }
        catch (FileNotFoundException e) {
            throw new InternalDumpException("Failed to create file [" + name + "]", (Throwable)e);
        }
    }

    public FileWriter createFileWriter(String name) throws InternalDumpException {
        try {
            return new FileWriter(this.createFile(name));
        }
        catch (IOException e) {
            throw new InternalDumpException("Failed to create file [" + name + "]", (Throwable)e);
        }
    }
}

