/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump;

import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpGenerator;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.internal.dump.InternalSimpleDumpGenerator;
import com.gigaspaces.internal.dump.heap.HeapDumpProcessor;
import com.gigaspaces.internal.dump.log.AllAgentsLogsDumpProcessor;
import com.gigaspaces.internal.dump.log.LogDumpProcessor;
import com.gigaspaces.internal.dump.network.NetworkDumpProcessor;
import com.gigaspaces.internal.dump.pu.ProcessingUnitsDumpProcessor;
import com.gigaspaces.internal.dump.summary.SummaryDumpProcessor;
import com.gigaspaces.internal.dump.thread.ThreadDumpProcessor;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InternalDumpHelper {
    private static InternalDumpGenerator dumpGenerator;
    private static File dumpLocation;

    public static InternalDumpResult generateDump(String cause, Map<String, Object> context) throws InternalDumpException {
        return InternalDumpHelper.generateDump(cause, context, null);
    }

    public static InternalDumpResult generateDump(String cause, Map<String, Object> context, String ... processors) throws InternalDumpException {
        File[] xFiles;
        InternalDumpGenerator.Result result = dumpGenerator.generateDump(cause, context, processors);
        ArrayList<InternalDumpResult.FileInfo> files = new ArrayList<InternalDumpResult.FileInfo>();
        for (File xFile : xFiles = result.files()) {
            String name = xFile.getAbsolutePath().substring(result.location().getAbsolutePath().length() + 1);
            name = name.replace('\\', '/');
            files.add(new InternalDumpResult.FileInfo(name, xFile.length()));
        }
        return new InternalDumpResult(result.getFileName(), result.location().getAbsolutePath(), files.toArray(new InternalDumpResult.FileInfo[files.size()]), result.failedProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dumpBytes(String file, long from, int length) throws RemoteException, IOException {
        try (RandomAccessFile raf = new RandomAccessFile(new File(dumpLocation, file), "r");){
            raf.seek(from);
            if (from + (long)length > raf.length()) {
                length = (int)(raf.length() - from);
            }
            byte[] toRead = new byte[length];
            raf.readFully(toRead);
            byte[] byArray = toRead;
            return byArray;
        }
    }

    static {
        File workLocation = new File(SystemInfo.singleton().locations().work());
        HashMap<String, InternalDumpProcessor> processorMap = new HashMap<String, InternalDumpProcessor>();
        processorMap.put("summary", new SummaryDumpProcessor());
        processorMap.put("network", new NetworkDumpProcessor());
        processorMap.put("thread", new ThreadDumpProcessor());
        processorMap.put("heap", new HeapDumpProcessor());
        processorMap.put("log", new LogDumpProcessor());
        processorMap.put("all-agents-logs", new AllAgentsLogsDumpProcessor());
        processorMap.put("processingUnits", new ProcessingUnitsDumpProcessor());
        dumpLocation = new File(workLocation, "dump");
        dumpGenerator = new InternalSimpleDumpGenerator(dumpLocation, processorMap);
    }
}

