/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump;

import com.gigaspaces.internal.dump.DumpContextConstants;
import com.gigaspaces.internal.dump.DumpUtils;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpGenerator;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.dump.InternalSimpleDump;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InternalSimpleDumpGenerator
implements InternalDumpGenerator,
DumpContextConstants {
    private final File dumpLocation;
    private final Map<String, InternalDumpProcessor> processors;

    public InternalSimpleDumpGenerator(File dumpLocation, Map<String, InternalDumpProcessor> processors) {
        this.dumpLocation = dumpLocation;
        this.processors = processors;
    }

    @Override
    public InternalDumpGenerator.Result generateDump(String cause, Map<String, Object> context) throws InternalDumpException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public InternalDumpGenerator.Result generateDump(String cause, Map<String, Object> context, String ... processors) throws InternalDumpException {
        InternalSimpleDump dump;
        LogProcessType processType;
        if (processors == null) {
            processors = this.processors.keySet().toArray(new String[this.processors.size()]);
        }
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        String serviceTypeName = (processType = InternalLogHelper.parseProcessTypeFromSystemProperty()) != null ? processType.name().toLowerCase() + "-" : "";
        String parentDirName = context.get("parentDirName") == null ? "" : context.get("parentDirName") + File.separator;
        String fileName = parentDirName + serviceTypeName + SystemInfo.singleton().network().getHostId() + "-pid-" + SystemInfo.singleton().os().processId();
        File file = new File(this.dumpLocation, fileName);
        file.mkdirs();
        DumpUtils.cleanHProfFileIfExist(file, context);
        try {
            dump = new InternalSimpleDump(System.currentTimeMillis(), cause, context, file);
        }
        catch (FileNotFoundException e) {
            throw new InternalDumpException("Failed to generate dump", (Throwable)e);
        }
        ArrayList<InternalDumpProcessorFailedException> failedProcesors = new ArrayList<InternalDumpProcessorFailedException>();
        for (String string : processors) {
            InternalDumpProcessor processor = this.processors.get(string);
            if (processor == null) {
                failedProcesors.add(new InternalDumpProcessorFailedException(string, "No processor"));
                continue;
            }
            if (string.equals("all-agents-logs") && !context.containsKey("gsa")) continue;
            try {
                processor.process((InternalDump)dump);
            }
            catch (InternalDumpProcessorFailedException e) {
                failedProcesors.add(e);
            }
            catch (Exception e) {
                failedProcesors.add(new InternalDumpProcessorFailedException(processor.getName(), "Failed", (Throwable)e));
            }
        }
        InternalDumpProcessor contextProcessor = (InternalDumpProcessor)context.get("context-processor");
        if (contextProcessor != null) {
            try {
                contextProcessor.process((InternalDump)dump);
            }
            catch (InternalDumpProcessorFailedException e) {
                failedProcesors.add(e);
            }
            catch (Exception e) {
                failedProcesors.add(new InternalDumpProcessorFailedException(contextProcessor.getName(), "Failed", (Throwable)e));
            }
        }
        if (!failedProcesors.isEmpty()) {
            PrintWriter writer = new PrintWriter(dump.createFileWriter("failed-dump-processors.txt"));
            for (Exception exception : failedProcesors) {
                exception.printStackTrace(writer);
                writer.println();
                writer.println();
            }
            writer.close();
        }
        dump.finish();
        return new InternalDumpGenerator.Result(file, fileName, failedProcesors.toArray(new InternalDumpProcessorFailedException[failedProcesors.size()]), dump.files());
    }
}

