/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.gsm;

import com.gigaspaces.grid.gsm.GSMImpl;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.PrintWriter;

public class GsmDumpProcessor
implements InternalDumpProcessor {
    public static final String NAME = "gsm";

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InternalDump dump) {
        if (!dump.context().containsKey(NAME)) {
            return;
        }
        GSMImpl gsm = (GSMImpl)dump.context().get(NAME);
        PrintWriter writer = new PrintWriter(dump.createFileWriter("gsm-state.txt"));
        try {
            gsm.dumpGSMInfo(writer);
            gsm.dumpProcessingUnits(writer);
            gsm.dumpServiceElementInstances(writer);
            gsm.dumpGridServiceContainersRegistered(writer);
            gsm.dumpGridServiceManagersRegistered(writer);
        }
        catch (Exception e) {
            writer.println("Caught Exception while trying to dump GSM state: " + JSpaceUtilities.getStackTrace((Throwable)e));
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }
}

