/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.heap;

import com.gigaspaces.internal.dump.DumpUtils;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeapDumpProcessor
implements InternalDumpProcessor {
    public static final String NAME = "heap";
    private final Method heapDumpMethod;
    private final Object diagnosticMBean;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.service");
    private final String javaVendor;

    public HeapDumpProcessor() {
        Object diagnosticMBean;
        Method heapDumpMethod;
        block6: {
            this.javaVendor = System.getProperty("java.vendor");
            try {
                String javaVersion = System.getProperty("java.version");
                if (this.javaVendor.contains("IBM")) {
                    Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump", true, HeapDumpProcessor.class.getClassLoader());
                    heapDumpMethod = dumpClass.getMethod("HeapDump", new Class[0]);
                    diagnosticMBean = null;
                    break block6;
                }
                if (javaVersion.indexOf("1.6") >= 0 || javaVersion.indexOf("1.5") >= 0) {
                    Class<?> managementFactoryClass = Class.forName("sun.management.ManagementFactory", true, HeapDumpProcessor.class.getClassLoader());
                    Method method = managementFactoryClass.getMethod("getDiagnosticMXBean", new Class[0]);
                    diagnosticMBean = method.invoke(null, new Object[0]);
                    heapDumpMethod = diagnosticMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
                    break block6;
                }
                if (javaVersion.indexOf("1.7") >= 0 || javaVersion.indexOf("1.8") >= 0) {
                    Class<?> managementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper", true, HeapDumpProcessor.class.getClassLoader());
                    Method method = managementFactoryHelperClass.getMethod("getDiagnosticMXBean", new Class[0]);
                    diagnosticMBean = method.invoke(null, new Object[0]);
                    heapDumpMethod = diagnosticMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
                    break block6;
                }
                if (javaVersion.indexOf("9.") >= 0 || javaVersion.indexOf("10.") >= 0 || javaVersion.indexOf("11.") >= 0) {
                    Class<?> managementFactoryClass = Class.forName("java.lang.management.ManagementFactory", true, HeapDumpProcessor.class.getClassLoader());
                    Method method = managementFactoryClass.getMethod("getPlatformMXBean", Class.class);
                    diagnosticMBean = method.invoke(null, Class.forName("com.sun.management.HotSpotDiagnosticMXBean", true, HeapDumpProcessor.class.getClassLoader()));
                    heapDumpMethod = diagnosticMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
                    break block6;
                }
                throw new UnsupportedOperationException("Unhandled Java version: " + javaVersion);
            }
            catch (Exception _ex) {
                heapDumpMethod = null;
                diagnosticMBean = null;
                _logger.log(Level.SEVERE, _ex.toString(), _ex);
            }
        }
        this.heapDumpMethod = heapDumpMethod;
        this.diagnosticMBean = diagnosticMBean;
    }

    public String getName() {
        return NAME;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        if (this.heapDumpMethod == null) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Heap dump not enabled on this JVM");
        }
        try {
            if (this.javaVendor.contains("IBM")) {
                this.heapDumpMethod.invoke(null, new Object[0]);
            } else {
                String hprofFileName = DumpUtils.getHprofFileName(dump.context());
                _logger.info("creating dump file " + hprofFileName);
                this.heapDumpMethod.invoke(this.diagnosticMBean, dump.createFile(hprofFileName).getAbsolutePath(), true);
            }
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to generate heap dump", (Throwable)e);
        }
    }
}

