/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.log;

import com.gigaspaces.grid.gsa.AgentProcessDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.log.ContainsStringLogEntryMatcher;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatchers;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.logger.RollingFileHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AllAgentsLogsDumpProcessor
implements InternalDumpProcessor {
    public static final String NAME = "all-agents-logs";
    private static final String COMPONENT = "com.gigaspaces.internal.dump.log.AllAgentsLogsDumpProcessor";
    private static final Logger logger = Logger.getLogger("com.gigaspaces.internal.dump.log.AllAgentsLogsDumpProcessor");

    public String getName() {
        return NAME;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        dump.addPrefix("logs/");
        try {
            GSA gsa = (GSA)dump.context().get("gsa");
            if (gsa != null) {
                File logDir = RollingFileHandler.filesCreated()[0].getParentFile();
                List<File> logFiles = this.getAllGSAAgentsLogFiles(logDir, gsa);
                for (File file : logFiles) {
                    FileChannel source = new FileInputStream(file).getChannel();
                    FileChannel target = dump.createFileOutputStream(file.getName()).getChannel();
                    target.transferFrom(source, 0L, source.size());
                }
            }
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to copy over log files", (Throwable)e);
        }
        finally {
            dump.removePrefix();
        }
    }

    private List<File> getAllGSAAgentsLogFiles(File logDir, GSA gsa) throws RemoteException {
        String[] components = new String[]{LogProcessType.GSM.name().toLowerCase(), LogProcessType.GSC.name().toLowerCase(), LogProcessType.LUS.name().toLowerCase(), LogProcessType.ESM.name().toLowerCase(), LogProcessType.MANAGER.name().toLowerCase()};
        AgentProcessDetails[] processDetails = gsa.getDetails().getProcessDetails();
        Set<AgentLogFileNameProperties> existingAgentProperties = this.transformAgentProcessDetails(processDetails);
        ArrayList<File> resultFilesList = new ArrayList<File>();
        long gsaStartTime = gsa.getJVMDetails().getStartTime();
        for (String component : components) {
            Set<AgentLogFileNameProperties> pids = this.scanGSALogsForAgentIdWithMatcher(gsa, "[" + component + "][", existingAgentProperties);
            resultFilesList.addAll(this.getAgentsLogs(logDir, component, pids, gsaStartTime));
        }
        return resultFilesList;
    }

    private Set<AgentLogFileNameProperties> transformAgentProcessDetails(AgentProcessDetails[] processDetails) {
        HashSet<AgentLogFileNameProperties> result = new HashSet<AgentLogFileNameProperties>();
        for (AgentProcessDetails agentProcessDetails : processDetails) {
            if (agentProcessDetails.getServiceType().equals("zk")) continue;
            int agentId = agentProcessDetails.getAgentId();
            long processId = agentProcessDetails.getProcessId();
            result.add(new AgentLogFileNameProperties(processId, agentId));
        }
        return result;
    }

    private Set<AgentLogFileNameProperties> scanGSALogsForAgentIdWithMatcher(GSA gsa, String matcherStr, Set<AgentLogFileNameProperties> existingAgentProperties) {
        try {
            ContainsStringLogEntryMatcher agentLogMatcher = LogEntryMatchers.containsString((String)matcherStr);
            LogEntries gsaLogEntries = gsa.logEntriesDirect((LogEntryMatcher)agentLogMatcher);
            return this.getAgentsLogFileNameProperties(gsaLogEntries, existingAgentProperties);
        }
        catch (IOException ioe) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to fetch logs from gsa", (Throwable)ioe);
        }
    }

    private Set<AgentLogFileNameProperties> getAgentsLogFileNameProperties(LogEntries gsaLogEntries, Set<AgentLogFileNameProperties> existingAgentProperties) {
        HashSet<AgentLogFileNameProperties> pidsSet = new HashSet<AgentLogFileNameProperties>();
        int entriesSize = gsaLogEntries.getEntries().size();
        if (entriesSize > 0) {
            for (int index = 0; index < entriesSize; ++index) {
                String pidSubstring;
                int agentPidIndexEnd;
                int agentPidIndexStart;
                String line = ((LogEntry)gsaLogEntries.getEntries().get(index)).getText();
                int agentIdIndexStart = line.indexOf("][");
                if (agentIdIndexStart <= 0 || (agentPidIndexStart = line.indexOf(47, agentIdIndexStart)) <= 0 || (agentPidIndexEnd = line.indexOf(93, agentPidIndexStart)) <= agentPidIndexStart || (pidSubstring = line.substring(agentPidIndexStart + 1, agentPidIndexEnd)).isEmpty()) continue;
                try {
                    String agentIdSubstring = line.substring(agentIdIndexStart + 2, agentPidIndexStart);
                    int agentId = Integer.valueOf(agentIdSubstring);
                    long pid = Integer.valueOf(pidSubstring).intValue();
                    AgentLogFileNameProperties foundAgentLogFileNameProperties = new AgentLogFileNameProperties(pid, agentId);
                    if (existingAgentProperties.contains(foundAgentLogFileNameProperties)) continue;
                    pidsSet.add(foundAgentLogFileNameProperties);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return pidsSet;
    }

    private List<File> getAgentsLogs(File logDir, String typeName, Set<AgentLogFileNameProperties> properties, long gsaStartTime) {
        ArrayList<File> filesList = new ArrayList<File>();
        for (AgentLogFileNameProperties agentLogFileNameProperties : properties) {
            int agentId = agentLogFileNameProperties.getAgentId();
            long pid = agentLogFileNameProperties.getPid();
            File[] agentsLogs = this.getAgentsLogs(logDir, typeName, pid, agentId, gsaStartTime);
            filesList.addAll(Arrays.asList(agentsLogs));
        }
        return filesList;
    }

    private File[] getAgentsLogs(File logDir, final String typeName, final long pid, final int agentId, final long gsaStartTime) {
        return BootIOUtils.listFiles((File)logDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                block3: {
                    boolean isFilteringByPidAndAgentIdPassed;
                    String name = file.getName();
                    String nameInLowerCase = name.toLowerCase();
                    boolean bl = isFilteringByPidAndAgentIdPassed = nameInLowerCase.contains("-" + pid) || nameInLowerCase.contains("_" + pid) && (nameInLowerCase.contains("_" + typeName + "_" + agentId) || nameInLowerCase.contains("-" + typeName + "_" + agentId));
                    if (isFilteringByPidAndAgentIdPassed) {
                        Path filePath = file.toPath();
                        try {
                            BasicFileAttributes attr = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                            long creationTime = attr.creationTime().to(TimeUnit.MILLISECONDS);
                            return creationTime > gsaStartTime;
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.SEVERE)) break block3;
                            logger.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                }
                return false;
            }
        });
    }

    private class AgentLogFileNameProperties {
        private final long _pid;
        private final int _agentId;

        public AgentLogFileNameProperties(long pid, int agentId) {
            this._pid = pid;
            this._agentId = agentId;
        }

        public long getPid() {
            return this._pid;
        }

        public int getAgentId() {
            return this._agentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AgentLogFileNameProperties that = (AgentLogFileNameProperties)o;
            if (this._pid != that._pid) {
                return false;
            }
            return this._agentId == that._agentId;
        }

        public int hashCode() {
            int result = (int)(this._pid ^ this._pid >>> 32);
            result = 31 * result + this._agentId;
            return result;
        }
    }
}

