/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.log;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.log.StreamLogEntryMatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.List;

public class LogDumpProcessor
implements InternalDumpProcessor {
    public static final String NAME = "log";

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        block17: {
            dump.addPrefix("logs/");
            try {
                LogEntryMatcher logMatcher = (LogEntryMatcher)dump.context().get("logEntryMatcher");
                if (logMatcher == null) {
                    try {
                        File[] files;
                        for (File file : files = InternalLogHelper.logFiles()) {
                            FileChannel source = new FileInputStream(file).getChannel();
                            FileChannel target = dump.createFileOutputStream(file.getName()).getChannel();
                            target.transferFrom(source, 0L, source.size());
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        throw new InternalDumpProcessorFailedException(this.getName(), "Failed to copy over log files", (Throwable)e);
                    }
                }
                LogProcessType logProcessType = InternalLogHelper.parseProcessTypeFromSystemProperty();
                if (logProcessType == null) {
                    throw new InternalDumpProcessorFailedException(this.getName(), "Can't determine log process type");
                }
                PrintWriter writer = new PrintWriter(dump.createFileWriter("log.log"));
                try {
                    if (logMatcher instanceof StreamLogEntryMatcher) {
                        block8: while (true) {
                            LogEntries logEntries = InternalLogHelper.logEntriesDirect((LogProcessType)logProcessType, (LogEntryMatcher)logMatcher);
                            if ((logEntries = InternalLogHelper.clientSideProcess((LogEntryMatcher)logMatcher, (LogEntries)logEntries)) != null) {
                                List list = logEntries.logEntries();
                                Iterator file = list.iterator();
                                while (true) {
                                    if (!file.hasNext()) continue block8;
                                    LogEntry logEntry = (LogEntry)file.next();
                                    writer.println(logEntry.getText());
                                }
                            }
                            break;
                        }
                    } else {
                        LogEntries logEntries = InternalLogHelper.logEntriesDirect((LogProcessType)logProcessType, (LogEntryMatcher)logMatcher);
                        if ((logEntries = InternalLogHelper.clientSideProcess((LogEntryMatcher)logMatcher, (LogEntries)logEntries)) != null) {
                            for (LogEntry logEntry : logEntries.logEntries()) {
                                writer.println(logEntry.getText());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new InternalDumpProcessorFailedException(this.getName(), "Failed to fetch logs", (Throwable)e);
                }
                writer.close();
            }
            finally {
                dump.removePrefix();
            }
        }
    }
}

