/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.network;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.LRMIServiceMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import java.io.PrintWriter;

public class NetworkDumpProcessor
implements InternalDumpProcessor {
    public static final String NAME = "network";

    public String getName() {
        return NAME;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        PrintWriter writer = new PrintWriter(dump.createFileWriter("network.txt"));
        try {
            writer.println("===== LRMI =====");
            NIODetails details = NIOInfoHelper.getDetails();
            NIOStatistics stats = NIOInfoHelper.getNIOStatistics();
            writer.println("Bind Host [" + details.getBindHost() + "], Port [" + details.getPort() + "]");
            writer.println("Threads: Min [" + details.getMinThreads() + "], Max [" + details.getMaxThreads() + "], Active [" + stats.getActiveThreadsCount() + "]");
            writer.println("Work Queue: Size [" + stats.getQueueSize() + "], Completed [" + stats.getCompletedTaskCount() + "]");
            if (LRMIRuntime.getRuntime().isMonitorActivity()) {
                LRMIMonitoringDetails trackingDetails = NIOInfoHelper.fetchMonitoringDetails();
                writer.println("Exported Services Inbound Monitoring Details: ");
                for (LRMIServiceMonitoringDetails lRMIServiceMonitoringDetails : trackingDetails.getInboundMonitoringDetails().getServicesMonitoringDetails()) {
                    writer.println(lRMIServiceMonitoringDetails);
                }
                writer.println("Proxies Outbound Monitoring Details: ");
                for (LRMIServiceMonitoringDetails lRMIServiceMonitoringDetails : trackingDetails.getOutboundMonitoringDetails().getProxiesMonitoringDetails()) {
                    writer.println(lRMIServiceMonitoringDetails);
                }
            }
            writer.println("");
            writer.println("===== NETWORK =====");
            OSStatistics osStats = OSHelper.getStatistics();
            if (osStats.getNetStats() != null) {
                writer.println("Name\tRx Bytes\tRx Packets\tRx Dropped\tRx Errors\tTx Bytes\tTx Packets\tTx Dropped\tTx Errors\t");
                for (LRMIServiceMonitoringDetails lRMIServiceMonitoringDetails : osStats.getNetStats()) {
                    writer.print(lRMIServiceMonitoringDetails.getName() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getRxBytes() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getRxPackets() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getRxDropped() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getRxErrors() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getTxBytes() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getTxPackets() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getTxDropped() + "\t");
                    writer.print(lRMIServiceMonitoringDetails.getTxErrors() + "\t");
                }
            }
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to generate", (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }
}

