/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.summary;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SummaryDumpProcessor
implements InternalDumpProcessor {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final Object formatterLock = new Object();
    public static final String NAME = "summary";
    static double megabytesFactor = 9.53674316 * Math.pow(10.0, -7.0);

    public String getName() {
        return NAME;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        PrintWriter writer = new PrintWriter(dump.createFileWriter("summary.txt"));
        try {
            this.processHeader(writer, dump.timestamp());
            this.processCause(writer, dump.cause());
            this.processThrowables(writer, dump);
            this.processJvm(writer);
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to generate", (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeader(PrintWriter writer, long timestamp) {
        Object object = this.formatterLock;
        synchronized (object) {
            writer.println("===== TIME =====");
            writer.println(this.dateFormat.format(new Date(timestamp)));
            writer.println();
        }
    }

    private void processCause(PrintWriter writer, String cause) {
        writer.println("===== CAUSE =====");
        writer.println(cause);
        writer.println();
    }

    private void processThrowables(PrintWriter writer, InternalDump dump) {
        writer.println("===== EXCEPTIONS =====");
        Object throwables = dump.context().get("throwables");
        if (throwables == null) {
            return;
        }
        if (throwables instanceof Throwable[]) {
            Throwable[] array;
            for (Throwable t : array = (Throwable[])throwables) {
                writer.println();
                writer.println("---- Exception ----");
                t.printStackTrace(writer);
            }
        } else if (throwables instanceof Collection) {
            Collection collection = (Collection)throwables;
            for (Object o : collection) {
                Throwable t = (Throwable)o;
                writer.println();
                writer.println("---- Exception ----");
                t.printStackTrace(writer);
            }
        } else {
            throw new InternalDumpProcessorFailedException(this.getName(), "Can't handle throwables type [" + throwables.getClass() + "]");
        }
        writer.println();
    }

    public void processJvm(PrintWriter writer) {
        JVMDetails details = JVMHelper.getDetails();
        JVMStatistics stats = JVMHelper.getStatistics();
        writer.println("===== JVM =====");
        writer.println();
        writer.println("Start Time: " + new Date(details.getStartTime()));
        writer.println("Name [" + details.getVmName() + "], Version[" + details.getVmVersion() + "], Vendor [" + details.getVmVendor() + "]");
        writer.println();
        writer.println("----- Memory -----");
        writer.println("Heap: Init[" + SummaryDumpProcessor.convertToMB(details.getMemoryHeapInit()) + "mb], Max [" + SummaryDumpProcessor.convertToMB(details.getMemoryHeapMax()) + "mb], Used[" + SummaryDumpProcessor.convertToMB(stats.getMemoryHeapUsed()) + "mb], Committed [" + SummaryDumpProcessor.convertToMB(stats.getMemoryHeapCommitted()) + "mb]");
        writer.println("NonHeap: Init[" + SummaryDumpProcessor.convertToMB(details.getMemoryNonHeapInit()) + "mb], Max [" + SummaryDumpProcessor.convertToMB(details.getMemoryNonHeapMax()) + "mb], Used[" + SummaryDumpProcessor.convertToMB(stats.getMemoryNonHeapUsed()) + "mb], Committed [" + SummaryDumpProcessor.convertToMB(stats.getMemoryNonHeapCommitted()) + "mb]");
        writer.println();
        writer.println("----- Garbage Collection -----");
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : gcMxBeans) {
            writer.println(garbageCollectorMXBean.getName() + ": Collection Time [" + garbageCollectorMXBean.getCollectionTime() + "], Collection Count [" + garbageCollectorMXBean.getCollectionCount() + "]");
        }
        writer.println();
        writer.println("----- Threads -----");
        writer.println("Thread Count [" + stats.getThreadCount() + "], Peak Thread Count [" + stats.getPeakThreadCount() + "]");
        writer.println();
        writer.println("----- System Properties -----");
        for (Map.Entry entry : details.getSystemProperties().entrySet()) {
            writer.print((String)entry.getKey());
            writer.print("=");
            writer.println((String)entry.getValue());
        }
        writer.println();
        writer.println("----- Class Path -----");
        writer.println(details.getClassPath());
        writer.println();
        writer.println("----- Boot Class Path -----");
        writer.println(details.getBootClassPath());
        writer.println();
        writer.println("----- Input Arguments -----");
        for (Iterator<Object> iterator : details.getInputArguments()) {
            writer.print((String)((Object)iterator));
            writer.print(",");
        }
        writer.println();
        writer.println();
    }

    public static double convertToMB(long bytes) {
        return megabytesFactor * (double)bytes;
    }
}

